/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInspection.sameParameterValue.SameParameterValueInspection;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineLocalHandler;
import com.intellij.refactoring.inline.InlineParameterDialog;
import com.intellij.refactoring.inline.InlineParameterExpressionProcessor;
import com.intellij.refactoring.inline.InlineToAnonymousConstructorProcessor;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineParameterHandler
extends JavaInlineActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineParameterHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.parameter.refactoring");
    public static final String REFACTORING_ID = "refactoring.inline.parameter";

    public boolean canInlineElement(PsiElement element) {
        PsiElement parent;
        return element instanceof PsiParameter && (parent = element.getParent()) instanceof PsiParameterList && parent.getParent() instanceof PsiMethod && element.getLanguage() == JavaLanguage.INSTANCE;
    }

    public void inlineElement(Project project2, Editor editor, PsiElement psiElement) {
        PsiElement[] refs;
        PsiExpression toInline;
        Object rExpr;
        PsiElement def;
        PsiElement[] defs;
        final PsiParameter psiParameter = (PsiParameter)psiElement;
        PsiParameterList parameterList = (PsiParameterList)psiParameter.getParent();
        if (!(parameterList.getParent() instanceof PsiMethod)) {
            return;
        }
        int index = parameterList.getParameterIndex(psiParameter);
        final PsiMethod method2 = (PsiMethod)parameterList.getParent();
        String errorMessage = InlineParameterHandler.getCannotInlineMessage(psiParameter, method2);
        if (errorMessage != null) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)errorMessage, (String)RefactoringBundle.message((String)"inline.parameter.refactoring"), null);
            return;
        }
        Ref refInitializer = new Ref();
        Ref refConstantInitializer = new Ref();
        Ref refMethodCall = new Ref();
        List occurrences = Collections.synchronizedList(new ArrayList());
        Set<PsiFile> containingFiles = Collections.synchronizedSet(new HashSet());
        containingFiles.add(psiParameter.getContainingFile());
        boolean[] result2 = new boolean[1];
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            result2[0] = ReferencesSearch.search((PsiElement)method2).forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                PsiElement parent = element.getParent();
                if (parent instanceof PsiCallExpression) {
                    PsiCallExpression methodCall = (PsiCallExpression)parent;
                    occurrences.add(psiReference);
                    containingFiles.add(element.getContainingFile());
                    PsiExpression[] expressions = methodCall.getArgumentList().getExpressions();
                    if (expressions.length <= index) {
                        return false;
                    }
                    PsiExpression argument = expressions[index];
                    if (!refInitializer.isNull()) {
                        return argument != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)refInitializer.get()), (PsiElement)argument) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)refMethodCall.get()), (PsiElement)methodCall);
                    }
                    if (InlineToAnonymousConstructorProcessor.isConstant(argument) || InlineParameterHandler.getReferencedFinalField(argument) != null) {
                        if (refConstantInitializer.isNull()) {
                            refConstantInitializer.set((Object)argument);
                        } else if (!InlineParameterHandler.isSameConstant(argument, (PsiExpression)refConstantInitializer.get())) {
                            return false;
                        }
                    } else if (!InlineParameterHandler.isRecursiveReferencedParameter(argument, psiParameter)) {
                        if (!refConstantInitializer.isNull()) {
                            return false;
                        }
                        refInitializer.set((Object)argument);
                        refMethodCall.set((Object)methodCall);
                    }
                }
                return true;
            });
        }, "Searching for Method Usages", true, project2)) {
            return;
        }
        PsiReference reference = TargetElementUtil.findReference(editor);
        PsiReferenceExpression refExpr = reference instanceof PsiReferenceExpression ? (PsiReferenceExpression)reference : null;
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiCodeBlock.class);
        if (codeBlock != null && (defs = DefUseUtil.getDefs(codeBlock, (PsiVariable)psiParameter, (PsiElement)refExpr)).length == 1 && (def = defs[0]) instanceof PsiReferenceExpression && PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)def)) && (rExpr = ((PsiAssignmentExpression)def.getParent()).getRExpression()) != null && (toInline = InlineLocalHandler.getDefToInline((PsiVariable)psiParameter, (PsiElement)refExpr, codeBlock)) != null && InlineLocalHandler.checkRefsInAugmentedAssignmentOrUnaryModified(refs = DefUseUtil.getRefs(codeBlock, (PsiVariable)psiParameter, (PsiElement)toInline), def) == null) {
            new WriteCommandAction(project2, new PsiFile[0], (PsiExpression)rExpr, def){
                final /* synthetic */ PsiExpression val$rExpr;
                final /* synthetic */ PsiElement val$def;
                {
                    this.val$rExpr = psiExpression;
                    this.val$def = psiElement;
                    super(arg0, arg1);
                }

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/inline/InlineParameterHandler$1", "run"));
                    }
                    for (PsiElement ref : refs) {
                        InlineUtil.inlineVariable((PsiVariable)psiParameter, this.val$rExpr, (PsiJavaCodeReferenceElement)ref);
                    }
                    this.val$def.getParent().delete();
                }
            }.execute();
            return;
        }
        if (occurrences.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Method has no usages", (String)RefactoringBundle.message((String)"inline.parameter.refactoring"), null);
            return;
        }
        if (!result2[0]) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Cannot find constant initializer for parameter", (String)RefactoringBundle.message((String)"inline.parameter.refactoring"), null);
            return;
        }
        if (!refInitializer.isNull()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                InlineParameterExpressionProcessor processor2 = new InlineParameterExpressionProcessor((PsiCallExpression)refMethodCall.get(), method2, psiParameter, (PsiExpression)refInitializer.get(), (Boolean)method2.getProject().getUserData(InlineParameterExpressionProcessor.CREATE_LOCAL_FOR_TESTS));
                processor2.run();
            } else {
                boolean createLocal = ReferencesSearch.search((PsiElement)psiParameter).findAll().size() > 1;
                InlineParameterDialog dlg = new InlineParameterDialog((PsiCallExpression)refMethodCall.get(), method2, psiParameter, (PsiExpression)refInitializer.get(), createLocal);
                dlg.show();
            }
            return;
        }
        if (refConstantInitializer.isNull()) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Cannot find constant initializer for parameter", (String)RefactoringBundle.message((String)"inline.parameter.refactoring"), null);
            return;
        }
        final Ref isNotConstantAccessible = new Ref();
        PsiExpression constantExpression = (PsiExpression)refConstantInitializer.get();
        constantExpression.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved instanceof PsiMember && !PsiUtil.isAccessible((PsiMember)((PsiMember)resolved), (PsiElement)method2, null)) {
                    isNotConstantAccessible.set((Object)Boolean.TRUE);
                }
            }
        });
        if (!isNotConstantAccessible.isNull() && ((Boolean)isNotConstantAccessible.get()).booleanValue()) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Constant initializer is not accessible in method body", (String)RefactoringBundle.message((String)"inline.parameter.refactoring"), null);
            return;
        }
        for (PsiReference psiReference : ReferencesSearch.search((PsiElement)psiParameter)) {
            PsiElement element = psiReference.getElement();
            if (!(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) continue;
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Inline parameter which has write usages is not supported", (String)RefactoringBundle.message((String)"inline.parameter.refactoring"), null);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            String occurencesString = RefactoringBundle.message((String)"occurrences.string", (Object[])new Object[]{occurrences.size()});
            String question = RefactoringBundle.message((String)"inline.parameter.confirmation", (Object[])new Object[]{psiParameter.getName(), constantExpression.getText()}) + " " + occurencesString;
            RefactoringMessageDialog dialog2 = new RefactoringMessageDialog(REFACTORING_NAME, question, "refactoring.inlineVariable", "OptionPane.questionIcon", true, project2);
            if (!dialog2.showAndGet()) {
                return;
            }
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(psiElement.copy());
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(REFACTORING_ID, data);
            SameParameterValueInspection.InlineParameterValueFix.inlineSameParameterValue(method2, psiParameter, constantExpression);
            ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(REFACTORING_ID, null);
        }, REFACTORING_NAME, null);
    }

    @Nullable
    private static PsiField getReferencedFinalField(PsiExpression argument) {
        PsiField field;
        PsiModifierList modifierList;
        PsiElement element;
        if (argument instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)argument).resolve()) instanceof PsiField && (modifierList = (field = (PsiField)element).getModifierList()) != null && modifierList.hasModifierProperty("final")) {
            return field;
        }
        return null;
    }

    private static boolean isRecursiveReferencedParameter(PsiExpression argument, PsiParameter param) {
        PsiElement element;
        if (argument instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)argument).resolve()) instanceof PsiParameter) {
            return element.equals(param);
        }
        return false;
    }

    private static boolean isSameConstant(PsiExpression expr1, PsiExpression expr2) {
        boolean expr1Null = InlineToAnonymousConstructorProcessor.ourNullPattern.accepts((Object)expr1);
        boolean expr2Null = InlineToAnonymousConstructorProcessor.ourNullPattern.accepts((Object)expr2);
        if (expr1Null || expr2Null) {
            return expr1Null && expr2Null;
        }
        PsiField field1 = InlineParameterHandler.getReferencedFinalField(expr1);
        PsiField field2 = InlineParameterHandler.getReferencedFinalField(expr2);
        if (field1 != null && field1 == field2) {
            return true;
        }
        Object value1 = JavaPsiFacade.getInstance((Project)expr1.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr1);
        Object value2 = JavaPsiFacade.getInstance((Project)expr2.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr2);
        return value1 != null && value2 != null && value1.equals(value2);
    }

    @Nullable
    private static String getCannotInlineMessage(PsiParameter psiParameter, PsiMethod method2) {
        if (psiParameter.isVarArgs()) {
            return RefactoringBundle.message((String)"inline.parameter.error.varargs");
        }
        if (method2.findSuperMethods().length > 0 || ((PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method2).toArray((Object[])PsiMethod.EMPTY_ARRAY)).length > 0) {
            return RefactoringBundle.message((String)"inline.parameter.error.hierarchy");
        }
        if (!method2.getManager().isInProject((PsiElement)method2)) {
            return "Inline is not supported for non-project methods";
        }
        return null;
    }
}

