/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubVersionMap;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DebugAssertions;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.MapDiffUpdateData;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import gnu.trove.THashMap;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StubUpdatingIndex
extends CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree, FileContent>
implements PsiDependentIndex,
CustomInputsIndexFileBasedIndexExtension<Integer> {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubUpdatingIndex");
    private static final int VERSION = 31 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 2, true);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    private static final DataExternalizer<SerializedStubTree> KEY_EXTERNALIZER = new DataExternalizer<SerializedStubTree>(){

        public void save(@NotNull DataOutput out, @NotNull SerializedStubTree v) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubs/StubUpdatingIndex$1", "save"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "com/intellij/psi/stubs/StubUpdatingIndex$1", "save"));
            }
            v.write(out);
        }

        @NotNull
        public SerializedStubTree read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/stubs/StubUpdatingIndex$1", "read"));
            }
            SerializedStubTree serializedStubTree = new SerializedStubTree(in);
            if (serializedStubTree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex$1", "read"));
            }
            return serializedStubTree;
        }
    };
    private static final FileBasedIndex.InputFilter INPUT_FILTER = new FileBasedIndex.InputFilter(){

        public boolean acceptInput(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubUpdatingIndex$2", "acceptInput"));
            }
            return StubUpdatingIndex.canHaveStub(file2);
        }
    };
    private static final KeyDescriptor<Integer> DATA_DESCRIPTOR = new IntInlineKeyDescriptor();

    public static boolean canHaveStub(@NotNull VirtualFile file2) {
        BinaryFileStubBuilder builder;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubUpdatingIndex", "canHaveStub"));
        }
        FileType fileType = file2.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (elementType instanceof IStubFileElementType) {
                if (((IStubFileElementType)elementType).shouldBuildStubFor(file2)) {
                    return true;
                }
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                if (file2 instanceof NewVirtualFile && fileBasedIndex instanceof FileBasedIndexImpl && ((FileBasedIndexImpl)fileBasedIndex).getIndex(INDEX_ID).isIndexedStateForFile(((NewVirtualFile)file2).getId(), file2)) {
                    return true;
                }
            }
        }
        return (builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null && builder.acceptsFile(file2);
    }

    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        ID<Integer, SerializedStubTree> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getName"));
        }
        return iD;
    }

    public int getCacheSize() {
        return 5;
    }

    public boolean keyIsUniqueForIndexedFile() {
        return true;
    }

    @Override
    @NotNull
    public DataExternalizer<Collection<Integer>> createExternalizer() {
        DataExternalizer<Collection<Integer>> dataExternalizer = new DataExternalizer<Collection<Integer>>(){

            public void save(@NotNull DataOutput out, Collection<Integer> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubs/StubUpdatingIndex$3", "save"));
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.iterator().next());
                Map stubIndicesValueMap = ((StubUpdatingIndexKeys)value).myStubIndicesValueMap;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(stubIndicesValueMap != null ? stubIndicesValueMap.size() : 0));
                if (stubIndicesValueMap != null && stubIndicesValueMap.size() > 0) {
                    StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
                    for (StubIndexKey stubIndexKey : stubIndicesValueMap.keySet()) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubIndexKey.getUniqueId());
                        Map map = (Map)stubIndicesValueMap.get(stubIndexKey);
                        stubIndex.serializeIndexValue(out, stubIndexKey, map);
                    }
                }
            }

            public Collection<Integer> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/stubs/StubUpdatingIndex$3", "read"));
                }
                int fileId = DataInputOutputUtil.readINT((DataInput)in);
                StubUpdatingIndexKeys integers = new StubUpdatingIndexKeys(ContainerUtil.set((Object[])new Integer[]{fileId}));
                int stubIndicesValueMapSize = DataInputOutputUtil.readINT((DataInput)in);
                if (stubIndicesValueMapSize > 0) {
                    THashMap stubIndicesValueMap = new THashMap(stubIndicesValueMapSize);
                    StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
                    for (int i2 = 0; i2 < stubIndicesValueMapSize; ++i2) {
                        int stubIndexId = DataInputOutputUtil.readINT((DataInput)in);
                        ID indexKey = StubIndexKey.findById((int)stubIndexId);
                        if (!(indexKey instanceof StubIndexKey)) continue;
                        StubIndexKey stubIndexKey = (StubIndexKey)indexKey;
                        stubIndicesValueMap.put((Object)stubIndexKey, stubIndex.deserializeIndexValue(in, stubIndexKey));
                    }
                    integers.myStubIndicesValueMap = (Map)stubIndicesValueMap;
                }
                return integers;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "createExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public DataIndexer<Integer, SerializedStubTree, FileContent> getIndexer() {
        DataIndexer<Integer, SerializedStubTree, FileContent> dataIndexer = new DataIndexer<Integer, SerializedStubTree, FileContent>(){

            @NotNull
            public Map<Integer, SerializedStubTree> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/stubs/StubUpdatingIndex$4", "map"));
                }
                THashMap<Integer, SerializedStubTree> result2 = new THashMap<Integer, SerializedStubTree>(){
                    StubUpdatingIndexKeys myKeySet;

                    public Set<Integer> keySet() {
                        if (this.myKeySet == null) {
                            this.myKeySet = new StubUpdatingIndexKeys(super.keySet());
                        }
                        return this.myKeySet;
                    }
                };
                ApplicationManager.getApplication().runReadAction(() -> 4.lambda$map$0(inputData, (Map)result2));
                THashMap<Integer, SerializedStubTree> tHashMap = result2;
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex$4", "map"));
                }
                return tHashMap;
            }

            private static /* synthetic */ void lambda$map$0(@NotNull FileContent inputData, Map result2) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/stubs/StubUpdatingIndex$4", "lambda$map$0"));
                }
                Stub rootStub = StubTreeBuilder.buildStubTree(inputData);
                if (rootStub == null) {
                    return;
                }
                VirtualFile file2 = inputData.getFile();
                int contentLength = file2.getFileType().isBinary() ? -1 : ((FileContentImpl)inputData).getPsiFileForPsiDependentIndex().getTextLength();
                StubUpdatingIndex.rememberIndexingStamp(file2, contentLength);
                BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
                SerializationManagerEx.getInstanceEx().serialize(rootStub, (OutputStream)bytes);
                if (DebugAssertions.DEBUG) {
                    try {
                        Stub deserialized = SerializationManagerEx.getInstanceEx().deserialize((InputStream)new ByteArrayInputStream(bytes.getInternalBuffer(), 0, bytes.size()));
                        StubUpdatingIndex.check(deserialized, rootStub);
                    }
                    catch (ProcessCanceledException pce) {
                        throw pce;
                    }
                    catch (Throwable t) {
                        LOG.error("Error indexing:" + file2, t);
                    }
                }
                int key2 = Math.abs(FileBasedIndex.getFileId((VirtualFile)file2));
                SerializedStubTree serializedStubTree = new SerializedStubTree(bytes.getInternalBuffer(), bytes.size(), rootStub, file2.getLength(), contentLength);
                result2.put(key2, serializedStubTree);
                try {
                    ((StubUpdatingIndexKeys)result2.keySet()).myStubIndicesValueMap = StubUpdatingIndex.calcStubIndicesValueMap(serializedStubTree, key2);
                }
                catch (StorageException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    private static void check(Stub stub, Stub stub2) {
        assert (stub.getStubType() == stub2.getStubType());
        List stubs = stub.getChildrenStubs();
        List stubs2 = stub2.getChildrenStubs();
        assert (stubs.size() == stubs2.size());
        int len = stubs.size();
        for (int i2 = 0; i2 < len; ++i2) {
            StubUpdatingIndex.check((Stub)stubs.get(i2), (Stub)stubs2.get(i2));
        }
    }

    private static void rememberIndexingStamp(VirtualFile file2, long contentLength) {
        try {
            DataOutputStream stream = INDEXED_STAMP.writeAttribute(file2);
            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)file2.getTimeStamp());
            DataInputOutputUtil.writeLONG((DataOutput)stream, (long)contentLength);
            stream.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String getIndexingStampInfo(VirtualFile file2) {
        try {
            DataInputStream stream = INDEXED_STAMP.readAttribute(file2);
            if (stream == null) {
                return "no data";
            }
            long stamp = DataInputOutputUtil.readTIME((DataInput)stream);
            long size = DataInputOutputUtil.readLONG((DataInput)stream);
            stream.close();
            return "indexed at " + stamp + " with size " + size;
        }
        catch (IOException e) {
            return ExceptionUtil.getThrowableText((Throwable)e);
        }
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        KeyDescriptor<Integer> keyDescriptor = DATA_DESCRIPTOR;
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        DataExternalizer<SerializedStubTree> dataExternalizer = KEY_EXTERNALIZER;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = INPUT_FILTER;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return VERSION;
    }

    @Override
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage2) throws StorageException, IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/psi/stubs/StubUpdatingIndex", "createIndexImplementation"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/psi/stubs/StubUpdatingIndex", "createIndexImplementation"));
        }
        if (storage2 instanceof MemoryIndexStorage) {
            MemoryIndexStorage memStorage = (MemoryIndexStorage)storage2;
            memStorage.addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    ((StubIndexImpl)StubIndex.getInstance()).setDataBufferingEnabled(newState);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        MyIndex myIndex = new MyIndex(extension, storage2);
        if (myIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "createIndexImplementation"));
        }
        return myIndex;
    }

    private static void updateStubIndices(@NotNull Collection<StubIndexKey> indexKeys, int inputId, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (indexKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKeys", "com/intellij/psi/stubs/StubUpdatingIndex", "updateStubIndices"));
        }
        if (oldStubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldStubTree", "com/intellij/psi/stubs/StubUpdatingIndex", "updateStubIndices"));
        }
        if (newStubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStubTree", "com/intellij/psi/stubs/StubUpdatingIndex", "updateStubIndices"));
        }
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        for (StubIndexKey key2 : indexKeys) {
            Map<Object, StubIdList> oldMap = oldStubTree.get(key2);
            Map<Object, StubIdList> newMap = newStubTree.get(key2);
            Map<Object, StubIdList> _oldMap = oldMap != null ? oldMap : Collections.emptyMap();
            Map<Object, StubIdList> _newMap = newMap != null ? newMap : Collections.emptyMap();
            stubIndex.updateIndex(key2, inputId, _oldMap, _newMap);
        }
    }

    @NotNull
    private static Collection<StubIndexKey> getAffectedIndices(@NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (oldStubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldStubTree", "com/intellij/psi/stubs/StubUpdatingIndex", "getAffectedIndices"));
        }
        if (newStubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStubTree", "com/intellij/psi/stubs/StubUpdatingIndex", "getAffectedIndices"));
        }
        HashSet<StubIndexKey> allIndices = new HashSet<StubIndexKey>();
        allIndices.addAll(oldStubTree.keySet());
        allIndices.addAll(newStubTree.keySet());
        HashSet<StubIndexKey> hashSet = allIndices;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getAffectedIndices"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<StubIndexKey, Map<Object, StubIdList>> calcStubIndicesValueMap(SerializedStubTree stub, int fileId) throws StorageException {
        Map<StubIndexKey, Map<Object, StubIdList>> map;
        if (stub == null) {
            Map<StubIndexKey, Map<Object, StubIdList>> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "calcStubIndicesValueMap"));
            }
            return map2;
        }
        try {
            Map<StubIndexKey, Map<Object, StubIdList>> map3;
            ObjectStubBase root = (ObjectStubBase)stub.getStub(true);
            ObjectStubTree objectStubTree = root instanceof PsiFileStub ? new StubTree((PsiFileStub)root, false) : new ObjectStubTree(root, false);
            Map<StubIndexKey, Map<Object, StubIdList>> stubIndicesValueMap = map3 = objectStubTree.indexStubTree();
            for (StubIndexKey key2 : map3.keySet()) {
                Map<Object, StubIdList> value = map3.get(key2);
                for (Object k : value.keySet()) {
                    int[] ints = (int[])value.get(k);
                    StubIdList stubList = ints.length == 1 ? new StubIdList(ints[0]) : new StubIdList(ints, ints.length);
                    value.put(k, stubList);
                }
            }
            map = stubIndicesValueMap;
        }
        catch (SerializerNotFoundException e) {
            throw new StorageException(e);
        }
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "calcStubIndicesValueMap"));
        }
        return map;
    }

    private static class MyIndex
    extends MapReduceIndex<Integer, SerializedStubTree, FileContent> {
        private StubIndexImpl myStubIndex;
        private final StubVersionMap myStubVersionMap = new StubVersionMap();
        private static final FileAttribute VERSION_STAMP = new FileAttribute("stubIndex.versionStamp", 2, true);

        public MyIndex(FileBasedIndexExtension<Integer, SerializedStubTree> extension, IndexStorage<Integer, SerializedStubTree> storage2) throws StorageException, IOException {
            super(extension, storage2);
            MyIndex.checkNameStorage();
        }

        @Override
        public void flush() throws StorageException {
            StubIndexImpl stubIndex = this.getStubIndex();
            try {
                stubIndex.flush();
            }
            finally {
                super.flush();
            }
        }

        @Override
        protected UpdateData<Integer, SerializedStubTree> buildUpdateData(Map<Integer, SerializedStubTree> data, NotNullComputable<Collection<Integer>> oldKeysGetter, int savedInputId) {
            return new StubUpdatingData(savedInputId, data, oldKeysGetter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateWithMap(int inputId, @NotNull UpdateData<Integer, SerializedStubTree> updateData) throws StorageException {
            if (updateData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateData", "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex", "updateWithMap"));
            }
            MyIndex.checkNameStorage();
            StubUpdatingData stubUpdatingData = (StubUpdatingData)updateData;
            Map<StubIndexKey, Map<Object, StubIdList>> newStubIndicesValueMap = stubUpdatingData.getNewStubIndicesValueMap();
            StubIndexImpl stubIndex = this.getStubIndex();
            Collection<StubIndexKey> allStubIndices = stubIndex.getAllStubIndexKeys();
            try {
                for (StubIndexKey key2 : allStubIndices) {
                    stubIndex.getWriteLock(key2).lock();
                }
                try {
                    this.getWriteLock().lock();
                    super.updateWithMap(inputId, updateData);
                    Map<StubIndexKey, Map<Object, StubIdList>> previousStubIndicesValueMap = stubUpdatingData.getOldStubIndicesValueMap();
                    StubUpdatingIndex.updateStubIndices(StubUpdatingIndex.getAffectedIndices(previousStubIndicesValueMap, newStubIndicesValueMap), inputId, previousStubIndicesValueMap, newStubIndicesValueMap);
                }
                finally {
                    this.getWriteLock().unlock();
                }
            }
            finally {
                for (StubIndexKey key2 : allStubIndices) {
                    stubIndex.getWriteLock(key2).unlock();
                }
            }
        }

        private StubIndexImpl getStubIndex() {
            StubIndexImpl index = this.myStubIndex;
            if (index == null) {
                index = this.myStubIndex = (StubIndexImpl)StubIndex.getInstance();
            }
            return index;
        }

        private static void checkNameStorage() throws StorageException {
            SerializationManagerEx serializationManager = SerializationManagerEx.getInstanceEx();
            if (serializationManager.isNameStorageCorrupted()) {
                serializationManager.repairNameStorage();
                throw new StorageException("NameStorage for stubs serialization has been corrupted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() throws StorageException {
            StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
            Collection<Object> allStubIndexKeys = stubIndex != null ? stubIndex.getAllStubIndexKeys() : Collections.emptyList();
            try {
                for (StubIndexKey stubIndexKey : allStubIndexKeys) {
                    stubIndex.getWriteLock(stubIndexKey).lock();
                }
                this.getWriteLock().lock();
                if (stubIndex != null) {
                    stubIndex.clearAllIndices();
                }
                this.myStubVersionMap.clear();
                super.clear();
            }
            finally {
                this.getWriteLock().unlock();
                for (StubIndexKey stubIndexKey : allStubIndexKeys) {
                    stubIndex.getWriteLock(stubIndexKey).unlock();
                }
            }
        }

        @Override
        public void dispose() {
            try {
                super.dispose();
            }
            finally {
                this.getStubIndex().dispose();
            }
        }

        @Override
        public void setIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex", "setIndexedStateForFile"));
            }
            super.setIndexedStateForFile(fileId, file2);
            try {
                com.intellij.util.io.DataOutputStream stream = FSRecords.writeAttribute(fileId, VERSION_STAMP);
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.myStubVersionMap.getIndexingTimestampDiffForFileType(file2.getFileType()));
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public boolean isIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex", "isIndexedStateForFile"));
            }
            boolean indexedStateForFile = super.isIndexedStateForFile(fileId, file2);
            if (!indexedStateForFile) {
                return false;
            }
            try {
                int diff;
                DataInputStream stream = FSRecords.readAttributeWithLock(fileId, VERSION_STAMP);
                int n = diff = stream != null ? DataInputOutputUtil.readINT((DataInput)stream) : 0;
                if (diff == 0) {
                    return false;
                }
                FileType fileType = this.myStubVersionMap.getFileTypeByIndexingTimestampDiff(diff);
                return fileType != null && this.myStubVersionMap.getStamp(file2.getFileType()) == this.myStubVersionMap.getStamp(fileType);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
        }

        class StubUpdatingData
        extends MapReduceIndex.SimpleUpdateData {
            private Collection<Integer> oldStubIndexKeys;

            public StubUpdatingData(@NotNull int id, @NotNull Map<Integer, SerializedStubTree> data, NotNullComputable<Collection<Integer>> getter) {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex$StubUpdatingData", "<init>"));
                }
                if (getter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex$StubUpdatingData", "<init>"));
                }
                super(MyIndex.this, INDEX_ID, id, data, getter);
            }

            @Override
            public void iterateRemovedOrUpdatedKeys(int inputId, UpdateData.RemovedOrUpdatedKeyProcessor<Integer> consumer) throws StorageException {
                this.oldStubIndexKeys = (Collection)this.oldKeysGetter.compute();
                MapDiffUpdateData.iterateRemovedKeys(this.oldStubIndexKeys, inputId, consumer);
            }

            public Map<StubIndexKey, Map<Object, StubIdList>> getOldStubIndicesValueMap() {
                if (this.oldStubIndexKeys instanceof StubUpdatingIndexKeys) {
                    return ((StubUpdatingIndexKeys)this.oldStubIndexKeys).myStubIndicesValueMap;
                }
                return Collections.emptyMap();
            }

            public Map<StubIndexKey, Map<Object, StubIdList>> getNewStubIndicesValueMap() {
                Set newIndexKeys = this.getNewData().keySet();
                if (newIndexKeys instanceof StubUpdatingIndexKeys) {
                    return ((StubUpdatingIndexKeys)newIndexKeys).myStubIndicesValueMap;
                }
                return Collections.emptyMap();
            }
        }
    }

    static class StubUpdatingIndexKeys
    extends AbstractSet<Integer> {
        private final Set<Integer> myBackingMap;
        private Map<StubIndexKey, Map<Object, StubIdList>> myStubIndicesValueMap = Collections.emptyMap();

        StubUpdatingIndexKeys(Set<Integer> backingMap) {
            this.myBackingMap = backingMap;
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.myBackingMap.iterator();
        }

        @Override
        public int size() {
            return this.myBackingMap.size();
        }
    }
}

