/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class FieldElement
extends CompositeElement {
    public FieldElement() {
        super(JavaElementType.FIELD);
    }

    protected FieldElement(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/java/FieldElement", "<init>"));
        }
        super(type);
    }

    @Override
    public int getTextOffset() {
        return this.findChildByRole(9).getStartOffset();
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode eq;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/FieldElement", "deleteChildInternal"));
        }
        if (this.getChildRole(child) == 21 && (eq = this.findChildByRole(20)) != null) {
            this.deleteChildInternal(eq);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        assert (ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 7: {
                return PsiImplUtil.findDocComment(this);
            }
            case 8: {
                return this.findChildByType(JavaElementType.MODIFIER_LIST);
            }
            case 10: {
                return this.findChildByType(JavaElementType.TYPE);
            }
            case 9: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 20: {
                return this.findChildByType(JavaTokenType.EQ);
            }
            case 21: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        assert (child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaDocElementType.DOC_COMMENT) {
            return this.getChildRole(child, 7);
        }
        if (i2 == JavaTokenType.C_STYLE_COMMENT || i2 == JavaTokenType.END_OF_LINE_COMMENT) {
            return 0;
        }
        if (i2 == JavaElementType.MODIFIER_LIST) {
            return 8;
        }
        if (i2 == JavaElementType.TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i2 == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i2 == JavaTokenType.EQ) {
            return this.getChildRole(child, 20);
        }
        if (i2 == JavaTokenType.SEMICOLON) {
            return this.getChildRole(child, 22);
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 21;
        }
        return 0;
    }

    @Override
    public ASTNode copyElement() {
        CharTable table = SharedImplUtil.findCharTableByTree(this);
        PsiClass psiClass = ((PsiField)this.getPsi()).getContainingClass();
        return psiClass != null ? ChangeUtil.copyElement(this, (PsiElement)psiClass.getTypeParameterList(), table) : super.copyElement();
    }

    protected boolean isVisibilitySupported() {
        return true;
    }
}

