/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AnnotationParamListElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.AnnotationParamListElement");
    private static final TokenSet NAME_VALUE_PAIR_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.NAME_VALUE_PAIR});

    public AnnotationParamListElement() {
        super(JavaElementType.ANNOTATION_PARAMETER_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        IElementType i2 = child.getElementType();
        if (i2 == JavaTokenType.COMMA) {
            return 23;
        }
        if (i2 == JavaTokenType.LPARENTH) {
            return 24;
        }
        if (i2 == JavaTokenType.RPARENTH) {
            return 25;
        }
        if (ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(i2) || i2 == JavaElementType.NAME_VALUE_PAIR && child.getFirstChildNode() != null && child.getFirstChildNode().getElementType() == JavaElementType.ANNOTATION_ARRAY_INITIALIZER) {
            return 249;
        }
        return 0;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        switch (role) {
            default: {
                LOG.assertTrue(false);
                return null;
            }
            case 24: {
                return this.findChildByType(JavaTokenType.LPARENTH);
            }
            case 25: 
        }
        return this.findChildByType(JavaTokenType.RPARENTH);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first.getElementType() == JavaElementType.NAME_VALUE_PAIR && last.getElementType() == JavaElementType.NAME_VALUE_PAIR) {
            PsiAnnotationMemberValue value;
            PsiNameValuePair pair;
            ASTNode node;
            ASTNode[] nodes;
            ASTNode rparenth;
            ASTNode lparenth = this.findChildByType(JavaTokenType.LPARENTH);
            if (lparenth == null) {
                CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
                LeafElement created = Factory.createSingleLeafElement(JavaTokenType.LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                super.addInternal(created, created, this.getFirstChildNode(), true);
            }
            if ((rparenth = this.findChildByType(JavaTokenType.RPARENTH)) == null) {
                CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
                LeafElement created = Factory.createSingleLeafElement(JavaTokenType.RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                super.addInternal(created, created, this.getLastChildNode(), false);
            }
            if ((nodes = this.getChildren(NAME_VALUE_PAIR_BIT_SET)).length == 1 && (node = nodes[0]) instanceof PsiNameValuePair && (pair = (PsiNameValuePair)node).getName() == null && (value = pair.getValue()) != null) {
                try {
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getPsi().getProject()).getElementFactory();
                    PsiAnnotation annotation = factory.createAnnotationFromText("@AAA(value = " + value.getText() + ")", null);
                    this.replaceChild(node, annotation.getParameterList().getAttributes()[0].getNode());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (anchor == null && before != null) {
                anchor = this.findChildByType(before != false ? JavaTokenType.RPARENTH : JavaTokenType.LPARENTH);
            }
            TreeElement firstAdded = super.addInternal(first, last, anchor, before);
            JavaSourceUtil.addSeparatingComma(this, first, NAME_VALUE_PAIR_BIT_SET);
            return firstAdded;
        }
        return super.addInternal(first, last, anchor, before);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/AnnotationParamListElement", "deleteChildInternal"));
        }
        if (child.getElementType() == JavaElementType.NAME_VALUE_PAIR) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
        }
        super.deleteChildInternal(child);
    }
}

