/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFileImpl
extends XmlFileImpl
implements FileReferenceResolver {
    public HtmlFileImpl(FileViewProvider provider) {
        this(provider, XmlElementType.HTML_FILE);
    }

    public HtmlFileImpl(FileViewProvider provider, IFileElementType type) {
        super(provider, (IElementType)type);
    }

    @Override
    public String toString() {
        return "HtmlFile:" + this.getName();
    }

    @Override
    public XmlDocument getDocument() {
        FileElement treeElement = this.calcTreeElement();
        ASTNode node = treeElement.findChildByType(XmlElementType.HTML_DOCUMENT);
        return node != null ? (XmlDocument)node.getPsi() : null;
    }

    @Override
    @Nullable
    public PsiFileSystemItem resolveFileReference(@NotNull FileReference reference, @NotNull String name) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/html/HtmlFileImpl", "resolveFileReference"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/html/HtmlFileImpl", "resolveFileReference"));
        }
        VirtualFile file2 = this.getVirtualFile();
        if (!(file2 instanceof HttpVirtualFile)) {
            return null;
        }
        VirtualFile parent = file2;
        if (!parent.isDirectory() && (parent = parent.getParent()) == null) {
            parent = file2;
        }
        VirtualFile childFile = parent.findChild(name);
        HttpFileSystem fileSystem = (HttpFileSystem)parent.getFileSystem();
        if (childFile == null) {
            childFile = fileSystem.createChild(parent, name, !reference.isLast());
        }
        if (childFile.isDirectory()) {
            VirtualFile childParent = childFile;
            FileReference[] references = reference.getFileReferenceSet().getAllReferences();
            int n = references.length;
            for (int i2 = reference.getIndex() + 1; i2 < n; ++i2) {
                FileReference childReference = references[i2];
                childParent = fileSystem.createChild(childParent, childReference.decode(childReference.getText()), i2 != n - 1);
            }
            return this.getManager().findDirectory(childFile);
        }
        return this.getManager().findFile(childFile);
    }

    @Override
    public Collection<Object> getVariants(@NotNull FileReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/html/HtmlFileImpl", "getVariants"));
        }
        return Collections.emptyList();
    }
}

