/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.codeInsight.ImportFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.ImportHelper");
    private final CodeStyleSettings mySettings;
    @NonNls
    private static final String JAVA_LANG_PACKAGE = "java.lang";

    public ImportHelper(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "<init>"));
        }
        this.mySettings = settings;
    }

    @Nullable(value="null means no need to replace the import list because they are the same")
    PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "prepareOptimizeImportsResult"));
        }
        PsiImportList oldList = file2.getImportList();
        if (oldList == null) {
            return null;
        }
        ArrayList<PsiElement> nonImports = new ArrayList<PsiElement>();
        ArrayList<Pair<String, Boolean>> names = new ArrayList<Pair<String, Boolean>>(ImportHelper.collectNamesToImport(file2, nonImports));
        Collections.sort(names, (o1, o2) -> ((String)o1.getFirst()).compareTo((String)o2.getFirst()));
        List<Pair<String, Boolean>> resultList = ImportHelper.sortItemsAccordingToSettings(names, this.mySettings);
        THashMap classesOrPackagesToImportOnDemand = new THashMap();
        ImportHelper.collectOnDemandImports(resultList, this.mySettings, (Map<String, Boolean>)classesOrPackagesToImportOnDemand);
        Set<String> classesToUseSingle = ImportHelper.findSingleImports(file2, resultList, classesOrPackagesToImportOnDemand.keySet());
        THashSet toReimport = new THashSet();
        ImportHelper.calcClassesConflictingViaOnDemandImports(file2, (Map<String, Boolean>)classesOrPackagesToImportOnDemand, file2.getResolveScope(), (Set<String>)toReimport);
        classesToUseSingle.addAll((Collection<String>)toReimport);
        try {
            StringBuilder text = ImportHelper.buildImportListText(resultList, classesOrPackagesToImportOnDemand.keySet(), classesToUseSingle);
            for (PsiElement nonImport : nonImports) {
                text.append("\n").append(nonImport.getText());
            }
            String ext = StdFileTypes.JAVA.getDefaultExtension();
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)file2.getProject());
            PsiJavaFile dummyFile = (PsiJavaFile)factory.createFileFromText("_Dummy_." + ext, (FileType)StdFileTypes.JAVA, (CharSequence)text);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)file2.getProject());
            codeStyleManager.reformat((PsiElement)dummyFile);
            PsiImportList newImportList = dummyFile.getImportList();
            assert (newImportList != null) : dummyFile.getText();
            PsiImportList result2 = (PsiImportList)newImportList.copy();
            if (oldList.isReplaceEquivalent(result2)) {
                return null;
            }
            if (!nonImports.isEmpty()) {
                PsiElement element;
                for (PsiElement firstPrevious = newImportList.getPrevSibling(); firstPrevious != null && firstPrevious.getPrevSibling() != null; firstPrevious = firstPrevious.getPrevSibling()) {
                }
                for (element = firstPrevious; element != null && element != newImportList; element = element.getNextSibling()) {
                    result2.add(element.copy());
                }
                for (element = newImportList.getNextSibling(); element != null; element = element.getNextSibling()) {
                    result2.add(element.copy());
                }
            }
            return result2;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static void collectOnDemandImports(@NotNull List<Pair<String, Boolean>> resultList, final @NotNull CodeStyleSettings settings, final @NotNull Map<String, Boolean> outClassesOrPackagesToImportOnDemand) {
        if (resultList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultList", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectOnDemandImports"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectOnDemandImports"));
        }
        if (outClassesOrPackagesToImportOnDemand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outClassesOrPackagesToImportOnDemand", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectOnDemandImports"));
        }
        TObjectIntHashMap packageToCountMap = new TObjectIntHashMap();
        TObjectIntHashMap classToCountMap = new TObjectIntHashMap();
        for (Pair<String, Boolean> pair : resultList) {
            int count;
            String name = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            String packageOrClassName = ImportHelper.getPackageOrClassName(name);
            if (packageOrClassName.isEmpty()) continue;
            if (isStatic.booleanValue()) {
                count = classToCountMap.get((Object)packageOrClassName);
                classToCountMap.put((Object)packageOrClassName, count + 1);
                continue;
            }
            count = packageToCountMap.get((Object)packageOrClassName);
            packageToCountMap.put((Object)packageOrClassName, count + 1);
        }
        class MyVisitorProcedure
        implements TObjectIntProcedure<String> {
            private final boolean myIsVisitingPackages;

            MyVisitorProcedure(boolean isVisitingPackages) {
                this.myIsVisitingPackages = isVisitingPackages;
            }

            public boolean execute(String packageOrClassName, int count) {
                if (ImportHelper.isToUseImportOnDemand(packageOrClassName, count, !this.myIsVisitingPackages, settings)) {
                    boolean isStatic = !this.myIsVisitingPackages;
                    outClassesOrPackagesToImportOnDemand.put(packageOrClassName, isStatic);
                }
                return true;
            }
        }
        classToCountMap.forEachEntry((TObjectIntProcedure)new MyVisitorProcedure(false));
        packageToCountMap.forEachEntry((TObjectIntProcedure)new MyVisitorProcedure(true));
    }

    public static List<Pair<String, Boolean>> sortItemsAccordingToSettings(List<Pair<String, Boolean>> names, CodeStyleSettings settings) {
        int[] entryForName = ArrayUtil.newIntArray((int)names.size());
        PackageEntry[] entries = settings.IMPORT_LAYOUT_TABLE.getEntries();
        for (int i2 = 0; i2 < names.size(); ++i2) {
            Pair<String, Boolean> pair = names.get(i2);
            String packageName = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            entryForName[i2] = ImportHelper.findEntryIndex(packageName, isStatic, entries);
        }
        ArrayList<Pair<String, Boolean>> resultList = new ArrayList<Pair<String, Boolean>>(names.size());
        for (int i3 = 0; i3 < entries.length; ++i3) {
            for (int j = 0; j < names.size(); ++j) {
                if (entryForName[j] != i3) continue;
                resultList.add(names.get(j));
                names.set(j, null);
            }
        }
        for (Pair<String, Boolean> name : names) {
            if (name == null) continue;
            resultList.add(name);
        }
        return resultList;
    }

    @NotNull
    private static Set<String> findSingleImports(@NotNull PsiJavaFile file2, @NotNull List<Pair<String, Boolean>> names, @NotNull Set<String> onDemandImports) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImports"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImports"));
        }
        if (onDemandImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDemandImports", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImports"));
        }
        GlobalSearchScope resolveScope = file2.getResolveScope();
        String thisPackageName = file2.getPackageName();
        THashSet implicitlyImportedPackages = new THashSet(Arrays.asList(file2.getImplicitlyImportedPackages()));
        PsiManager manager = file2.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        ArrayList<String> onDemandImportsList = new ArrayList<String>(onDemandImports);
        List onDemandElements = onDemandImportsList.stream().map(onDemandName -> facade.findClass(onDemandName, resolveScope)).collect(Collectors.toList());
        THashSet namesToUseSingle = new THashSet();
        for (Pair<String, Boolean> pair : names) {
            String langPackageClass;
            String thisPackageClass;
            String name = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            String prefix = ImportHelper.getPackageOrClassName(name);
            if (prefix.isEmpty()) continue;
            boolean isImplicitlyImported = implicitlyImportedPackages.contains(prefix);
            if (!onDemandImports.contains(prefix) && !isImplicitlyImported) continue;
            String shortName = PsiNameHelper.getShortClassName((String)name);
            String string = thisPackageClass = !thisPackageName.isEmpty() ? thisPackageName + "." + shortName : shortName;
            if (JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(thisPackageClass, resolveScope) != null) {
                namesToUseSingle.add(name);
                continue;
            }
            if (!isImplicitlyImported && facade.findClass(langPackageClass = "java.lang." + shortName, resolveScope) != null) {
                namesToUseSingle.add(name);
                continue;
            }
            for (int i2 = 0; i2 < onDemandImportsList.size(); ++i2) {
                PsiClass aClass;
                String onDemandName2 = (String)onDemandImportsList.get(i2);
                if (prefix.equals(onDemandName2)) continue;
                if (isStatic.booleanValue()) {
                    PsiMethod[] methods;
                    aClass = (PsiClass)onDemandElements.get(i2);
                    if (aClass == null) continue;
                    PsiField field = aClass.findFieldByName(shortName, true);
                    if (field != null && field.hasModifierProperty("static")) {
                        namesToUseSingle.add(name);
                        continue;
                    }
                    PsiClass inner = aClass.findInnerClassByName(shortName, true);
                    if (inner != null && inner.hasModifierProperty("static")) {
                        namesToUseSingle.add(name);
                        continue;
                    }
                    for (PsiMethod method2 : methods = aClass.findMethodsByName(shortName, true)) {
                        if (!method2.hasModifierProperty("static")) continue;
                        namesToUseSingle.add(name);
                    }
                    continue;
                }
                aClass = facade.findClass(onDemandName2 + "." + shortName, resolveScope);
                if (aClass == null) continue;
                namesToUseSingle.add(name);
            }
        }
        THashSet tHashSet = namesToUseSingle;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImports"));
        }
        return tHashSet;
    }

    private static void calcClassesConflictingViaOnDemandImports(@NotNull PsiJavaFile file2, @NotNull Map<String, Boolean> onDemandImports, @NotNull GlobalSearchScope resolveScope, @NotNull Set<String> outNamesToUseSingle) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesConflictingViaOnDemandImports"));
        }
        if (onDemandImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDemandImports", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesConflictingViaOnDemandImports"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesConflictingViaOnDemandImports"));
        }
        if (outNamesToUseSingle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outNamesToUseSingle", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesConflictingViaOnDemandImports"));
        }
        ArrayList<String> onDemands = new ArrayList<String>(Arrays.asList(file2.getImplicitlyImportedPackages()));
        for (String onDemand : onDemandImports.keySet()) {
            if (onDemands.contains(onDemand)) continue;
            onDemands.add(onDemand);
        }
        if (onDemands.size() < 2) {
            return;
        }
        THashMap classNames = new THashMap();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file2.getProject());
        for (int i2 = onDemands.size() - 1; i2 >= 0; --i2) {
            PsiClass aClass;
            String onDemand = (String)onDemands.get(i2);
            PsiPackage aPackage = facade.findPackage(onDemand);
            boolean isStatic = (Boolean)ObjectUtils.notNull((Object)onDemandImports.get(onDemand), (Object)Boolean.FALSE);
            if (aPackage != null) {
                Set set2 = Arrays.stream(aPackage.getClasses(resolveScope)).map(PomNamedTarget::getName).collect(Collectors.toSet());
                classNames.put(onDemand, set2);
                continue;
            }
            if (isStatic && (aClass = facade.findClass(onDemand, resolveScope)) != null) {
                PsiMember[][] membersArray = new PsiMember[][]{aClass.getInnerClasses(), aClass.getMethods(), aClass.getFields()};
                Set set3 = Arrays.stream(membersArray).flatMap(Arrays::stream).map(NavigationItem::getName).collect(Collectors.toSet());
                classNames.put(onDemand, set3);
                continue;
            }
            onDemands.remove(i2);
        }
        THashSet conflicts = new THashSet();
        for (int i3 = 0; i3 < onDemands.size(); ++i3) {
            String on1 = (String)onDemands.get(i3);
            for (int j = i3 + 1; j < onDemands.size(); ++j) {
                String on2 = (String)onDemands.get(j);
                THashSet intersection = new THashSet((Collection)classNames.get(on1));
                intersection.retainAll((Collection)classNames.get(on2));
                conflicts.addAll(intersection);
            }
        }
        if (!conflicts.isEmpty() && !(file2 instanceof PsiCompiledElement)) {
            file2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Set)conflicts, outNamesToUseSingle){
                final /* synthetic */ Set val$conflicts;
                final /* synthetic */ Set val$outNamesToUseSingle;
                {
                    this.val$conflicts = set2;
                    this.val$outNamesToUseSingle = set3;
                }

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    if (reference.getQualifier() != null) {
                        return;
                    }
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiClass && this.val$conflicts.contains(((PsiClass)element).getName())) {
                        String fqn = ((PsiClass)element).getQualifiedName();
                        this.val$outNamesToUseSingle.add(fqn);
                    }
                }
            });
        }
    }

    @NotNull
    private static StringBuilder buildImportListText(@NotNull List<Pair<String, Boolean>> names, @NotNull Set<String> packagesOrClassesToImportOnDemand, @NotNull Set<String> namesToUseSingle) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "buildImportListText"));
        }
        if (packagesOrClassesToImportOnDemand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagesOrClassesToImportOnDemand", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "buildImportListText"));
        }
        if (namesToUseSingle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namesToUseSingle", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "buildImportListText"));
        }
        THashSet importedPackagesOrClasses = new THashSet();
        StringBuilder buffer = new StringBuilder();
        for (Pair<String, Boolean> pair : names) {
            boolean useOnDemand;
            String name = (String)pair.getFirst();
            Boolean isStatic = (Boolean)pair.getSecond();
            String packageOrClassName = ImportHelper.getPackageOrClassName(name);
            boolean implicitlyImported = JAVA_LANG_PACKAGE.equals(packageOrClassName);
            boolean bl = useOnDemand = implicitlyImported || packagesOrClassesToImportOnDemand.contains(packageOrClassName);
            if (useOnDemand && namesToUseSingle.remove(name)) {
                useOnDemand = false;
            }
            Pair current = Pair.create((Object)packageOrClassName, (Object)isStatic);
            if (useOnDemand && (importedPackagesOrClasses.contains(current) || implicitlyImported)) continue;
            buffer.append("import ");
            if (isStatic.booleanValue()) {
                buffer.append("static ");
            }
            if (useOnDemand) {
                importedPackagesOrClasses.add(current);
                buffer.append(packageOrClassName);
                buffer.append(".*");
            } else {
                buffer.append(name);
            }
            buffer.append(";\n");
        }
        for (String remainingSingle : namesToUseSingle) {
            buffer.append("import ");
            buffer.append(remainingSingle);
            buffer.append(";\n");
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "buildImportListText"));
        }
        return stringBuilder;
    }

    public boolean addImport(@NotNull PsiJavaFile file2, @NotNull PsiClass refClass) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addImport"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addImport"));
        }
        return this.addImport(file2, refClass, false);
    }

    private boolean addImport(@NotNull PsiJavaFile file2, @NotNull PsiClass refClass, boolean forceReimport) {
        PsiPackage conflictPackageRef;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addImport"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addImport"));
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file2.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        PsiResolveHelper helper = facade.getResolveHelper();
        String className = refClass.getQualifiedName();
        if (className == null) {
            return true;
        }
        if (!ImportFilter.shouldImport((PsiFile)file2, (String)className)) {
            return false;
        }
        String packageName = ImportHelper.getPackageOrClassName(className);
        String shortName = PsiNameHelper.getShortClassName((String)className);
        PsiClass conflictSingleRef = ImportHelper.findSingleImportByShortName(file2, shortName);
        if (conflictSingleRef != null && !forceReimport) {
            return className.equals(conflictSingleRef.getQualifiedName());
        }
        PsiClass curRefClass = helper.resolveReferencedClass(shortName, (PsiElement)file2);
        if (file2.getManager().areElementsEquivalent((PsiElement)refClass, (PsiElement)curRefClass)) {
            return true;
        }
        boolean useOnDemand = true;
        if (packageName.isEmpty()) {
            useOnDemand = false;
        }
        if ((conflictPackageRef = ImportHelper.findImportOnDemand(file2, packageName)) != null) {
            useOnDemand = false;
        }
        ArrayList<PsiClass> classesToReimport = new ArrayList<PsiClass>();
        List<PsiJavaCodeReferenceElement> importRefs = ImportHelper.getImportsFromPackage(file2, packageName);
        if (useOnDemand) {
            if (this.mySettings.USE_SINGLE_CLASS_IMPORTS && importRefs.size() + 1 < this.mySettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND && !this.mySettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.contains(packageName)) {
                useOnDemand = false;
            }
            if (ImportHelper.containsInCurrentFile(file2, curRefClass)) {
                useOnDemand = true;
            }
            if (useOnDemand) {
                PsiElement[] onDemandRefs = file2.getOnDemandImports(false, true);
                ArrayList<String> refTexts = new ArrayList<String>(onDemandRefs.length);
                for (PsiElement ref : onDemandRefs) {
                    String refName = ref instanceof PsiClass ? ((PsiClass)ref).getQualifiedName() : ((PsiPackage)ref).getQualifiedName();
                    refTexts.add(refName);
                }
                ImportHelper.calcClassesToReimport(file2, facade, helper, packageName, refTexts, classesToReimport);
            }
        }
        if (useOnDemand && refClass.getContainingClass() != null && this.mySettings.INSERT_INNER_CLASS_IMPORTS && ImportHelper.containsInCurrentFile(file2, curRefClass)) {
            return false;
        }
        try {
            PsiImportList importList = file2.getImportList();
            assert (importList != null) : file2;
            PsiImportStatement statement2 = useOnDemand ? factory.createImportStatementOnDemand(packageName) : factory.createImportStatement(refClass);
            importList.add((PsiElement)statement2);
            if (useOnDemand) {
                for (PsiJavaCodeReferenceElement ref : importRefs) {
                    PsiImportStatement importStatement;
                    LOG.assertTrue(ref.getParent() instanceof PsiImportStatement);
                    if (!ref.isValid() || (importStatement = (PsiImportStatement)ref.getParent()).isForeignFileImport()) continue;
                    classesToReimport.add((PsiClass)ref.resolve());
                    importStatement.delete();
                }
            }
            for (PsiClass aClass : classesToReimport) {
                if (aClass == null) continue;
                this.addImport(file2, aClass, true);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private static boolean containsInCurrentFile(@NotNull PsiJavaFile file2, PsiClass curRefClass) {
        String curRefClassQualifiedName;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "containsInCurrentFile"));
        }
        return curRefClass != null && (curRefClassQualifiedName = curRefClass.getQualifiedName()) != null && ArrayUtil.find((Object[])file2.getImplicitlyImportedPackages(), (Object)StringUtil.getPackageName((String)curRefClassQualifiedName)) < 0;
    }

    private static void calcClassesToReimport(@NotNull PsiJavaFile file2, @NotNull JavaPsiFacade facade, @NotNull PsiResolveHelper helper, @NotNull String packageName, @NotNull Collection<String> onDemandRefs, @NotNull List<PsiClass> outClassesToReimport) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesToReimport"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesToReimport"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesToReimport"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesToReimport"));
        }
        if (onDemandRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDemandRefs", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesToReimport"));
        }
        if (outClassesToReimport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outClassesToReimport", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "calcClassesToReimport"));
        }
        if (onDemandRefs.isEmpty()) {
            return;
        }
        PsiPackage aPackage = facade.findPackage(packageName);
        if (aPackage == null) {
            return;
        }
        PsiDirectory[] dirs = aPackage.getDirectories();
        GlobalSearchScope resolveScope = file2.getResolveScope();
        for (PsiDirectory dir : dirs) {
            PsiFile[] files;
            for (PsiFile aFile : files = dir.getFiles()) {
                if (!(aFile instanceof PsiJavaFile)) continue;
                String name = aFile.getVirtualFile().getNameWithoutExtension();
                for (String refName : onDemandRefs) {
                    String conflictClassName2;
                    PsiClass conflictClass2;
                    String conflictClassName = refName + "." + name;
                    PsiClass conflictClass = facade.findClass(conflictClassName, resolveScope);
                    if (conflictClass == null || !helper.isAccessible((PsiMember)conflictClass, (PsiElement)file2, null) || (conflictClass2 = facade.findClass(conflictClassName2 = packageName + "." + name, resolveScope)) == null || !helper.isAccessible((PsiMember)conflictClass2, (PsiElement)file2, null) || ReferencesSearch.search((PsiElement)conflictClass, (SearchScope)new LocalSearchScope((PsiElement)file2), (boolean)false).findFirst() == null) continue;
                    outClassesToReimport.add(conflictClass);
                }
            }
        }
    }

    @NotNull
    private static List<PsiJavaCodeReferenceElement> getImportsFromPackage(@NotNull PsiJavaFile file2, @NotNull String packageName) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getImportsFromPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getImportsFromPackage"));
        }
        PsiClass[] refs = file2.getSingleClassImports(true);
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiClass ref1 : refs) {
            PsiJavaCodeReferenceElement ref;
            String className = ref1.getQualifiedName();
            if (!ImportHelper.getPackageOrClassName(className).equals(packageName) || (ref = file2.findImportReferenceTo(ref1)) == null) continue;
            array.add(ref);
        }
        ArrayList<PsiJavaCodeReferenceElement> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getImportsFromPackage"));
        }
        return arrayList;
    }

    private static PsiClass findSingleImportByShortName(final @NotNull PsiJavaFile file2, @NotNull String shortClassName) {
        String className;
        PsiClass[] refs;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImportByShortName"));
        }
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortClassName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findSingleImportByShortName"));
        }
        for (PsiClass ref : refs = file2.getSingleClassImports(true)) {
            className = ref.getQualifiedName();
            if (className == null || !PsiNameHelper.getShortClassName((String)className).equals(shortClassName)) continue;
            return ref;
        }
        for (PsiClass aClass : file2.getClasses()) {
            className = aClass.getQualifiedName();
            if (className == null || !PsiNameHelper.getShortClassName((String)className).equals(shortClassName)) continue;
            return aClass;
        }
        String packageName = file2.getPackageName();
        if (!StringUtil.isEmptyOrSpaces((String)packageName)) {
            String fqn = packageName + "." + shortClassName;
            final PsiClass aClass = JavaPsiFacade.getInstance((Project)file2.getProject()).findClass(fqn, file2.getResolveScope());
            if (aClass != null) {
                final boolean[] foundRef = new boolean[]{false};
                file2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        if (foundRef[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        if (file2.getManager().areElementsEquivalent(reference.resolve(), (PsiElement)aClass)) {
                            foundRef[0] = true;
                        }
                        super.visitReferenceElement(reference);
                    }
                });
                if (foundRef[0]) {
                    return aClass;
                }
            }
        }
        return null;
    }

    private static PsiPackage findImportOnDemand(@NotNull PsiJavaFile file2, @NotNull String packageName) {
        PsiElement[] refs;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findImportOnDemand"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findImportOnDemand"));
        }
        for (PsiElement ref : refs = file2.getOnDemandImports(false, true)) {
            if (!(ref instanceof PsiPackage) || !((PsiPackage)ref).getQualifiedName().equals(packageName)) continue;
            return (PsiPackage)ref;
        }
        return null;
    }

    public static boolean isAlreadyImported(@NotNull PsiJavaFile file2, @NotNull String fullyQualifiedName) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "isAlreadyImported"));
        }
        if (fullyQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullyQualifiedName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "isAlreadyImported"));
        }
        String className = ImportHelper.extractClassName(file2, fullyQualifiedName);
        Project project2 = file2.getProject();
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)project2);
        PsiClass psiClass = resolveHelper.resolveReferencedClass(className, (PsiElement)file2);
        return psiClass != null && fullyQualifiedName.equals(psiClass.getQualifiedName());
    }

    @NotNull
    private static String extractClassName(@NotNull PsiJavaFile file2, @NotNull String fullyQualifiedName) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "extractClassName"));
        }
        if (fullyQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullyQualifiedName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "extractClassName"));
        }
        for (PsiClass aClass : file2.getClasses()) {
            String outerClassName = aClass.getQualifiedName();
            if (outerClassName == null || !fullyQualifiedName.startsWith(outerClassName)) continue;
            String string = fullyQualifiedName.substring(outerClassName.lastIndexOf(46) + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "extractClassName"));
            }
            return string;
        }
        String string = ClassUtil.extractClassName((String)fullyQualifiedName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "extractClassName"));
        }
        return string;
    }

    public ASTNode getDefaultAnchor(@NotNull PsiImportList list, @NotNull PsiImportStatementBase statement2) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getDefaultAnchor"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getDefaultAnchor"));
        }
        PsiJavaCodeReferenceElement ref = statement2.getImportReference();
        if (ref == null) {
            return null;
        }
        int entryIndex = this.findEntryIndex(statement2);
        PsiImportStatementBase[] allStatements = list.getAllImportStatements();
        int[] entries = ArrayUtil.newIntArray((int)allStatements.length);
        ArrayList<PsiImportStatementBase> statements = new ArrayList<PsiImportStatementBase>();
        for (int i2 = 0; i2 < allStatements.length; ++i2) {
            int entryIndex1;
            PsiImportStatementBase statement1 = allStatements[i2];
            entries[i2] = entryIndex1 = this.findEntryIndex(statement1);
            if (entryIndex1 != entryIndex) continue;
            statements.add(statement1);
        }
        if (statements.isEmpty()) {
            int index;
            for (index = entries.length - 1; index >= 0 && entries[index] >= entryIndex; --index) {
            }
            return ++index < entries.length ? SourceTreeToPsiMap.psiElementToTree((PsiElement)allStatements[index]) : null;
        }
        String refText = ref.getCanonicalText();
        if (statement2.isOnDemand()) {
            refText = refText + ".";
        }
        PsiImportStatementBase insertBefore = null;
        PsiImportStatementBase insertAfter = null;
        for (PsiImportStatementBase statement1 : statements) {
            int comp;
            PsiJavaCodeReferenceElement ref1 = statement1.getImportReference();
            if (ref1 == null) continue;
            String refTextThis = ref1.getCanonicalText();
            if (statement1.isOnDemand()) {
                refTextThis = refTextThis + ".";
            }
            if ((comp = Comparing.compare((Comparable)((Object)refText), (Comparable)((Object)refTextThis))) < 0 && insertBefore == null) {
                insertBefore = statement1;
            }
            if (comp <= 0) continue;
            insertAfter = statement1;
        }
        if (insertBefore != null) {
            return insertBefore.getNode();
        }
        if (insertAfter != null) {
            return insertAfter.getNode().getTreeNext();
        }
        return null;
    }

    public int getEmptyLinesBetween(@NotNull PsiImportStatementBase statement1, @NotNull PsiImportStatementBase statement2) {
        int index2;
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getEmptyLinesBetween"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getEmptyLinesBetween"));
        }
        int index1 = this.findEntryIndex(statement1);
        if (index1 == (index2 = this.findEntryIndex(statement2))) {
            return 0;
        }
        if (index1 > index2) {
            int t = index1;
            index1 = index2;
            index2 = t;
        }
        PackageEntry[] entries = this.mySettings.IMPORT_LAYOUT_TABLE.getEntries();
        int maxSpace = 0;
        for (int i2 = index1 + 1; i2 < index2; ++i2) {
            if (entries[i2] != PackageEntry.BLANK_LINE_ENTRY) continue;
            int space = 0;
            do {
                ++space;
            } while (entries[++i2] == PackageEntry.BLANK_LINE_ENTRY);
            maxSpace = Math.max(maxSpace, space);
        }
        return maxSpace;
    }

    private static boolean isToUseImportOnDemand(@NotNull String packageName, int classCount, boolean isStaticImportNeeded, @NotNull CodeStyleSettings settings) {
        int limitCount;
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "isToUseImportOnDemand"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "isToUseImportOnDemand"));
        }
        if (!settings.USE_SINGLE_CLASS_IMPORTS) {
            return true;
        }
        int n = limitCount = isStaticImportNeeded ? settings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND : settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
        if (classCount >= limitCount) {
            return true;
        }
        if (packageName.isEmpty()) {
            return false;
        }
        PackageEntryTable table = settings.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
        return table.contains(packageName);
    }

    private static int findEntryIndex(@NotNull String packageName, boolean isStatic, @NotNull PackageEntry[] entries) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findEntryIndex"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findEntryIndex"));
        }
        PackageEntry bestEntry = null;
        int bestEntryIndex = -1;
        int allOtherStaticIndex = -1;
        int allOtherIndex = -1;
        for (int i2 = 0; i2 < entries.length; ++i2) {
            PackageEntry entry = entries[i2];
            if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                allOtherStaticIndex = i2;
            }
            if (entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY) {
                allOtherIndex = i2;
            }
            if (!entry.isBetterMatchForPackageThan(bestEntry, packageName, isStatic)) continue;
            bestEntry = entry;
            bestEntryIndex = i2;
        }
        if (bestEntryIndex == -1 && isStatic && allOtherStaticIndex == -1 && allOtherIndex != -1) {
            bestEntryIndex = allOtherIndex;
        }
        return bestEntryIndex;
    }

    int findEntryIndex(@NotNull PsiImportStatementBase statement2) {
        String packageName;
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "findEntryIndex"));
        }
        PsiJavaCodeReferenceElement ref = statement2.getImportReference();
        if (ref == null) {
            return -1;
        }
        if (statement2.isOnDemand()) {
            packageName = ref.getCanonicalText();
        } else {
            String className = ref.getCanonicalText();
            packageName = ImportHelper.getPackageOrClassName(className);
        }
        return ImportHelper.findEntryIndex(packageName, statement2 instanceof PsiImportStaticStatement, this.mySettings.IMPORT_LAYOUT_TABLE.getEntries());
    }

    @NotNull
    private static Collection<Pair<String, Boolean>> collectNamesToImport(@NotNull PsiJavaFile file2, List<PsiElement> comments) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        THashSet names = new THashSet();
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file2);
        ImportHelper.collectNamesToImport((Set<Pair<String, Boolean>>)names, comments, file2, (PsiFile)jspFile);
        if (jspFile != null) {
            PsiFile[] files;
            for (PsiFile includingFile : files = (PsiFile[])ArrayUtil.mergeArrays((Object[])JspSpiUtil.getIncludingFiles(jspFile), (Object[])JspSpiUtil.getIncludedFiles(jspFile))) {
                PsiFile javaRoot = includingFile.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE);
                if (!(javaRoot instanceof PsiJavaFile) || file2 == javaRoot) continue;
                ImportHelper.collectNamesToImport((Set<Pair<String, Boolean>>)names, comments, (PsiJavaFile)javaRoot, (PsiFile)jspFile);
            }
        }
        ImportHelper.addUnresolvedImportNames((Set<Pair<String, Boolean>>)names, file2);
        THashSet tHashSet = names;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        return tHashSet;
    }

    private static void collectNamesToImport(@NotNull Set<Pair<String, Boolean>> names, @NotNull List<PsiElement> comments, @NotNull PsiJavaFile file2, PsiFile context) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "collectNamesToImport"));
        }
        String packageName = file2.getPackageName();
        List roots = file2.getViewProvider().getAllFiles();
        for (PsiElement root : roots) {
            ImportHelper.addNamesToImport(names, comments, root, packageName, context);
        }
    }

    private static void addNamesToImport(@NotNull Set<Pair<String, Boolean>> names, @NotNull List<PsiElement> comments, @NotNull PsiElement scope, @NotNull String thisPackageName, PsiFile context) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addNamesToImport"));
        }
        if (comments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comments", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addNamesToImport"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addNamesToImport"));
        }
        if (thisPackageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisPackageName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addNamesToImport"));
        }
        if (scope instanceof PsiImportList) {
            return;
        }
        LinkedList<PsiElement> stack = new LinkedList<PsiElement>();
        stack.add(scope);
        while (!stack.isEmpty()) {
            PsiElement child = (PsiElement)stack.removeFirst();
            if (child instanceof PsiImportList) {
                for (PsiElement psiElement : child.getChildren()) {
                    IElementType elementType;
                    ASTNode node;
                    if (psiElement == null || (node = psiElement.getNode()) == null || ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(elementType = node.getElementType()) || JavaJspElementType.WHITE_SPACE_BIT_SET.contains(elementType)) continue;
                    comments.add(psiElement);
                }
                continue;
            }
            if (child instanceof PsiLiteralExpression) continue;
            ContainerUtil.addAll(stack, (Object[])child.getChildren());
            for (PsiElement psiElement : child.getReferences()) {
                String qName;
                PsiElement currentFileResolveScope;
                PsiJavaReference javaReference;
                if (!(psiElement instanceof PsiJavaReference) || (javaReference = (PsiJavaReference)psiElement) instanceof JavaClassReference && ((JavaClassReference)javaReference).getContextReference() != null) continue;
                PsiJavaCodeReferenceElement referenceElement = null;
                if (psiElement instanceof PsiJavaCodeReferenceElement && ((referenceElement = (PsiJavaCodeReferenceElement)child).getQualifier() != null || psiElement instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)psiElement).getKind(((PsiJavaCodeReferenceElementImpl)psiElement).getContainingFile()) == 6)) continue;
                JavaResolveResult resolveResult = javaReference.advancedResolve(true);
                PsiElement refElement = resolveResult.getElement();
                if (refElement == null && referenceElement != null) {
                    refElement = ResolveClassUtil.resolveClass(referenceElement, referenceElement.getContainingFile());
                }
                if (refElement == null || !((currentFileResolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) || context != null && (!currentFileResolveScope.isValid() || currentFileResolveScope instanceof JspxImportStatement && context != ((JspxImportStatement)currentFileResolveScope).getDeclarationFile())) continue;
                if (referenceElement != null && currentFileResolveScope instanceof PsiImportStaticStatement) {
                    String refName;
                    PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
                    String name = importStaticStatement.getImportReference().getCanonicalText();
                    if (importStaticStatement.isOnDemand() && (refName = referenceElement.getReferenceName()) != null) {
                        name = name + "." + refName;
                    }
                    names.add((Pair<String, Boolean>)Pair.create((Object)name, (Object)Boolean.TRUE));
                    continue;
                }
                if (!(refElement instanceof PsiClass) || ImportHelper.hasPackage(qName = ((PsiClass)refElement).getQualifiedName(), thisPackageName)) continue;
                names.add((Pair<String, Boolean>)Pair.create((Object)qName, (Object)Boolean.FALSE));
            }
        }
    }

    private static void addUnresolvedImportNames(@NotNull Set<Pair<String, Boolean>> namesToImport, @NotNull PsiJavaFile file2) {
        if (namesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namesToImport", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addUnresolvedImportNames"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "addUnresolvedImportNames"));
        }
        PsiImportList importList = file2.getImportList();
        PsiImportStatementBase[] imports = importList == null ? PsiImportStatementBase.EMPTY_ARRAY : importList.getAllImportStatements();
        THashMap unresolvedNames = new THashMap();
        THashSet unresolvedOnDemand = new THashSet();
        for (PsiImportStatementBase anImport : imports) {
            JavaResolveResult[] results;
            PsiJavaCodeReferenceElement ref = anImport.getImportReference();
            if (ref == null || (results = ref.multiResolve(false)).length != 0) continue;
            String text = ref.getCanonicalText();
            if (anImport.isOnDemand()) {
                text = text + ".*";
            }
            Pair pair = Pair.create((Object)text, (Object)(anImport instanceof PsiImportStaticStatement));
            if (anImport.isOnDemand()) {
                unresolvedOnDemand.add(pair);
                continue;
            }
            unresolvedNames.put(ref.getReferenceName(), pair);
        }
        if (file2.getViewProvider().getLanguages().size() > 1 && file2.getViewProvider().getBaseLanguage() != JavaLanguage.INSTANCE) {
            namesToImport.addAll((Collection<Pair<String, Boolean>>)unresolvedOnDemand);
            namesToImport.addAll(unresolvedNames.values());
            return;
        }
        boolean[] hasResolveProblem = new boolean[]{false};
        for (PsiClass aClass : file2.getClasses()) {
            if (aClass instanceof PsiCompiledElement) continue;
            aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)unresolvedNames, hasResolveProblem, namesToImport){
                final /* synthetic */ Map val$unresolvedNames;
                final /* synthetic */ boolean[] val$hasResolveProblem;
                final /* synthetic */ Set val$namesToImport;
                {
                    this.val$unresolvedNames = map;
                    this.val$hasResolveProblem = blArray;
                    this.val$namesToImport = set2;
                }

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    String name = reference.getReferenceName();
                    Pair pair = (Pair)this.val$unresolvedNames.get(name);
                    if (reference.multiResolve(false).length == 0) {
                        this.val$hasResolveProblem[0] = true;
                        if (pair != null) {
                            this.val$namesToImport.add(pair);
                            this.val$unresolvedNames.remove(name);
                        }
                    }
                    super.visitReferenceElement(reference);
                }
            });
        }
        if (hasResolveProblem[0]) {
            namesToImport.addAll((Collection<Pair<String, Boolean>>)unresolvedOnDemand);
        }
    }

    static boolean isImplicitlyImported(@NotNull String className, @NotNull PsiJavaFile file2) {
        String[] packageNames;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "isImplicitlyImported"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "isImplicitlyImported"));
        }
        for (String packageName : packageNames = file2.getImplicitlyImportedPackages()) {
            if (!ImportHelper.hasPackage(className, packageName)) continue;
            return true;
        }
        return false;
    }

    static boolean hasPackage(@NotNull String className, @NotNull String packageName) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "hasPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "hasPackage"));
        }
        if (!className.startsWith(packageName)) {
            return false;
        }
        if (className.length() == packageName.length()) {
            return false;
        }
        if (!packageName.isEmpty() && className.charAt(packageName.length()) != '.') {
            return false;
        }
        return className.indexOf(46, packageName.length() + 1) < 0;
    }

    @NotNull
    private static String getPackageOrClassName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getPackageOrClassName"));
        }
        int dotIndex = className.lastIndexOf(46);
        String string = dotIndex < 0 ? "" : className.substring(0, dotIndex);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/ImportHelper", "getPackageOrClassName"));
        }
        return string;
    }
}

