/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.ImportSchemeChooserDialog;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSettingsLoader;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeXmlImporter
extends CodeStyleSettingsLoader
implements SchemeImporter<CodeStyleScheme> {
    @NotNull
    public String[] getSourceExtensions() {
        String[] stringArray = new String[]{"xml"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getSourceExtensions"));
        }
        return stringArray;
    }

    @Nullable
    public CodeStyleScheme importScheme(@NotNull Project project2, @NotNull VirtualFile selectedFile, @NotNull CodeStyleScheme currentScheme, @NotNull SchemeFactory<CodeStyleScheme> schemeFactory) throws SchemeImportException {
        Pair<String, CodeStyleScheme> importPair;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "importScheme"));
        }
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "importScheme"));
        }
        if (currentScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentScheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "importScheme"));
        }
        if (schemeFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeFactory", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "importScheme"));
        }
        Element rootElement = CodeStyleSchemeXmlImporter.loadSchemeDom(selectedFile);
        Element schemeRoot = CodeStyleSchemeXmlImporter.getSchemeRoot(rootElement);
        Pair<String, CodeStyleScheme> pair = importPair = !ApplicationManager.getApplication().isUnitTestMode() ? ImportSchemeChooserDialog.selectOrCreateTargetScheme(project2, currentScheme, schemeFactory, CodeStyleSchemeXmlImporter.getSchemeName(schemeRoot)) : Pair.create((Object)currentScheme.getName(), (Object)currentScheme);
        if (importPair != null) {
            return this.readSchemeFromDom(schemeRoot, (CodeStyleScheme)importPair.second);
        }
        return null;
    }

    @NotNull
    private static String getSchemeName(@NotNull Element rootElement) throws SchemeImportException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getSchemeName"));
        }
        String rootName = rootElement.getName();
        if ("value".equals(rootElement.getName())) {
            if ("Project" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getSchemeName"));
            }
            return "Project";
        }
        if (!"code_scheme".equals(rootName)) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.invalid.file", (Object[])new Object[]{rootName}));
        }
        Attribute schemeNameAttr = rootElement.getAttribute("name");
        if (schemeNameAttr == null) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.missing.scheme.name", (Object[])new Object[0]));
        }
        String string = schemeNameAttr.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getSchemeName"));
        }
        return string;
    }

    private static Element getSchemeRoot(@NotNull Element rootElement) throws SchemeImportException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getSchemeRoot"));
        }
        if ("project".equals(rootElement.getName())) {
            Element child = rootElement.getChild("component");
            if (child != null && "ProjectCodeStyleSettingsManager".equals(child.getAttributeValue("name")) && (child = child.getChild("option")) != null && "PER_PROJECT_SETTINGS".equals(child.getAttributeValue("name")) && (child = child.getChild("value")) != null) {
                return child;
            }
            throw new SchemeImportException("Invalid scheme root: " + rootElement.getName());
        }
        return rootElement;
    }

    private CodeStyleScheme readSchemeFromDom(@NotNull Element rootElement, @NotNull CodeStyleScheme scheme2) throws SchemeImportException {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "readSchemeFromDom"));
        }
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "readSchemeFromDom"));
        }
        CodeStyleSettings newSettings = new CodeStyleSettings();
        this.loadSettings(rootElement, newSettings);
        ((CodeStyleSchemeImpl)scheme2).setCodeStyleSettings(newSettings);
        return scheme2;
    }

    @Nullable
    public String getAdditionalImportInfo(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeXmlImporter", "getAdditionalImportInfo"));
        }
        return null;
    }
}

