/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaModuleImpl
extends JavaStubPsiElement<PsiJavaModuleStub>
implements PsiJavaModule {
    public PsiJavaModuleImpl(@NotNull PsiJavaModuleStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "<init>"));
        }
        super(stub, (IStubElementType)JavaStubElementTypes.MODULE);
    }

    public PsiJavaModuleImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameElement() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = (PsiJavaModuleReferenceElement)PsiTreeUtil.getRequiredChildOfType((PsiElement)this, PsiJavaModuleReferenceElement.class);
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "getNameElement"));
        }
        return psiJavaModuleReferenceElement;
    }

    @NotNull
    public String getModuleName() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "getModuleName"));
            }
            return string;
        }
        String string = this.getNameElement().getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            JBIterable jBIterable = JBIterable.of((Object[])stub.getChildrenByType(JavaElementType.REQUIRES_STATEMENT, (PsiElement[])PsiRequiresStatement.EMPTY_ARRAY));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "getRequires"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = SyntaxTraverser.psiTraverser().children((Object)this).filter(PsiRequiresStatement.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "getRequires"));
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiExportsStatement> getExports() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            JBIterable jBIterable = JBIterable.of((Object[])stub.getChildrenByType(JavaElementType.EXPORTS_STATEMENT, (PsiElement[])PsiExportsStatement.EMPTY_ARRAY));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "getExports"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = SyntaxTraverser.psiTraverser().children((Object)this).filter(PsiExportsStatement.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "getExports"));
        }
        return jBIterable;
    }

    @Override
    public String getName() {
        return this.getModuleName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "setName"));
        }
        PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)this.getProject());
        PsiJavaModuleReferenceElement newName = factory.createModuleFromText("module " + name + " {}").getNameElement();
        this.getNameElement().replace((PsiElement)newName);
        return this;
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return (PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)this, PsiDocComment.class);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.getNameElement();
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "getNavigationElement"));
        }
        return psiJavaModuleReferenceElement;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiJavaModuleImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModule((PsiJavaModule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiJavaModule:" + this.getModuleName();
    }
}

