/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.AnchorTypeInfo;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfElementInfo
extends SmartPointerElementInfo {
    private static final FileDocumentManager ourFileDocManager = FileDocumentManager.getInstance();
    protected volatile AnchorTypeInfo myType;
    protected final SmartPointerManagerImpl myManager;
    private final VirtualFile myFile;
    private final boolean myForInjected;
    private int myStartOffset;
    private int myEndOffset;

    SelfElementInfo(@NotNull Project project2, @Nullable ProperTextRange range, @NotNull AnchorTypeInfo info, @NotNull PsiFile containingFile, boolean forInjected) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "<init>"));
        }
        this.myForInjected = forInjected;
        this.myType = info;
        this.myManager = (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)project2);
        this.myFile = containingFile.getViewProvider().getVirtualFile();
        this.setRange((Segment)range);
    }

    void setRange(@Nullable Segment range) {
        if (range != null) {
            this.myStartOffset = range.getStartOffset();
            this.myEndOffset = range.getEndOffset();
        } else {
            this.myStartOffset = -1;
            this.myEndOffset = -1;
        }
    }

    boolean hasRange() {
        return this.myStartOffset >= 0;
    }

    int getPsiStartOffset() {
        return this.myStartOffset;
    }

    int getPsiEndOffset() {
        return this.myEndOffset;
    }

    boolean isForInjected() {
        return this.myForInjected;
    }

    @Override
    public Document getDocumentToSynchronize() {
        return ourFileDocManager.getCachedDocument(this.getVirtualFile());
    }

    @Override
    public PsiElement restoreElement() {
        TextRange segment = this.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile file2 = this.restoreFile();
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return SelfElementInfo.findElementInside(file2, segment.getStartOffset(), segment.getEndOffset(), this.myType);
    }

    @Nullable
    public TextRange getPsiRange() {
        return this.calcPsiRange();
    }

    @Nullable
    private TextRange calcPsiRange() {
        return this.hasRange() ? new UnfairTextRange(this.myStartOffset, this.myEndOffset) : null;
    }

    @Override
    public PsiFile restoreFile() {
        return SelfElementInfo.restoreFileFromVirtual(this.getVirtualFile(), this.getProject(), this.myType.getFileLanguage());
    }

    public static PsiElement findElementInside(@NotNull PsiFile file2, int syncStartOffset, int syncEndOffset, @NotNull AnchorTypeInfo type) {
        PsiElement lastChild;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findElementInside"));
        }
        PsiElement anchor = file2.getViewProvider().findElementAt(syncStartOffset, type.getFileLanguage());
        if (anchor == null && syncStartOffset == file2.getTextLength() && (lastChild = file2.getViewProvider().getPsi(type.getFileLanguage()).getLastChild()) != null) {
            anchor = PsiTreeUtil.getDeepestLast((PsiElement)lastChild);
        }
        if (anchor == null) {
            return null;
        }
        PsiElement result2 = SelfElementInfo.findParent(syncStartOffset, syncEndOffset, type, anchor);
        if (syncEndOffset == syncStartOffset) {
            while (result2 == null && anchor.getTextRange().getStartOffset() == syncEndOffset && (anchor = PsiTreeUtil.prevLeaf((PsiElement)anchor, (boolean)false)) != null) {
                result2 = SelfElementInfo.findParent(syncStartOffset, syncEndOffset, type, anchor);
            }
        }
        return result2;
    }

    @Nullable
    private static PsiElement findParent(int syncStartOffset, int syncEndOffset, @NotNull AnchorTypeInfo type, PsiElement anchor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "findParent"));
        }
        TextRange range = anchor.getTextRange();
        if (range.getStartOffset() != syncStartOffset) {
            return null;
        }
        while (range.getEndOffset() < syncEndOffset) {
            if ((anchor = anchor.getParent()) == null || anchor.getTextRange() == null) {
                return null;
            }
            range = anchor.getTextRange();
        }
        while (range.getEndOffset() == syncEndOffset) {
            if (type.isAcceptable(anchor)) {
                return anchor;
            }
            if ((anchor = anchor.getParent()) == null || anchor.getTextRange() == null) break;
            range = anchor.getTextRange();
        }
        return null;
    }

    @Override
    public void cleanup() {
        this.setRange(null);
    }

    @Nullable
    public static PsiFile restoreFileFromVirtual(final @NotNull VirtualFile virtualFile, final @NotNull Project project2, final @Nullable Language language) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreFileFromVirtual"));
        }
        return (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<PsiFile>(){

            public PsiFile compute() {
                if (project2.isDisposed()) {
                    return null;
                }
                VirtualFile child = SelfElementInfo.restoreVFile(virtualFile);
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(child);
                if (file2 != null && language != null) {
                    return file2.getViewProvider().getPsi(language);
                }
                return file2;
            }
        });
    }

    @Nullable
    public static PsiDirectory restoreDirectoryFromVirtual(final VirtualFile virtualFile, final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "restoreDirectoryFromVirtual"));
        }
        if (virtualFile == null) {
            return null;
        }
        return (PsiDirectory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory>(){

            public PsiDirectory compute() {
                VirtualFile child = SelfElementInfo.restoreVFile(virtualFile);
                if (child == null || !child.isValid()) {
                    return null;
                }
                PsiDirectory file2 = PsiManager.getInstance((Project)project2).findDirectory(child);
                if (file2 == null || !file2.isValid()) {
                    return null;
                }
                return file2;
            }
        });
    }

    @Nullable
    private static VirtualFile restoreVFile(VirtualFile virtualFile) {
        VirtualFile child;
        if (virtualFile.isValid()) {
            child = virtualFile;
        } else {
            VirtualFile vParent = virtualFile.getParent();
            if (vParent == null || !vParent.isValid()) {
                return null;
            }
            String name = virtualFile.getName();
            child = vParent.findChild(name);
        }
        return child;
    }

    @Override
    public int elementHashCode() {
        return this.getVirtualFile().hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof SelfElementInfo) {
            final SelfElementInfo otherInfo = (SelfElementInfo)other;
            if (!this.getVirtualFile().equals(other.getVirtualFile()) || this.myType != otherInfo.myType) {
                return false;
            }
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    TextRange range1 = SelfElementInfo.this.getPsiRange();
                    TextRange range2 = otherInfo.getPsiRange();
                    return range1 != null && range2 != null && range1.getStartOffset() == range2.getStartOffset() && range1.getEndOffset() == range2.getEndOffset();
                }
            });
        }
        return this.areRestoredElementsEqual(other);
    }

    protected boolean areRestoredElementsEqual(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "areRestoredElementsEqual"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return Comparing.equal((Object)SelfElementInfo.this.restoreElement(), (Object)other.restoreElement());
            }
        });
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public Segment getRange() {
        MarkerCache markerCache;
        PsiDocumentManagerBase documentManager;
        List<DocumentEvent> events;
        Document document;
        if (this.hasRange() && (document = this.getDocumentToSynchronize()) != null && !(events = (documentManager = this.myManager.getPsiDocumentManager()).getEventsSinceCommit(document)).isEmpty() && (markerCache = this.myManager.getMarkerCache(this.getVirtualFile())) != null) {
            return markerCache.getUpdatedRange(this, (FrozenDocument)documentManager.getLastCommittedDocument(document), events);
        }
        return this.calcPsiRange();
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project2 = this.myManager.getProject();
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SelfElementInfo", "getProject"));
        }
        return project2;
    }

    public String toString() {
        return "psi:range=" + this.calcPsiRange() + ",type=" + this.myType;
    }
}

