/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiExportsStatement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiExportsStatementStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import java.util.Collections;
import java.util.List;

public class PsiExportsStatementStubImpl
extends StubBase<PsiExportsStatement>
implements PsiExportsStatementStub {
    private final String myPackageName;
    private final List<String> myTargets;

    public PsiExportsStatementStubImpl(StubElement parent, String packageName, List<String> targets) {
        super(parent, (IStubElementType)JavaStubElementTypes.EXPORTS_STATEMENT);
        this.myPackageName = packageName;
        this.myTargets = targets == null || targets.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(targets);
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public List<String> getTargets() {
        return this.myTargets;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PsiExportsStatementStub:").append(this.myPackageName);
        for (String target : this.myTargets) {
            sb.append(':').append(target);
        }
        return sb.toString();
    }
}

