/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.BitUtil;
import com.intellij.util.SmartList;
import com.intellij.util.io.StringRef;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeInfo {
    private static final String[] ourIndexFrequentType = new String[]{"", "boolean", "byte", "char", "double", "float", "int", "long", "null", "short", "void", "Object", "java.lang.Object", "String", "java.lang.String"};
    private static final TObjectIntHashMap<String> ourFrequentTypeIndex = new TObjectIntHashMap();
    private static final int FREQUENT_INDEX_MASK = 63;
    private static final int HAS_ARRAY_COUNT = 64;
    private static final int HAS_ELLIPSIS = 128;
    private static final TypeInfo NULL;
    public final String text;
    public final byte arrayCount;
    public final boolean isEllipsis;
    private final PsiAnnotationStub[] myAnnotationStubs;

    public TypeInfo(String text, byte arrayCount, boolean ellipsis, @NotNull PsiAnnotationStub[] annotationStubs) {
        if (annotationStubs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationStubs", "com/intellij/psi/impl/cache/TypeInfo", "<init>"));
        }
        this.text = text == null ? null : TypeInfo.internFrequentType(text);
        this.arrayCount = arrayCount;
        this.isEllipsis = ellipsis;
        this.myAnnotationStubs = annotationStubs;
    }

    @NotNull
    public TypeInfo applyAnnotations(@NotNull StubBase<?> owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/psi/impl/cache/TypeInfo", "applyAnnotations"));
        }
        PsiModifierListStub modifierList = (PsiModifierListStub)owner.findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        if (modifierList == null) {
            TypeInfo typeInfo = this;
            if (typeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "applyAnnotations"));
            }
            return typeInfo;
        }
        List annotationStubs = null;
        for (StubElement child : modifierList.getChildrenStubs()) {
            PsiAnnotationStub annotationStub;
            if (!(child instanceof PsiAnnotationStub) || !PsiImplUtil.isTypeAnnotation((PsiElement)(annotationStub = (PsiAnnotationStub)child).getPsiElement())) continue;
            if (annotationStubs == null) {
                annotationStubs = new SmartList();
            }
            annotationStubs.add(annotationStub);
        }
        PsiAnnotationStub[] stubArray = PsiAnnotationStub.EMPTY_ARRAY;
        if (annotationStubs != null) {
            stubArray = annotationStubs.toArray(new PsiAnnotationStub[annotationStubs.size()]);
        }
        TypeInfo typeInfo = new TypeInfo(this.text, this.arrayCount, this.isEllipsis, stubArray);
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "applyAnnotations"));
        }
        return typeInfo;
    }

    @NotNull
    public String getShortTypeText() {
        if (this.text == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "getShortTypeText"));
            }
            return "";
        }
        String name = PsiNameHelper.getShortClassName((String)this.text);
        if (this.arrayCount > 0) {
            name = name + StringUtil.repeat((String)"[]", (int)this.arrayCount);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "getShortTypeText"));
        }
        return string;
    }

    public String toString() {
        String text = TypeInfo.createTypeText(this);
        return text != null ? text : "null";
    }

    @NotNull
    public static TypeInfo createConstructorType() {
        TypeInfo typeInfo = NULL;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "createConstructorType"));
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo create(@NotNull LighterAST tree, @NotNull LighterASTNode element, StubElement parentStub) {
        String text;
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/cache/TypeInfo", "create"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/cache/TypeInfo", "create"));
        }
        byte arrayCount = 0;
        boolean isEllipsis = false;
        if (element.getTokenType() == JavaElementType.ENUM_CONSTANT) {
            text = ((PsiClassStub)parentStub).getName();
        } else {
            LighterASTNode nested;
            LighterASTNode typeElement = null;
            for (LighterASTNode child : tree.getChildren(element)) {
                IElementType type = child.getTokenType();
                if (type == JavaElementType.TYPE) {
                    typeElement = child;
                    continue;
                }
                if (type != JavaTokenType.LBRACKET) continue;
                arrayCount = (byte)(arrayCount + 1);
            }
            if (typeElement == null && element.getTokenType() == JavaElementType.FIELD) {
                LighterASTNode parent = tree.getParent(element);
                assert (parent != null) : element;
                List<LighterASTNode> fields = LightTreeUtil.getChildrenOfType(tree, parent, JavaElementType.FIELD);
                int idx = fields.indexOf(element);
                for (int i2 = idx - 1; i2 >= 0 && typeElement == null; --i2) {
                    typeElement = LightTreeUtil.firstChildOfType(tree, fields.get(i2), JavaElementType.TYPE);
                }
            }
            assert (typeElement != null) : element + " in " + parentStub;
            boolean bl = isEllipsis = LightTreeUtil.firstChildOfType(tree, typeElement, JavaTokenType.ELLIPSIS) != null;
            while ((nested = LightTreeUtil.firstChildOfType(tree, typeElement, JavaElementType.TYPE)) != null) {
                typeElement = nested;
                arrayCount = (byte)(arrayCount + 1);
            }
            text = LightTreeUtil.toFilteredString(tree, typeElement, null);
        }
        TypeInfo typeInfo = new TypeInfo(text, arrayCount, isEllipsis, PsiAnnotationStub.EMPTY_ARRAY);
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "create"));
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText, boolean isEllipsis) {
        if (typeText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeText", "com/intellij/psi/impl/cache/TypeInfo", "fromString"));
        }
        assert (!typeText.endsWith("...")) : typeText;
        byte arrayCount = 0;
        while (typeText.endsWith("[]")) {
            arrayCount = (byte)(arrayCount + 1);
            typeText = typeText.substring(0, typeText.length() - 2);
        }
        TypeInfo typeInfo = new TypeInfo(typeText, arrayCount, isEllipsis, PsiAnnotationStub.EMPTY_ARRAY);
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "fromString"));
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText) {
        if (typeText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeText", "com/intellij/psi/impl/cache/TypeInfo", "fromString"));
        }
        boolean isEllipsis = false;
        if (typeText.endsWith("...")) {
            isEllipsis = true;
            typeText = typeText.substring(0, typeText.length() - 3);
        }
        TypeInfo typeInfo = TypeInfo.fromString(typeText, isEllipsis);
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "fromString"));
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo readTYPE(@NotNull StubInputStream record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/psi/impl/cache/TypeInfo", "readTYPE"));
        }
        int flags = record.readByte() & 0xFF;
        if (flags == 63) {
            TypeInfo typeInfo = NULL;
            if (typeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "readTYPE"));
            }
            return typeInfo;
        }
        byte arrayCount = BitUtil.isSet((int)flags, (int)64) ? record.readByte() : (byte)0;
        boolean hasEllipsis = BitUtil.isSet((int)flags, (int)128);
        int frequentIndex = 0x3F & flags;
        String text = frequentIndex == 0 ? StringRef.toString((StringRef)record.readName()) : ourIndexFrequentType[frequentIndex];
        TypeInfo typeInfo = new TypeInfo(text, arrayCount, hasEllipsis, PsiAnnotationStub.EMPTY_ARRAY);
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "readTYPE"));
        }
        return typeInfo;
    }

    public static void writeTYPE(@NotNull StubOutputStream dataStream, @NotNull TypeInfo typeInfo) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/cache/TypeInfo", "writeTYPE"));
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "com/intellij/psi/impl/cache/TypeInfo", "writeTYPE"));
        }
        if (typeInfo == NULL) {
            dataStream.writeByte(63);
            return;
        }
        String text = typeInfo.text;
        byte arrayCount = typeInfo.arrayCount;
        int frequentIndex = ourFrequentTypeIndex.get((Object)text);
        int flags = (typeInfo.isEllipsis ? 128 : 0) | (arrayCount != 0 ? 64 : 0) | frequentIndex;
        dataStream.writeByte(flags);
        if (arrayCount != 0) {
            dataStream.writeByte((int)arrayCount);
        }
        if (frequentIndex == 0) {
            dataStream.writeName(text);
        }
    }

    @Nullable
    public static String createTypeText(@NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "com/intellij/psi/impl/cache/TypeInfo", "createTypeText"));
        }
        if (typeInfo == NULL || typeInfo.text == null) {
            return null;
        }
        if (typeInfo.arrayCount == 0 && typeInfo.myAnnotationStubs.length == 0) {
            return typeInfo.text;
        }
        StringBuilder buf = new StringBuilder();
        for (PsiAnnotationStub stub : typeInfo.myAnnotationStubs) {
            buf.append(stub.getText()).append(' ');
        }
        buf.append(typeInfo.text);
        int arrayCount = typeInfo.isEllipsis ? typeInfo.arrayCount - 1 : typeInfo.arrayCount;
        for (int i2 = 0; i2 < arrayCount; ++i2) {
            buf.append("[]");
        }
        if (typeInfo.isEllipsis) {
            buf.append("...");
        }
        return TypeInfo.internFrequentType(buf.toString());
    }

    @NotNull
    public static String internFrequentType(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/cache/TypeInfo", "internFrequentType"));
        }
        int frequentIndex = ourFrequentTypeIndex.get((Object)type);
        String string = frequentIndex == 0 ? type : ourIndexFrequentType[frequentIndex];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/TypeInfo", "internFrequentType"));
        }
        return string;
    }

    static {
        for (int i2 = 0; i2 < ourIndexFrequentType.length; ++i2) {
            ourFrequentTypeIndex.put((Object)ourIndexFrequentType[i2], i2);
        }
        NULL = new TypeInfo(null, 0, false, PsiAnnotationStub.EMPTY_ARRAY);
    }
}

