/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;

public class PsiTreeDebugBuilder {
    private StringBuffer myBuffer;
    private boolean myShowWhiteSpaces = true;
    private boolean myShowErrorElements = true;

    public PsiTreeDebugBuilder setShowWhiteSpaces(boolean showWhiteSpaces) {
        this.myShowWhiteSpaces = showWhiteSpaces;
        return this;
    }

    public PsiTreeDebugBuilder setShowErrorElements(boolean showErrorElements) {
        this.myShowErrorElements = showErrorElements;
        return this;
    }

    public String psiToString(PsiElement root) {
        return this.psiToString(root, false, false);
    }

    public String psiToString(PsiElement root, boolean showRanges, boolean showChildrenRanges) {
        this.myBuffer = new StringBuffer();
        this.psiToBuffer(root, 0, showRanges, showChildrenRanges);
        return this.myBuffer.toString();
    }

    private void psiToBuffer(PsiElement root, int indent, boolean showRanges, boolean showChildrenRanges) {
        if (!this.myShowWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        if (!this.myShowErrorElements && root instanceof PsiErrorElement) {
            return;
        }
        for (int i2 = 0; i2 < indent; ++i2) {
            this.myBuffer.append(' ');
        }
        String rootStr = root.toString();
        this.myBuffer.append(rootStr);
        PsiElement child = root.getFirstChild();
        if (child == null) {
            String text = root.getText();
            assert (text != null) : "text is null for <" + root + ">";
            text = StringUtil.replace((String)text, (String)"\n", (String)"\\n");
            text = StringUtil.replace((String)text, (String)"\r", (String)"\\r");
            text = StringUtil.replace((String)text, (String)"\t", (String)"\\t");
            this.myBuffer.append("('");
            this.myBuffer.append(text);
            this.myBuffer.append("')");
        }
        if (showRanges) {
            this.myBuffer.append(root.getTextRange());
        }
        this.myBuffer.append("\n");
        while (child != null) {
            this.psiToBuffer(child, indent + 2, showChildrenRanges, showChildrenRanges);
            child = child.getNextSibling();
        }
    }
}

