/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.java.ChildAlignmentStrategyProvider;
import com.intellij.psi.formatter.java.SubsequentFieldAligner;
import com.intellij.psi.formatter.java.SubsequentOneLineMethodsAligner;
import org.jetbrains.annotations.NotNull;

public class SubsequentClassMemberAlignment
extends ChildAlignmentStrategyProvider {
    private final ChildAlignmentStrategyProvider myFieldsAligner;
    private final ChildAlignmentStrategyProvider myOneLineMethodsAligner;

    public SubsequentClassMemberAlignment(CommonCodeStyleSettings settings) {
        this.myFieldsAligner = new SubsequentFieldAligner(settings);
        this.myOneLineMethodsAligner = SubsequentClassMemberAlignment.getSimpleMethodsAligner(settings);
    }

    private static ChildAlignmentStrategyProvider getSimpleMethodsAligner(CommonCodeStyleSettings settings) {
        if (settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE && settings.ALIGN_SUBSEQUENT_SIMPLE_METHODS) {
            return new SubsequentOneLineMethodsAligner();
        }
        return ChildAlignmentStrategyProvider.NULL_STRATEGY_PROVIDER;
    }

    @Override
    public AlignmentStrategy getNextChildStrategy(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/formatter/java/SubsequentClassMemberAlignment", "getNextChildStrategy"));
        }
        AlignmentStrategy fieldInColumnsAlignment = this.myFieldsAligner.getNextChildStrategy(child);
        AlignmentStrategy oneLineMethodsAlignment = this.myOneLineMethodsAligner.getNextChildStrategy(child);
        if (fieldInColumnsAlignment != AlignmentStrategy.getNullStrategy()) {
            return fieldInColumnsAlignment;
        }
        return oneLineMethodsAlignment;
    }
}

