/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

class TimeStampedIndentOptions
extends CommonCodeStyleSettings.IndentOptions {
    private long myTimeStamp;
    private int myOriginalIndentOptionsHash;

    public TimeStampedIndentOptions(CommonCodeStyleSettings.IndentOptions toCopyFrom, long timeStamp) {
        this.copyFrom(toCopyFrom);
        this.myTimeStamp = timeStamp;
    }

    void setTimeStamp(long timeStamp) {
        this.myTimeStamp = timeStamp;
    }

    public void setOriginalIndentOptionsHash(int originalIndentOptionsHash) {
        this.myOriginalIndentOptionsHash = originalIndentOptionsHash;
    }

    public boolean isOutdated(@NotNull Document document, @NotNull CommonCodeStyleSettings.IndentOptions defaultForFile) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/codeStyle/TimeStampedIndentOptions", "isOutdated"));
        }
        if (defaultForFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultForFile", "com/intellij/psi/codeStyle/TimeStampedIndentOptions", "isOutdated"));
        }
        return document.getModificationStamp() != this.myTimeStamp || defaultForFile.hashCode() != this.myOriginalIndentOptionsHash;
    }
}

