/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchivedTemplatesFactory
extends ProjectTemplatesFactory {
    private static final Logger LOG = Logger.getInstance(ArchivedTemplatesFactory.class);
    static final String ZIP = ".zip";

    @NotNull
    private static URL getCustomTemplatesURL() {
        URL uRL;
        try {
            uRL = new File(ArchivedTemplatesFactory.getCustomTemplatesPath()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (uRL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedTemplatesFactory", "getCustomTemplatesURL"));
        }
        return uRL;
    }

    @NotNull
    static String getCustomTemplatesPath() {
        String string = PathManager.getConfigPath() + "/projectTemplates";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedTemplatesFactory", "getCustomTemplatesPath"));
        }
        return string;
    }

    public static File getTemplateFile(String name) {
        return new File(ArchivedTemplatesFactory.getCustomTemplatesPath() + "/" + name + ZIP);
    }

    @Override
    @NotNull
    public String[] getGroups() {
        String[] stringArray = new String[]{"User-defined"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedTemplatesFactory", "getGroups"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public ProjectTemplate[] createTemplates(@Nullable String group, WizardContext context) {
        if (!"User-defined".equals(group)) {
            if (ProjectTemplate.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedTemplatesFactory", "createTemplates"));
            }
            return ProjectTemplate.EMPTY_ARRAY;
        }
        List templates = null;
        URL url = ArchivedTemplatesFactory.getCustomTemplatesURL();
        try {
            for (String child : UrlUtil.getChildrenRelativePaths(url)) {
                if (!child.endsWith(ZIP)) continue;
                if (templates == null) {
                    templates = new SmartList();
                }
                templates.add(new LocalArchivedTemplate(new URL(url.toExternalForm() + '/' + child), ClassLoader.getSystemClassLoader()));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        ProjectTemplate[] projectTemplateArray = ContainerUtil.isEmpty(templates) ? ProjectTemplate.EMPTY_ARRAY : templates.toArray(new ProjectTemplate[templates.size()]);
        if (projectTemplateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedTemplatesFactory", "createTemplates"));
        }
        return projectTemplateArray;
    }

    @Override
    public int getGroupWeight(String group) {
        return "User-defined".equals(group) ? -2 : 0;
    }

    @Override
    public Icon getGroupIcon(String group) {
        return "User-defined".equals(group) ? AllIcons.Modules.Types.UserDefined : super.getGroupIcon(group);
    }
}

