/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.util.GotoLineNumberDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class PositionPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
StatusBarWidget.TextPresentation,
CaretListener,
SelectionListener {
    private String myText;

    public PositionPanel(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/status/PositionPanel", "<init>"));
        }
        super(project2);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/PositionPanel", "selectionChanged"));
        }
        this.updatePosition(this.getEditor());
    }

    @NotNull
    public String ID() {
        if ("Position" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/PositionPanel", "ID"));
        }
        return "Position";
    }

    public StatusBarWidget copy() {
        return new PositionPanel(this.getProject());
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/status/PositionPanel", "getPresentation"));
        }
        return this;
    }

    @NotNull
    public String getText() {
        String string = this.myText == null ? "" : this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/PositionPanel", "getText"));
        }
        return string;
    }

    @NotNull
    public String getMaxPossibleText() {
        if ("0000000000000" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/PositionPanel", "getMaxPossibleText"));
        }
        return "0000000000000";
    }

    public float getAlignment() {
        return 0.5f;
    }

    public String getTooltipText() {
        return UIBundle.message((String)"go.to.line.command.double.click", (Object[])new Object[0]);
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return mouseEvent -> {
            Project project2 = this.getProject();
            if (project2 == null) {
                return;
            }
            Editor editor = this.getEditor();
            if (editor == null) {
                return;
            }
            CommandProcessor processor2 = CommandProcessor.getInstance();
            processor2.executeCommand(project2, () -> {
                GotoLineNumberDialog dialog2 = new GotoLineNumberDialog(project2, editor);
                dialog2.show();
                IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
            }, UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]), null);
        };
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/PositionPanel", "install"));
        }
        super.install(statusBar);
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addCaretListener((CaretListener)this, (Disposable)this);
        multicaster.addSelectionListener((SelectionListener)this, (Disposable)this);
    }

    public void selectionChanged(SelectionEvent e) {
        this.updatePosition(e.getEditor());
    }

    public void caretPositionChanged(CaretEvent e) {
        this.updatePosition(e.getEditor());
    }

    public void caretAdded(CaretEvent e) {
        this.updatePosition(e.getEditor());
    }

    public void caretRemoved(CaretEvent e) {
        this.updatePosition(e.getEditor());
    }

    private void updatePosition(Editor editor) {
        if (editor == null) {
            this.myText = "";
        } else {
            if (!this.isOurEditor(editor)) {
                return;
            }
            this.myText = this.getPositionText(editor);
        }
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    private String getPositionText(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/wm/impl/status/PositionPanel", "getPositionText"));
        }
        if (!editor.isDisposed() && this.myStatusBar != null) {
            StringBuilder message = new StringBuilder();
            SelectionModel selectionModel = editor.getSelectionModel();
            int caretCount = editor.getCaretModel().getCaretCount();
            if (caretCount > 1) {
                message.append(UIBundle.message((String)"position.panel.caret.count", (Object[])new Object[]{caretCount}));
            } else {
                if (selectionModel.hasSelection()) {
                    int selectionStart = selectionModel.getSelectionStart();
                    int selectionEnd = selectionModel.getSelectionEnd();
                    if (selectionEnd > selectionStart) {
                        message.append(UIBundle.message((String)"position.panel.selected.chars.count", (Object[])new Object[]{selectionEnd - selectionStart}));
                        int selectionStartLine = editor.getDocument().getLineNumber(selectionStart);
                        int selectionEndLine = editor.getDocument().getLineNumber(selectionEnd);
                        if (selectionEndLine > selectionStartLine) {
                            message.append(", ");
                            message.append(UIBundle.message((String)"position.panel.selected.lines.count", (Object[])new Object[]{selectionEndLine - selectionStartLine + 1}));
                        }
                        message.append("     ");
                    }
                }
                LogicalPosition caret = editor.getCaretModel().getLogicalPosition();
                message.append(caret.line + 1).append(":").append(caret.column + 1);
            }
            return message.toString();
        }
        return "";
    }
}

