/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.IdeFocusManagerHeadless;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowHeadlessManagerImpl
extends ToolWindowManagerEx {
    private final Map<String, ToolWindow> myToolWindows = new HashMap<String, ToolWindow>();
    private final Project myProject;

    public ToolWindowHeadlessManagerImpl(Project project2) {
        this.myProject = project2;
    }

    public boolean canShowNotification(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "canShowNotification"));
        }
        return false;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String htmlBody) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "notifyByBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "notifyByBalloon"));
        }
        if (htmlBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlBody", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "notifyByBalloon"));
        }
    }

    private ToolWindow doRegisterToolWindow(String id, @Nullable Disposable parentDisposable) {
        MockToolWindow tw = new MockToolWindow(this.myProject);
        this.myToolWindows.put(id, tw);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> this.unregisterToolWindow(id));
        }
        return tw;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, null);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean canCloseContents) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, null);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, boolean secondary) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, null);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean dumbAware) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean secondary) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.doRegisterToolWindow(id, parentDisposable);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    public void unregisterToolWindow(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "unregisterToolWindow"));
        }
        this.myToolWindows.remove(id);
    }

    public void activateEditorComponent() {
    }

    public boolean isEditorComponentActive() {
        return false;
    }

    @NotNull
    public String[] getToolWindowIds() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "getToolWindowIds"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getActiveToolWindowId() {
        return null;
    }

    public ToolWindow getToolWindow(String id) {
        return this.myToolWindows.get(id);
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "invokeLater"));
        }
    }

    @NotNull
    public IdeFocusManager getFocusManager() {
        IdeFocusManagerHeadless ideFocusManagerHeadless = IdeFocusManagerHeadless.INSTANCE;
        if (ideFocusManagerHeadless == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "getFocusManager"));
        }
        return ideFocusManagerHeadless;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String text, @Nullable Icon icon, @Nullable HyperlinkListener listener2) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "notifyByBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "notifyByBalloon"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "notifyByBalloon"));
        }
    }

    public Balloon getToolWindowBalloon(String id) {
        return null;
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        if (wnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wnd", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "isMaximized"));
        }
        return false;
    }

    public void setMaximized(@NotNull ToolWindow wnd, boolean maximized) {
        if (wnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wnd", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "setMaximized"));
        }
    }

    @Override
    public void initToolWindow(@NotNull ToolWindowEP bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "initToolWindow"));
        }
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "addToolWindowManagerListener"));
        }
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "addToolWindowManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "addToolWindowManagerListener"));
        }
    }

    @Override
    public void removeToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "removeToolWindowManagerListener"));
        }
    }

    @Override
    public String getLastActiveToolWindowId() {
        return null;
    }

    @Override
    public String getLastActiveToolWindowId(Condition<JComponent> condition) {
        return null;
    }

    @Override
    public DesktopLayout getLayout() {
        return new DesktopLayout();
    }

    @Override
    public void setLayoutToRestoreLater(DesktopLayout layout) {
    }

    @Override
    public DesktopLayout getLayoutToRestoreLater() {
        return new DesktopLayout();
    }

    @Override
    public void setLayout(@NotNull DesktopLayout layout) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "setLayout"));
        }
    }

    @Override
    public void clearSideStack() {
    }

    @Override
    public void hideToolWindow(@NotNull String id, boolean hideSide) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "hideToolWindow"));
        }
    }

    @Override
    @NotNull
    public List<String> getIdsOn(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "getIdsOn"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl", "getIdsOn"));
        }
        return arrayList;
    }

    private static class MockContentManager
    implements ContentManager {
        private final EventDispatcher<ContentManagerListener> myDispatcher = EventDispatcher.create(ContentManagerListener.class);
        private final List<Content> myContents = new ArrayList<Content>();
        private Content mySelected;

        private MockContentManager() {
        }

        @NotNull
        public ActionCallback getReady(@NotNull Object requestor) {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getReady"));
            }
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getReady"));
            }
            return actionCallback;
        }

        public void addContent(@NotNull Content content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "addContent"));
            }
            this.addContent(content, -1);
        }

        public void addContent(@NotNull Content content, int order) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "addContent"));
            }
            this.myContents.add(order == -1 ? this.myContents.size() : order, content);
            if (content instanceof ContentImpl && content.getManager() == null) {
                ((ContentImpl)content).setManager(this);
            }
            Disposer.register((Disposable)this, (Disposable)content);
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(content), ContentManagerEvent.ContentOperation.add);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
            if (this.mySelected == null) {
                this.setSelectedContent(content);
            }
        }

        public void addContent(@NotNull Content content, Object constraints) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "addContent"));
            }
            this.addContent(content);
        }

        public void addSelectedContent(@NotNull Content content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "addSelectedContent"));
            }
            this.addContent(content);
            this.setSelectedContent(content);
        }

        public void addContentManagerListener(@NotNull ContentManagerListener l) {
            if (l == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "addContentManagerListener"));
            }
            this.myDispatcher.getListeners().add(0, l);
        }

        public void addDataProvider(@NotNull DataProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "addDataProvider"));
            }
        }

        public boolean canCloseAllContents() {
            return false;
        }

        public boolean canCloseContents() {
            return false;
        }

        public Content findContent(String displayName) {
            for (Content each : this.myContents) {
                if (!each.getDisplayName().equals(displayName)) continue;
                return each;
            }
            return null;
        }

        public List<AnAction> getAdditionalPopupActions(@NotNull Content content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getAdditionalPopupActions"));
            }
            return Collections.emptyList();
        }

        @NotNull
        public String getCloseActionName() {
            if ("close" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getCloseActionName"));
            }
            return "close";
        }

        @NotNull
        public String getCloseAllButThisActionName() {
            if ("closeallbutthis" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getCloseAllButThisActionName"));
            }
            return "closeallbutthis";
        }

        @NotNull
        public String getPreviousContentActionName() {
            if ("previous" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getPreviousContentActionName"));
            }
            return "previous";
        }

        @NotNull
        public String getNextContentActionName() {
            if ("next" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getNextContentActionName"));
            }
            return "next";
        }

        @NotNull
        public JComponent getComponent() {
            JLabel jLabel = new JLabel();
            if (jLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getComponent"));
            }
            return jLabel;
        }

        public Content getContent(JComponent component) {
            Content[] contents;
            for (Content content : contents = this.getContents()) {
                if (!Comparing.equal((Object)component, (Object)content.getComponent())) continue;
                return content;
            }
            return null;
        }

        @Nullable
        public Content getContent(int index) {
            return this.myContents.get(index);
        }

        public int getContentCount() {
            return this.myContents.size();
        }

        @NotNull
        public Content[] getContents() {
            Content[] contentArray = this.myContents.toArray(new Content[this.myContents.size()]);
            if (contentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getContents"));
            }
            return contentArray;
        }

        public int getIndexOfContent(Content content) {
            return this.myContents.indexOf(content);
        }

        @Nullable
        public Content getSelectedContent() {
            return this.mySelected;
        }

        @NotNull
        public Content[] getSelectedContents() {
            Content[] contentArray;
            if (this.mySelected != null) {
                Content[] contentArray2 = new Content[1];
                contentArray = contentArray2;
                contentArray2[0] = this.mySelected;
            } else {
                contentArray = new Content[]{};
            }
            if (contentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getSelectedContents"));
            }
            return contentArray;
        }

        public boolean isSelected(@NotNull Content content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "isSelected"));
            }
            return content == this.mySelected;
        }

        public void removeAllContents(boolean dispose) {
            for (Content content : this.getContents()) {
                this.removeContent(content, dispose);
            }
        }

        public boolean removeContent(@NotNull Content content, boolean dispose) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "removeContent"));
            }
            boolean wasSelected = this.mySelected == content;
            int oldIndex = this.myContents.indexOf(content);
            if (wasSelected) {
                this.removeFromSelection(content);
            }
            boolean result2 = this.myContents.remove(content);
            if (dispose) {
                Disposer.dispose((Disposable)content);
            }
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, oldIndex, ContentManagerEvent.ContentOperation.remove);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
            Content item = (Content)ContainerUtil.getFirstItem(this.myContents);
            if (item != null) {
                this.setSelectedContent(item);
            }
            return result2;
        }

        @NotNull
        public ActionCallback removeContent(@NotNull Content content, boolean dispose, boolean trackFocus, boolean implicitFocus) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "removeContent"));
            }
            this.removeContent(content, dispose);
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "removeContent"));
            }
            return actionCallback;
        }

        public void removeContentManagerListener(@NotNull ContentManagerListener l) {
            if (l == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "removeContentManagerListener"));
            }
            this.myDispatcher.removeListener((EventListener)l);
        }

        public void removeFromSelection(@NotNull Content content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "removeFromSelection"));
            }
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(this.mySelected), ContentManagerEvent.ContentOperation.remove);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
        }

        public ActionCallback selectNextContent() {
            return ActionCallback.DONE;
        }

        public ActionCallback selectPreviousContent() {
            return ActionCallback.DONE;
        }

        public void setSelectedContent(@NotNull Content content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContent"));
            }
            if (this.mySelected != null) {
                this.removeFromSelection(this.mySelected);
            }
            this.mySelected = content;
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(content), ContentManagerEvent.ContentOperation.add);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContentCB"));
            }
            this.setSelectedContent(content);
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContentCB"));
            }
            return actionCallback;
        }

        public void setSelectedContent(@NotNull Content content, boolean requestFocus) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContent"));
            }
            this.setSelectedContent(content);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContentCB"));
            }
            ActionCallback actionCallback = this.setSelectedContentCB(content);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContentCB"));
            }
            return actionCallback;
        }

        public void setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContent"));
            }
            this.setSelectedContent(content);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContentCB"));
            }
            ActionCallback actionCallback = this.setSelectedContentCB(content);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContentCB"));
            }
            return actionCallback;
        }

        @NotNull
        public ActionCallback setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus, boolean implicit) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContent"));
            }
            ActionCallback actionCallback = this.setSelectedContentCB(content);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "setSelectedContent"));
            }
            return actionCallback;
        }

        @NotNull
        public ActionCallback requestFocus(@Nullable Content content, boolean forced) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "requestFocus"));
            }
            return actionCallback;
        }

        public void dispose() {
            this.myContents.clear();
            this.mySelected = null;
            this.myDispatcher.getListeners().clear();
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isSingleSelection() {
            return true;
        }

        @NotNull
        public ContentFactory getFactory() {
            ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
            if (contentFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockContentManager", "getFactory"));
            }
            return contentFactory;
        }
    }

    public static class MockToolWindow
    implements ToolWindowEx {
        ContentManager myContentManager;

        public MockToolWindow(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "<init>"));
            }
            this.myContentManager = new MockContentManager();
            Disposer.register((Disposable)project2, (Disposable)this.myContentManager);
        }

        public boolean isActive() {
            return false;
        }

        public void activate(@Nullable Runnable runnable2) {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isVisible() {
            return false;
        }

        public void setShowStripeButton(boolean show) {
        }

        public boolean isShowStripeButton() {
            return false;
        }

        @NotNull
        public ActionCallback getReady(@NotNull Object requestor) {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "getReady"));
            }
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "getReady"));
            }
            return actionCallback;
        }

        public void show(@Nullable Runnable runnable2) {
        }

        public void hide(@Nullable Runnable runnable2) {
        }

        public ToolWindowAnchor getAnchor() {
            return ToolWindowAnchor.BOTTOM;
        }

        public void setAnchor(@NotNull ToolWindowAnchor anchor, @Nullable Runnable runnable2) {
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "setAnchor"));
            }
        }

        public boolean isSplitMode() {
            return false;
        }

        public void setSplitMode(boolean isSideTool, @Nullable Runnable runnable2) {
        }

        public boolean isAutoHide() {
            return false;
        }

        public void setAutoHide(boolean state) {
        }

        public void setToHideOnEmptyContent(boolean hideOnEmpty) {
        }

        public boolean isToHideOnEmptyContent() {
            return false;
        }

        public ToolWindowType getType() {
            return ToolWindowType.SLIDING;
        }

        public void setType(@NotNull ToolWindowType type, @Nullable Runnable runnable2) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "setType"));
            }
        }

        public Icon getIcon() {
            return null;
        }

        public void setIcon(Icon icon) {
        }

        public String getTitle() {
            return "";
        }

        public void setTitle(String title) {
        }

        @NotNull
        public String getStripeTitle() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "getStripeTitle"));
            }
            return "";
        }

        public void setStripeTitle(@NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "setStripeTitle"));
            }
        }

        public boolean isAvailable() {
            return false;
        }

        public void setContentUiType(@NotNull ToolWindowContentUiType type, @Nullable Runnable runnable2) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "setContentUiType"));
            }
        }

        public void setDefaultContentUiType(@NotNull ToolWindowContentUiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "setDefaultContentUiType"));
            }
        }

        @NotNull
        public ToolWindowContentUiType getContentUiType() {
            ToolWindowContentUiType toolWindowContentUiType = ToolWindowContentUiType.TABBED;
            if (toolWindowContentUiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowHeadlessManagerImpl$MockToolWindow", "getContentUiType"));
            }
            return toolWindowContentUiType;
        }

        public void setAvailable(boolean available, @Nullable Runnable runnable2) {
        }

        public void installWatcher(ContentManager contentManager) {
        }

        public JComponent getComponent() {
            return null;
        }

        public ContentManager getContentManager() {
            return this.myContentManager;
        }

        public void setDefaultState(@Nullable ToolWindowAnchor anchor, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds) {
        }

        public void activate(@Nullable Runnable runnable2, boolean autoFocusContents) {
        }

        public void activate(@Nullable Runnable runnable2, boolean autoFocusContents, boolean forced) {
        }

        public void showContentPopup(InputEvent inputEvent) {
        }

        public ActionCallback getActivation() {
            return ActionCallback.DONE;
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public ToolWindowType getInternalType() {
            return ToolWindowType.DOCKED;
        }

        @Override
        public void stretchWidth(int value) {
        }

        @Override
        public void stretchHeight(int value) {
        }

        @Override
        public InternalDecorator getDecorator() {
            return null;
        }

        @Override
        public void setAdditionalGearActions(ActionGroup additionalGearActions) {
        }

        @Override
        public void setTitleActions(AnAction ... actions) {
        }

        @Override
        public void setUseLastFocusedOnActivation(boolean focus) {
        }

        @Override
        public boolean isUseLastFocusedOnActivation() {
            return false;
        }
    }
}

