/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import java.util.Iterator;
import java.util.Stack;

final class SideStack {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.SideStack");
    private final Stack myStack = new Stack();

    SideStack() {
    }

    void push(WindowInfoImpl info) {
        LOG.assertTrue(info.isDocked());
        LOG.assertTrue(!info.isAutoHide());
        this.myStack.push(info.copy());
    }

    WindowInfoImpl pop(ToolWindowAnchor anchor) {
        int i2 = this.myStack.size() - 1;
        while (true) {
            WindowInfoImpl info;
            if (anchor == (info = (WindowInfoImpl)this.myStack.get(i2)).getAnchor()) {
                this.myStack.remove(i2);
                return info;
            }
            --i2;
        }
    }

    boolean isEmpty(ToolWindowAnchor anchor) {
        for (int i2 = this.myStack.size() - 1; i2 > -1; --i2) {
            WindowInfoImpl info = (WindowInfoImpl)this.myStack.get(i2);
            if (anchor != info.getAnchor()) continue;
            return false;
        }
        return true;
    }

    void remove(String id) {
        Iterator i2 = this.myStack.iterator();
        while (i2.hasNext()) {
            WindowInfoImpl info = (WindowInfoImpl)i2.next();
            if (!id.equals(info.getId())) continue;
            i2.remove();
        }
    }

    void clear() {
        this.myStack.clear();
    }
}

