/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.util.containers.Stack;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

final class ActiveStack {
    private final Stack<String> myStack = new Stack();
    private final Stack<String> myPersistentStack = new Stack();

    ActiveStack() {
    }

    void clear() {
        this.myStack.clear();
    }

    boolean isEmpty() {
        return this.myStack.isEmpty();
    }

    @NotNull
    String pop() {
        String string = (String)this.myStack.pop();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ActiveStack", "pop"));
        }
        return string;
    }

    @NotNull
    String peek() {
        String string = (String)this.myStack.peek();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ActiveStack", "peek"));
        }
        return string;
    }

    int getSize() {
        return this.myStack.size();
    }

    @NotNull
    private String peek(int i2) {
        String string = (String)this.myStack.get(this.getSize() - i2 - 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ActiveStack", "peek"));
        }
        return string;
    }

    @NotNull
    String[] getStack() {
        String[] result2 = new String[this.getSize()];
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            result2[i2] = this.peek(i2);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ActiveStack", "getStack"));
        }
        return result2;
    }

    @NotNull
    String[] getPersistentStack() {
        String[] result2 = new String[this.getPersistentSize()];
        for (int i2 = 0; i2 < this.getPersistentSize(); ++i2) {
            result2[i2] = this.peekPersistent(i2);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ActiveStack", "getPersistentStack"));
        }
        return result2;
    }

    void push(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ActiveStack", "push"));
        }
        this.remove(id, true);
        this.myStack.push((Object)id);
        this.myPersistentStack.push((Object)id);
    }

    int getPersistentSize() {
        return this.myPersistentStack.size();
    }

    @NotNull
    String peekPersistent(int index) {
        String string = (String)this.myPersistentStack.get(this.myPersistentStack.size() - index - 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ActiveStack", "peekPersistent"));
        }
        return string;
    }

    void remove(@NotNull String id, boolean removePersistentAlso) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ActiveStack", "remove"));
        }
        Iterator i2 = this.myStack.iterator();
        while (i2.hasNext()) {
            if (!id.equals(i2.next())) continue;
            i2.remove();
        }
        if (removePersistentAlso) {
            i2 = this.myPersistentStack.iterator();
            while (i2.hasNext()) {
                if (!id.equals(i2.next())) continue;
                i2.remove();
            }
        }
    }
}

