/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.lang.LangBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandlerStub;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.TObjectHashingStrategy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrtFileSystemImpl
extends JrtFileSystem {
    private final Map<String, ArchiveHandler> myHandlers = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private final AtomicBoolean mySubscribed = new AtomicBoolean(false);

    public JrtFileSystemImpl() {
        JrtFileSystemImpl.scheduleConfiguredSdkCheck();
    }

    private static void scheduleConfiguredSdkCheck() {
        final MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appStarting(Project project2) {
                for (Sdk sdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    Stream.of(sdk.getRootProvider().getUrls(OrderRootType.CLASSES)).filter(url -> url.startsWith("jrt://")).findFirst().ifPresent(url -> {
                        if (!JrtFileSystem.isSupported()) {
                            String title = LangBundle.message("jrt.not.available.title", sdk.getName());
                            String message = LangBundle.message("jrt.not.available.message", new Object[0]);
                            Notifications.Bus.notify((Notification)new Notification("System Messages", title, message, NotificationType.WARNING));
                        } else if (url.endsWith("!/")) {
                            String title = LangBundle.message("jrt.outdated.title", sdk.getName());
                            String message = LangBundle.message("jrt.outdated.message", new Object[0]);
                            Notifications.Bus.notify((Notification)new Notification("System Messages", title, message, NotificationType.WARNING));
                        }
                    });
                }
                connection.disconnect();
            }
        });
    }

    @NotNull
    public String getProtocol() {
        if ("jrt" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "getProtocol"));
        }
        return "jrt";
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "normalize"));
        }
        int p = path.indexOf("!/");
        return p > 0 ? FileUtil.normalize((String)path.substring(0, p)) + path.substring(p) : super.normalize(path);
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "extractLocalPath"));
        }
        String string = StringUtil.trimEnd((String)rootPath, (String)"!/");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "extractLocalPath"));
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "composeRootPath"));
        }
        String string = localPath + "!/";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "composeRootPath"));
        }
        return string;
    }

    @NotNull
    protected String extractRootPath(@NotNull String entryPath) {
        if (entryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryPath", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "extractRootPath"));
        }
        int separatorIndex = entryPath.indexOf("!/");
        assert (separatorIndex >= 0) : "Path passed to JrtFileSystem must have a separator '!/': " + entryPath;
        String string = entryPath.substring(0, separatorIndex + "!/".length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "extractRootPath"));
        }
        return string;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryFile", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "getHandler"));
        }
        this.checkSubscription();
        String homePath = this.extractLocalPath(this.extractRootPath(entryFile.getPath()));
        ArchiveHandler handler2 = this.myHandlers.get(homePath);
        if (handler2 == null) {
            handler2 = JrtFileSystemImpl.isSupported() ? new JrtHandler(homePath) : new JrtHandlerStub(homePath);
            this.myHandlers.put(homePath, handler2);
            ApplicationManager.getApplication().invokeLater(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(homePath + "/release"), ModalityState.defaultModalityState());
        }
        ArchiveHandler archiveHandler = handler2;
        if (archiveHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "getHandler"));
        }
        return archiveHandler;
    }

    private void checkSubscription() {
        if (this.mySubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl$2", "after"));
                }
                HashSet toRefresh = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile root;
                    VirtualFile file2;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || !(vFileEvent instanceof VFileContentChangeEvent) || (file2 = vFileEvent.getFile()) == null || !"release".equals(file2.getName())) continue;
                    String homePath = file2.getParent().getPath();
                    if (JrtFileSystemImpl.this.myHandlers.remove(homePath) == null || (root = JrtFileSystemImpl.this.findFileByPath(JrtFileSystemImpl.this.composeRootPath(homePath))) == null) continue;
                    ((NewVirtualFile)root).markDirtyRecursively();
                    if (toRefresh == null) {
                        toRefresh = ContainerUtil.newHashSet();
                    }
                    toRefresh.add(root);
                }
                if (toRefresh != null) {
                    boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                    RefreshQueue.getInstance().refresh(async, true, null, toRefresh);
                }
            }
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "findFileByPath"));
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "findFileByPathIfCached"));
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "refreshAndFindFileByPath"));
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, asynchronous);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl", "isCorrectFileType"));
        }
        return JrtFileSystemImpl.isModularJdk((String)FileUtil.toSystemDependentName((String)local.getPath()));
    }
}

