/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ComputableActionGroup;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.checkout.CheckoutAction;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CheckoutActionGroup
extends ComputableActionGroup.Simple {
    @Override
    @NotNull
    protected AnAction[] computeChildren(@NotNull ActionManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/vcs/checkout/CheckoutActionGroup", "computeChildren"));
        }
        CheckoutProvider[] providers = (CheckoutProvider[])CheckoutProvider.EXTENSION_POINT_NAME.getExtensions();
        if (providers.length == 0) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/checkout/CheckoutActionGroup", "computeChildren"));
            }
            return EMPTY_ARRAY;
        }
        Arrays.sort(providers, new CheckoutProvider.CheckoutProviderComparator());
        AnAction[] children2 = new AnAction[providers.length];
        for (int i2 = 0; i2 < providers.length; ++i2) {
            CheckoutProvider provider = providers[i2];
            children2[i2] = this.createAction(provider);
        }
        if (children2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/checkout/CheckoutActionGroup", "computeChildren"));
        }
        return children2;
    }

    @NotNull
    protected AnAction createAction(CheckoutProvider provider) {
        CheckoutAction checkoutAction = new CheckoutAction(provider);
        if (checkoutAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/checkout/CheckoutActionGroup", "createAction"));
        }
        return checkoutAction;
    }
}

