/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    @NonNls
    public static final String ROOT_NODE_VALUE = "root";
    public static final String LOCALLY_DELETED_NODE = VcsBundle.message((String)"changes.nodetitle.locally.deleted.files", (Object[])new Object[0]);
    private static final int UNVERSIONED_MAX_SIZE = 50;
    @NotNull
    private final Project myProject;
    private final boolean showFlatten;
    @NotNull
    private DefaultTreeModel model;
    @NotNull
    private final ChangesBrowserNode root;
    private boolean myPolicyInitialized;
    @Nullable
    private ChangesGroupingPolicy myPolicy;
    @NotNull
    private HashMap<String, ChangesBrowserNode> myFoldersCache;
    private static final Comparator<ChangesBrowserNode> BROWSER_NODE_COMPARATOR = (node1, node2) -> {
        int sortWeightDiff = Comparing.compare((int)node1.getSortWeight(), (int)node2.getSortWeight());
        if (sortWeightDiff != 0) {
            return sortWeightDiff;
        }
        if (node1 instanceof Comparable && node1.getClass().equals(node2.getClass())) {
            return ((Comparable)((Object)node1)).compareTo(node2);
        }
        return node1.compareUserObjects(node2.getUserObject());
    };
    private static final Comparator<Change> PATH_LENGTH_COMPARATOR = (o1, o2) -> {
        FilePath fp1 = ChangesUtil.getFilePath((Change)o1);
        FilePath fp2 = ChangesUtil.getFilePath((Change)o2);
        return Comparing.compare((int)fp1.getPath().length(), (int)fp2.getPath().length());
    };

    public TreeModelBuilder(@NotNull Project project2, boolean showFlatten) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "<init>"));
        }
        this.myProject = project2;
        this.showFlatten = showFlatten;
        this.root = ChangesBrowserNode.create(this.myProject, ROOT_NODE_VALUE);
        this.model = new DefaultTreeModel(this.root);
        this.myFoldersCache = new HashMap();
    }

    @NotNull
    public DefaultTreeModel buildModel(@NotNull List<Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModel"));
        }
        DefaultTreeModel defaultTreeModel = this.setChanges(changes, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModel"));
        }
        return defaultTreeModel;
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull List<Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setChanges"));
        }
        Collections.sort(changes, PATH_LENGTH_COMPARATOR);
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        for (Change change : changes) {
            this.insertChangeNode(change, policy, this.root, this.createChangeNode(change, changeNodeDecorator));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setChanges"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setUnversioned(@NotNull List<VirtualFile> unversionedFiles, @NotNull Couple<Integer> sizes) {
        if (unversionedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unversionedFiles", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setUnversioned"));
        }
        if (sizes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sizes", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setUnversioned"));
        }
        if (!unversionedFiles.isEmpty()) {
            this.resetGrouping();
            ChangesBrowserUnversionedFilesNode node = new ChangesBrowserUnversionedFilesNode(this.myProject, (Integer)sizes.getFirst(), (Integer)sizes.getSecond(), unversionedFiles.size() > 50);
            this.model.insertNodeInto(node, this.root, this.root.getChildCount());
            if (!node.isManyUnversioned()) {
                this.insertFilesIntoNode(unversionedFiles, node);
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setUnversioned"));
        }
        return treeModelBuilder;
    }

    @Nullable
    private ChangesGroupingPolicy createGroupingPolicy() {
        if (!this.myPolicyInitialized) {
            this.myPolicyInitialized = true;
            ChangesGroupingPolicyFactory factory = ChangesGroupingPolicyFactory.getInstance(this.myProject);
            if (factory != null) {
                this.myPolicy = factory.createGroupingPolicy(this.model);
            }
        }
        return this.myPolicy;
    }

    @NotNull
    public DefaultTreeModel buildModelFromFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModelFromFiles"));
        }
        this.buildVirtualFiles(files, null);
        DefaultTreeModel defaultTreeModel = this.build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModelFromFiles"));
        }
        return defaultTreeModel;
    }

    @NotNull
    public DefaultTreeModel buildModelFromFilePaths(@NotNull Collection<FilePath> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModelFromFilePaths"));
        }
        this.buildFilePaths(files, this.root);
        DefaultTreeModel defaultTreeModel = this.build();
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModelFromFilePaths"));
        }
        return defaultTreeModel;
    }

    @NotNull
    public TreeModelBuilder set(@NotNull List<? extends ChangeList> changeLists, @NotNull List<LocallyDeletedChange> locallyDeletedFiles, @NotNull List<VirtualFile> modifiedWithoutEditing, @NotNull MultiMap<String, VirtualFile> switchedFiles, @Nullable Map<VirtualFile, String> switchedRoots, @Nullable List<VirtualFile> ignoredFiles, @Nullable List<VirtualFile> lockedFolders, @Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "set"));
        }
        if (locallyDeletedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locallyDeletedFiles", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "set"));
        }
        if (modifiedWithoutEditing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiedWithoutEditing", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "set"));
        }
        if (switchedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchedFiles", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "set"));
        }
        this.resetGrouping();
        this.buildModel(changeLists);
        if (!modifiedWithoutEditing.isEmpty()) {
            this.resetGrouping();
            this.buildVirtualFiles(modifiedWithoutEditing, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        }
        if (switchedRoots != null && !switchedRoots.isEmpty()) {
            this.resetGrouping();
            this.buildSwitchedRoots(switchedRoots);
        }
        if (!switchedFiles.isEmpty()) {
            this.resetGrouping();
            this.buildSwitchedFiles(switchedFiles);
        }
        if (ignoredFiles != null && !ignoredFiles.isEmpty()) {
            this.resetGrouping();
            this.buildVirtualFiles(ignoredFiles, ChangesBrowserNode.IGNORED_FILES_TAG);
        }
        if (lockedFolders != null && !lockedFolders.isEmpty()) {
            this.resetGrouping();
            this.buildVirtualFiles(lockedFolders, ChangesBrowserNode.LOCKED_FOLDERS_TAG);
        }
        if (logicallyLockedFiles != null && !logicallyLockedFiles.isEmpty()) {
            this.resetGrouping();
            this.buildLogicallyLockedFiles(logicallyLockedFiles);
        }
        if (!locallyDeletedFiles.isEmpty()) {
            this.resetGrouping();
            ChangesBrowserNode locallyDeletedNode = ChangesBrowserNode.create(this.myProject, LOCALLY_DELETED_NODE);
            this.model.insertNodeInto(locallyDeletedNode, this.root, this.root.getChildCount());
            this.buildLocallyDeletedPaths(locallyDeletedFiles, locallyDeletedNode);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "set"));
        }
        return treeModelBuilder;
    }

    @NotNull
    public DefaultTreeModel build() {
        TreeModelBuilder.collapseDirectories(this.model, this.root);
        this.sortNodes();
        DefaultTreeModel defaultTreeModel = this.model;
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "build"));
        }
        return defaultTreeModel;
    }

    private void resetGrouping() {
        this.myFoldersCache = new HashMap();
        this.myPolicyInitialized = false;
    }

    @NotNull
    public DefaultTreeModel buildModel(@NotNull List<? extends ChangeList> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModel"));
        }
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
        for (ChangeList changeList : changeLists) {
            ArrayList<Change> changes = new ArrayList<Change>(changeList.getChanges());
            ChangesBrowserChangeListNode listNode = this.createChangeListNode(changeList, changes);
            this.model.insertNodeInto(listNode, this.root, 0);
            this.resetGrouping();
            ChangesGroupingPolicy policy = this.createGroupingPolicy();
            Collections.sort(changes, PATH_LENGTH_COMPARATOR);
            for (int i2 = 0; i2 < changes.size(); ++i2) {
                this.insertChangeNode(changes.get(i2), policy, listNode, this.createChangeListChild(revisionsCache, listNode, changes, i2));
            }
        }
        DefaultTreeModel defaultTreeModel = this.model;
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildModel"));
        }
        return defaultTreeModel;
    }

    protected ChangesBrowserChangeListNode createChangeListNode(@NotNull ChangeList list, List<Change> changes) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "createChangeListNode"));
        }
        ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
        return new ChangesBrowserChangeListNode(this.myProject, list, listRemoteState);
    }

    protected ChangesBrowserNode createChangeListChild(RemoteRevisionsCache revisionsCache, final ChangesBrowserChangeListNode node, List<Change> changes, final int i2) {
        return this.createChangeNode(changes.get(i2), new RemoteStatusChangeNodeDecorator(revisionsCache){
            @NotNull
            private final ChangeListRemoteState.Reporter myReporter;
            {
                super(remoteRevisionsCache);
                this.myReporter = new ChangeListRemoteState.Reporter(i2, node.getChangeListRemoteState());
            }

            @Override
            protected void reportState(boolean state) {
                this.myReporter.report(state);
            }

            @Override
            public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten1) {
            }
        });
    }

    protected ChangesBrowserNode createChangeNode(Change change, ChangeNodeDecorator decorator) {
        return new ChangesBrowserChangeNode(this.myProject, change, decorator);
    }

    @NotNull
    public TreeModelBuilder setChangeLists(@NotNull List<? extends ChangeList> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setChangeLists"));
        }
        this.buildModel(changeLists);
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "setChangeLists"));
        }
        return treeModelBuilder;
    }

    private void buildVirtualFiles(@NotNull List<VirtualFile> files, @Nullable Object tag) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildVirtualFiles"));
        }
        this.insertFilesIntoNode(files, this.createNode(tag));
    }

    @NotNull
    private ChangesBrowserNode createNode(@Nullable Object tag) {
        ChangesBrowserNode result2;
        if (tag != null) {
            result2 = ChangesBrowserNode.create(this.myProject, tag);
            this.model.insertNodeInto(result2, this.root, this.root.getChildCount());
        } else {
            result2 = this.root;
        }
        ChangesBrowserNode changesBrowserNode = result2;
        if (changesBrowserNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "createNode"));
        }
        return changesBrowserNode;
    }

    private void insertFilesIntoNode(@NotNull List<VirtualFile> files, @NotNull ChangesBrowserNode baseNode) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertFilesIntoNode"));
        }
        if (baseNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseNode", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertFilesIntoNode"));
        }
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        Collections.sort(files, VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : files) {
            this.insertChangeNode(file2, policy, baseNode, ChangesBrowserNode.create(this.myProject, file2));
        }
    }

    private void buildLocallyDeletedPaths(@NotNull Collection<LocallyDeletedChange> locallyDeletedChanges, @NotNull ChangesBrowserNode baseNode) {
        if (locallyDeletedChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locallyDeletedChanges", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildLocallyDeletedPaths"));
        }
        if (baseNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseNode", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildLocallyDeletedPaths"));
        }
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        for (LocallyDeletedChange change : locallyDeletedChanges) {
            StaticFilePath key2 = new StaticFilePath(false, change.getPresentableUrl(), change.getPath().getVirtualFile());
            ChangesBrowserNode oldNode = this.myFoldersCache.get(key2.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(change);
            ChangesBrowserNode parent = this.getParentNodeFor(key2, policy, baseNode);
            this.model.insertNodeInto(node, parent, parent.getChildCount());
            this.myFoldersCache.put(key2.getKey(), node);
        }
    }

    private void buildFilePaths(@NotNull Collection<FilePath> filePaths, @NotNull ChangesBrowserNode baseNode) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFilePaths"));
        }
        if (baseNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseNode", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildFilePaths"));
        }
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        for (FilePath file2 : filePaths) {
            assert (file2 != null);
            String path = file2.getPath();
            StaticFilePath pathKey = !FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path) ? new StaticFilePath(false, path, null) : new StaticFilePath(false, new File(file2.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), file2.getVirtualFile());
            ChangesBrowserNode oldNode = this.myFoldersCache.get(pathKey.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(this.myProject, file2);
            ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, policy, baseNode);
            this.model.insertNodeInto(node, parentNode, 0);
            this.myFoldersCache.put(pathKey.getKey(), node);
        }
    }

    private void buildSwitchedRoots(@NotNull Map<VirtualFile, String> switchedRoots) {
        if (switchedRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchedRoots", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildSwitchedRoots"));
        }
        ChangesBrowserNode rootsHeadNode = ChangesBrowserNode.create(this.myProject, ChangesBrowserNode.SWITCHED_ROOTS_TAG);
        rootsHeadNode.setAttributes(SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        this.model.insertNodeInto(rootsHeadNode, this.root, this.root.getChildCount());
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(switchedRoots.keySet());
        Collections.sort(files, VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile vf : files) {
            ChangesGroupingPolicy policy = this.createGroupingPolicy();
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            final String branchName = switchedRoots.get(vf);
            this.insertChangeNode(vf, policy, rootsHeadNode, this.createChangeNode(change, new ChangeNodeDecorator(){

                @Override
                public void decorate(Change change1, SimpleColoredComponent component, boolean isShowFlatten) {
                }

                @Override
                public List<Pair<String, ChangeNodeDecorator.Stress>> stressPartsOfFileName(Change change1, String parentPath) {
                    return null;
                }

                @Override
                public void preDecorate(Change change1, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                    renderer.append("[" + branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }));
        }
    }

    private void buildSwitchedFiles(@NotNull MultiMap<String, VirtualFile> switchedFiles) {
        if (switchedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchedFiles", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildSwitchedFiles"));
        }
        ChangesBrowserNode baseNode = ChangesBrowserNode.create(this.myProject, ChangesBrowserNode.SWITCHED_FILES_TAG);
        this.model.insertNodeInto(baseNode, this.root, this.root.getChildCount());
        for (String branchName : switchedFiles.keySet()) {
            ArrayList switchedFileList = new ArrayList(switchedFiles.get((Object)branchName));
            if (switchedFileList.size() <= 0) continue;
            ChangesBrowserNode branchNode = ChangesBrowserNode.create(this.myProject, branchName);
            this.model.insertNodeInto(branchNode, baseNode, baseNode.getChildCount());
            ChangesGroupingPolicy policy = this.createGroupingPolicy();
            Collections.sort(switchedFileList, VirtualFileHierarchicalComparator.getInstance());
            for (VirtualFile file2 : switchedFileList) {
                this.insertChangeNode(file2, policy, branchNode, ChangesBrowserNode.create(this.myProject, file2));
            }
        }
    }

    private void buildLogicallyLockedFiles(@NotNull Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        if (logicallyLockedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicallyLockedFiles", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "buildLogicallyLockedFiles"));
        }
        ChangesBrowserNode baseNode = this.createNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        ChangesGroupingPolicy policy = this.createGroupingPolicy();
        ArrayList<VirtualFile> keys = new ArrayList<VirtualFile>(logicallyLockedFiles.keySet());
        Collections.sort(keys, VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : keys) {
            LogicalLock lock = logicallyLockedFiles.get(file2);
            ChangesBrowserLogicallyLockedFile obj = new ChangesBrowserLogicallyLockedFile(this.myProject, file2, lock);
            this.insertChangeNode(obj, policy, baseNode, ChangesBrowserNode.create(this.myProject, obj));
        }
    }

    protected void insertChangeNode(@NotNull Object change, @Nullable ChangesGroupingPolicy policy, @NotNull ChangesBrowserNode listNode, @NotNull ChangesBrowserNode node) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        if (listNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listNode", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "insertChangeNode"));
        }
        StaticFilePath pathKey = TreeModelBuilder.getKey(change);
        ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, policy, listNode);
        this.model.insertNodeInto(node, parentNode, this.model.getChildCount(parentNode));
        if (pathKey.isDirectory()) {
            this.myFoldersCache.put(pathKey.getKey(), node);
        }
    }

    private void sortNodes() {
        TreeUtil.sort((DefaultTreeModel)this.model, BROWSER_NODE_COMPARATOR);
        this.model.nodeStructureChanged((TreeNode)this.model.getRoot());
    }

    private static void collapseDirectories(@NotNull DefaultTreeModel model, @NotNull ChangesBrowserNode node) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "collapseDirectories"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "collapseDirectories"));
        }
        if (node.getUserObject() instanceof FilePath && node.getChildCount() == 1) {
            ChangesBrowserNode child = (ChangesBrowserNode)node.getChildAt(0);
            if (child.getUserObject() instanceof FilePath && !child.isLeaf()) {
                ChangesBrowserNode parent = (ChangesBrowserNode)node.getParent();
                int idx = parent.getIndex(node);
                model.removeNodeFromParent(node);
                model.removeNodeFromParent(child);
                model.insertNodeInto(child, parent, idx);
                TreeModelBuilder.collapseDirectories(model, parent);
            }
        } else {
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                ChangesBrowserNode child = (ChangesBrowserNode)children2.nextElement();
                TreeModelBuilder.collapseDirectories(model, child);
            }
        }
    }

    @NotNull
    private static StaticFilePath getKey(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
        }
        if (o instanceof Change) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)((Change)o)));
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        if (o instanceof VirtualFile) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((VirtualFile)o);
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        if (o instanceof FilePath) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((FilePath)o);
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject());
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        if (o instanceof LocallyDeletedChange) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom(((LocallyDeletedChange)o).getPath());
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getKey"));
            }
            return staticFilePath;
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    private static StaticFilePath staticFrom(@NotNull FilePath fp) {
        if (fp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fp", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
        }
        String path = fp.getPath();
        if (fp.isNonLocal() && (!FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path))) {
            StaticFilePath staticFilePath = new StaticFilePath(fp.isDirectory(), fp.getIOFile().getPath().replace('\\', '/'), fp.getVirtualFile());
            if (staticFilePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
            }
            return staticFilePath;
        }
        StaticFilePath staticFilePath = new StaticFilePath(fp.isDirectory(), new File(fp.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), fp.getVirtualFile());
        if (staticFilePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
        }
        return staticFilePath;
    }

    @NotNull
    private static StaticFilePath staticFrom(@NotNull VirtualFile vf) {
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
        }
        StaticFilePath staticFilePath = new StaticFilePath(vf.isDirectory(), vf.getPath(), vf);
        if (staticFilePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "staticFrom"));
        }
        return staticFilePath;
    }

    @NotNull
    public static FilePath getPathForObject(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
        }
        if (o instanceof Change) {
            FilePath filePath = ChangesUtil.getFilePath((Change)((Change)o));
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        if (o instanceof VirtualFile) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)o));
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        if (o instanceof FilePath) {
            FilePath filePath = (FilePath)o;
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject()));
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        if (o instanceof LocallyDeletedChange) {
            FilePath filePath = ((LocallyDeletedChange)o).getPath();
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getPathForObject"));
            }
            return filePath;
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    private ChangesBrowserNode getParentNodeFor(@NotNull StaticFilePath nodePath, @Nullable ChangesGroupingPolicy policy, @NotNull ChangesBrowserNode rootNode) {
        ChangesBrowserNode nodeFromPolicy;
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        if (this.showFlatten) {
            ChangesBrowserNode changesBrowserNode = rootNode;
            if (changesBrowserNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
            }
            return changesBrowserNode;
        }
        if (policy != null && (nodeFromPolicy = policy.getParentNodeFor(nodePath, rootNode)) != null) {
            ChangesBrowserNode changesBrowserNode = nodeFromPolicy;
            if (changesBrowserNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
            }
            return changesBrowserNode;
        }
        StaticFilePath parentPath = nodePath.getParent();
        if (parentPath == null) {
            ChangesBrowserNode changesBrowserNode = rootNode;
            if (changesBrowserNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
            }
            return changesBrowserNode;
        }
        ChangesBrowserNode parentNode = this.myFoldersCache.get(parentPath.getKey());
        if (parentNode == null && (parentNode = this.createPathNode(parentPath)) != null) {
            ChangesBrowserNode grandPa = this.getParentNodeFor(parentPath, policy, rootNode);
            this.model.insertNodeInto(parentNode, grandPa, grandPa.getChildCount());
            this.myFoldersCache.put(parentPath.getKey(), parentNode);
        }
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)ObjectUtils.chooseNotNull((Object)parentNode, (Object)rootNode);
        if (changesBrowserNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "getParentNodeFor"));
        }
        return changesBrowserNode;
    }

    @Nullable
    protected ChangesBrowserNode createPathNode(StaticFilePath parentPath) {
        FilePath filePath = parentPath.getVf() == null ? VcsUtil.getFilePath((String)parentPath.getPath(), (boolean)true) : VcsUtil.getFilePath((VirtualFile)parentPath.getVf());
        return ChangesBrowserNode.create(this.myProject, filePath);
    }

    @NotNull
    public DefaultTreeModel clearAndGetModel() {
        this.root.removeAllChildren();
        this.model = new DefaultTreeModel(this.root);
        this.resetGrouping();
        DefaultTreeModel defaultTreeModel = this.model;
        if (defaultTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder", "clearAndGetModel"));
        }
        return defaultTreeModel;
    }

    public boolean isEmpty() {
        return this.model.getChildCount(this.root) == 0;
    }
}

