/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.codeInsight.completion.ComboEditorCompletionContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListRenderer;
import com.intellij.openapi.vcs.changes.ui.NewEditChangelistPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListChooserPanel
extends JPanel {
    private final MyEditorComboBox myExistingListsCombo;
    private final NewEditChangelistPanel myListPanel;
    private final NullableConsumer<String> myOkEnabledListener;
    private final Project myProject;
    private String myLastTypedDescription;
    private boolean myNewNameSuggested;

    public ChangeListChooserPanel(Project project2, @NotNull NullableConsumer<String> okEnabledListener) {
        if (okEnabledListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okEnabledListener", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myNewNameSuggested = false;
        this.myProject = project2;
        this.myExistingListsCombo = new MyEditorComboBox(project2);
        this.myExistingListsCombo.setEditable(true);
        this.myExistingListsCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList<? extends String> list, String value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$1", "customizeCellRenderer"));
                }
                if (value != null) {
                    String truncated;
                    FontMetrics fm;
                    int width;
                    String name = value;
                    LocalChangeList changeList = ChangeListManager.getInstance((Project)ChangeListChooserPanel.this.myProject).findChangeList(name);
                    int visibleWidth = this.getSize().width;
                    if (visibleWidth == 0) {
                        visibleWidth = 200;
                    }
                    if ((width = (fm = list.getFontMetrics(list.getFont())).stringWidth(name)) > visibleWidth && (truncated = CommittedChangeListRenderer.truncateDescription(name, fm, visibleWidth - fm.stringWidth(" ..") - 7)).length() > 5) {
                        name = truncated + " ..";
                    }
                    this.append(name, changeList != null && changeList.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.myListPanel = new NewEditChangelistPanel(this.myProject){

            @Override
            protected NewEditChangelistPanel.ComponentWithTextFieldWrapper createComponentWithTextField(Project project2) {
                return new NewEditChangelistPanel.ComponentWithTextFieldWrapper((Component)((Object)ChangeListChooserPanel.this.myExistingListsCombo)){

                    @Override
                    @NotNull
                    public EditorTextField getEditorTextField() {
                        EditorTextField editorTextField = ChangeListChooserPanel.this.myExistingListsCombo.getEditorTextField();
                        if (editorTextField == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$2$1", "getEditorTextField"));
                        }
                        return editorTextField;
                    }
                };
            }

            @Override
            protected void nameChanged(String errorMessage) {
                ApplicationManager.getApplication().invokeLater(() -> ChangeListChooserPanel.this.updateDescription(), ModalityState.current());
                ChangeListChooserPanel.this.myOkEnabledListener.consume((Object)errorMessage);
            }

            @Override
            public void init(LocalChangeList initial) {
                super.init(initial);
                this.myDescriptionTextArea.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        super.focusLost(e);
                        if (ChangeListChooserPanel.this.getExistingChangelistByName(ChangeListChooserPanel.this.myListPanel.getChangeListName()) == null) {
                            ChangeListChooserPanel.this.myLastTypedDescription = ChangeListChooserPanel.this.myListPanel.getDescription();
                        }
                    }
                });
            }

            @Override
            protected void nameChangedImpl(Project project2, LocalChangeList initial) {
                this.nameChanged(StringUtil.isEmptyOrSpaces((String)this.getChangeListName()) ? "Cannot create new changelist with empty name." : null);
            }
        };
        this.myOkEnabledListener = okEnabledListener;
        this.add((Component)this.myListPanel, "Center");
    }

    public void init() {
        this.myListPanel.init(null);
    }

    public void setChangeLists(Collection<? extends ChangeList> changeLists) {
        List changelistNames = ContainerUtil.map(changeLists, ChangeList::getName);
        Collections.sort(changelistNames);
        this.myExistingListsCombo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray((Collection)changelistNames)));
    }

    public void setSuggestedName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel", "setSuggestedName"));
        }
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        if (this.getExistingChangelistByName(name) != null) {
            this.myExistingListsCombo.setSelectedItem(name);
        } else {
            this.myNewNameSuggested = true;
            if (VcsConfiguration.getInstance((Project)this.myProject).PRESELECT_EXISTING_CHANGELIST) {
                this.myExistingListsCombo.insertItemAt(name, 0);
                this.selectActiveChangeListIfExist();
            } else {
                this.myListPanel.setChangeListName(name);
            }
        }
        this.updateDescription();
    }

    private void selectActiveChangeListIfExist() {
        this.myExistingListsCombo.setSelectedItem(ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getName());
    }

    public void updateEnabled() {
        if (this.myProject != null) {
            this.myListPanel.nameChangedImpl(this.myProject, null);
        }
    }

    @Nullable
    public LocalChangeList getSelectedList(Project project2) {
        String changeListName;
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        LocalChangeList localChangeList = manager.findChangeList(changeListName = this.myListPanel.getChangeListName());
        if (localChangeList == null) {
            localChangeList = manager.addChangeList(changeListName, this.myListPanel.getDescription());
            this.myListPanel.changelistCreatedOrChanged(localChangeList);
        } else {
            localChangeList.setComment(this.myListPanel.getDescription());
        }
        this.rememberSettings(project2, localChangeList.isDefault(), this.myListPanel.getMakeActiveCheckBox().isSelected());
        if (this.myListPanel.getMakeActiveCheckBox().isSelected()) {
            manager.setDefaultChangeList(localChangeList);
        }
        return localChangeList;
    }

    private void rememberSettings(@NotNull Project project2, boolean activeListSelected, boolean setActive) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel", "rememberSettings"));
        }
        if (this.myNewNameSuggested) {
            VcsConfiguration.getInstance((Project)project2).PRESELECT_EXISTING_CHANGELIST = activeListSelected;
        }
        VcsConfiguration.getInstance((Project)project2).MAKE_NEW_CHANGELIST_ACTIVE = setActive;
    }

    public void setDefaultSelection(ChangeList defaultSelection) {
        if (defaultSelection == null) {
            this.selectActiveChangeListIfExist();
        } else {
            this.myExistingListsCombo.setSelectedItem(defaultSelection.getName());
        }
        this.updateDescription();
        this.updateEnabled();
    }

    private void updateDescription() {
        String newText;
        LocalChangeList list = this.getExistingChangelistByName(this.myListPanel.getChangeListName());
        String string = newText = list != null ? list.getComment() : this.myLastTypedDescription;
        if (!StringUtil.equals((CharSequence)this.myListPanel.getDescription(), (CharSequence)newText)) {
            this.myListPanel.setDescription(newText);
        }
    }

    private LocalChangeList getExistingChangelistByName(@NotNull String changeListName) {
        if (changeListName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListName", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel", "getExistingChangelistByName"));
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
        return manager.findChangeList(changeListName);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExistingListsCombo;
    }

    private static class MyEditorComboBox
    extends ComboBox<String> {
        private static final int PREF_WIDTH = 200;

        public MyEditorComboBox(Project project2) {
            super(200);
            this.setEditor(new StringComboboxEditor(project2, (FileType)FileTypes.PLAIN_TEXT, this){

                @Override
                protected void onEditorCreate(EditorEx editor) {
                    super.onEditorCreate(editor);
                    this.getDocument().putUserData(ComboEditorCompletionContributor.CONTINUE_RUN_COMPLETION, (Object)true);
                }
            });
        }

        @NotNull
        private EditorTextField getEditorTextField() {
            EditorTextField editorTextField = (EditorTextField)ObjectUtils.assertNotNull((Object)((EditorTextField)((Object)this.getEditor().getEditorComponent())));
            if (editorTextField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangeListChooserPanel$MyEditorComboBox", "getEditorTextField"));
            }
            return editorTextField;
        }
    }
}

