/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.MoveChangesDialog;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesCommitExecutor;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;

public enum ChangelistConflictResolution {
    SHELVE{

        @Override
        public boolean resolveConflict(Project project2, Collection<Change> changes, VirtualFile selected) {
            LocalChangeList changeList = ChangelistConflictResolution.getManager(project2).getChangeList(changes.iterator().next());
            return CommitChangeListDialog.commitChanges(project2, changes, changeList, (CommitExecutor)new ShelveChangesCommitExecutor(project2), null);
        }
    }
    ,
    MOVE{

        @Override
        public boolean resolveConflict(Project project2, Collection<Change> changes, VirtualFile selected) {
            ChangeListManagerImpl manager = ChangelistConflictResolution.getManager(project2);
            HashSet<ChangeList> changeLists = new HashSet<ChangeList>();
            for (Change change : changes) {
                LocalChangeList list = manager.getChangeList(change);
                if (list == null) continue;
                changeLists.add((ChangeList)list);
            }
            if (changeLists.isEmpty()) {
                Messages.showInfoMessage((Project)project2, (String)"The conflict seems to be resolved", (String)"No Conflict Found");
                return true;
            }
            MoveChangesDialog dialog2 = new MoveChangesDialog(project2, changes, changeLists, selected);
            if (dialog2.showAndGet()) {
                manager.moveChangesTo(manager.getDefaultChangeList(), dialog2.getIncludedChanges().toArray(new Change[changes.size()]));
                return true;
            }
            return false;
        }
    }
    ,
    SWITCH{

        @Override
        public boolean resolveConflict(Project project2, Collection<Change> changes, VirtualFile selected) {
            LocalChangeList changeList = ChangelistConflictResolution.getManager(project2).getChangeList(changes.iterator().next());
            assert (changeList != null);
            ChangelistConflictResolution.getManager(project2).setDefaultChangeList(changeList);
            return true;
        }
    }
    ,
    IGNORE{

        @Override
        public boolean resolveConflict(Project project2, Collection<Change> changes, VirtualFile selected) {
            ChangeListManagerImpl manager = ChangelistConflictResolution.getManager(project2);
            for (Change change : changes) {
                VirtualFile file2 = change.getVirtualFile();
                if (file2 == null) continue;
                manager.getConflictTracker().ignoreConflict(file2, true);
            }
            return true;
        }
    };


    public abstract boolean resolveConflict(Project var1, Collection<Change> var2, VirtualFile var3);

    private static ChangeListManagerImpl getManager(Project project2) {
        return (ChangeListManagerImpl)ChangeListManager.getInstance((Project)project2);
    }
}

