/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVcsAction
extends DumbAwareAction {
    public static Collection<AbstractVcs> getActiveVcses(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/actions/AbstractVcsAction", "getActiveVcses"));
        }
        Project project2 = dataContext.getProject();
        return project2 != null ? ContainerUtil.newHashSet((Object[])ProjectLevelVcsManager.getInstance((Project)project2).getAllActiveVcss()) : Collections.emptySet();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AbstractVcsAction", "update"));
        }
        this.performUpdate(e.getPresentation(), VcsContextWrapper.createInstanceOn(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AbstractVcsAction", "actionPerformed"));
        }
        this.actionPerformed(VcsContextWrapper.createCachedInstanceOn(e));
    }

    protected abstract void update(@NotNull VcsContext var1, @NotNull Presentation var2);

    protected abstract void actionPerformed(@NotNull VcsContext var1);

    @Deprecated
    protected boolean forceSyncUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AbstractVcsAction", "forceSyncUpdate"));
        }
        return true;
    }

    @Deprecated
    protected void performUpdate(@NotNull Presentation presentation, @NotNull VcsContext vcsContext) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/AbstractVcsAction", "performUpdate"));
        }
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "com/intellij/openapi/vcs/actions/AbstractVcsAction", "performUpdate"));
        }
        this.update(vcsContext, presentation);
    }
}

