/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004\u001a\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004\u001a\u0015\u0010\u000f\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00102\u0006\u0010\f\u001a\u00020\u0004\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parentSystemIndependentPath", "", "Ljava/io/File;", "getParentSystemIndependentPath", "(Ljava/io/File;)Ljava/lang/String;", "systemIndependentPath", "getSystemIndependentPath", "endsWithName", "", "path", "name", "endsWithSlash", "getParentPath", "Lorg/jetbrains/annotations/Nullable;", "setOwnerPermissions", "", "Ljava/nio/file/Path;", "platform-impl"})
public final class FileUtilKt {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.io.FileUtil");

    @NotNull
    public static final String getSystemIndependentPath(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.replace$default((String)$receiver.getPath(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getParentSystemIndependentPath(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.replace$default((String)$receiver.getParent(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @Nullable
    public static final String getParentPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return StringUtil.nullize((String)PathUtilRt.getParentPath((String)path));
    }

    public static final boolean endsWithSlash(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return Intrinsics.areEqual((Object)StringsKt.getOrNull((CharSequence)path, (int)(path.length() - 1)), (Object)Character.valueOf('/'));
    }

    public static final boolean endsWithName(@NotNull String path, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return StringsKt.endsWith$default((String)path, (String)name, (boolean)false, (int)2, null) && (path.length() == name.length() || Intrinsics.areEqual((Object)StringsKt.getOrNull((CharSequence)path, (int)(path.length() - name.length() - 1)), (Object)Character.valueOf('/')));
    }

    public static final void setOwnerPermissions(@NotNull Path $receiver) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView($receiver, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixFileAttributeView == null) break block2;
            PosixFileAttributeView posixFileAttributeView2 = posixFileAttributeView;
            PosixFileAttributeView it = posixFileAttributeView2;
            try {
                it.setPermissions(SetsKt.setOf((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE}));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }
}

