/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Restarter;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\b\u0010\f\u001a\u00020\nH\u0002J3\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInstaller;", "", "()V", "patchesUrl", "", "getPatchesUrl", "()Ljava/lang/String;", "cleanupPatch", "", "findLib", "Ljava/io/File;", "libName", "getTempDir", "installPlatformUpdate", "", "patch", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "toBuild", "Lcom/intellij/openapi/util/BuildNumber;", "forceHttps", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/updateSettings/impl/PatchInfo;Lcom/intellij/openapi/util/BuildNumber;ZLcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "installPluginUpdates", "downloaders", "", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "preparePatchCommand", "patchFile", "(Ljava/io/File;)[Ljava/lang/String;", "platform-impl"})
public final class UpdateInstaller {
    public static final UpdateInstaller INSTANCE;

    private final String getPatchesUrl() {
        String string = System.getProperty("idea.patches.url");
        if (string == null) {
            String string2 = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getPatchesUrl();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ApplicationInfoEx.getIns\u2026x().updateUrls.patchesUrl");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String[] installPlatformUpdate(@NotNull PatchInfo patch, @NotNull BuildNumber toBuild, boolean forceHttps, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)patch, (String)"patch");
        Intrinsics.checkParameterIsNotNull((Object)toBuild, (String)"toBuild");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        indicator.setText(IdeBundle.message((String)"update.downloading.patch.progress", (Object[])new Object[0]));
        String product = ApplicationInfo.getInstance().getBuild().getProductCode();
        String from = patch.getFromBuild().asStringWithoutProductCode();
        String to = toBuild.asStringWithoutProductCode();
        String jdk2 = StringsKt.lastIndexOf$default((CharSequence)System.getProperty("idea.java.redist", ""), (String)"NoJavaDistribution", (int)0, (boolean)false, (int)6, null) >= 0 ? "-no-jdk" : "";
        String patchName = product + "-" + from + "-" + to + "-patch" + jdk2 + "-" + patch.getOsSuffix() + ".jar";
        String baseUrl = INSTANCE.getPatchesUrl();
        URL url = new URL(new URL(StringsKt.endsWith$default((CharSequence)baseUrl, (char)'/', (boolean)false, (int)2, null) ? baseUrl : baseUrl + '/'), patchName);
        File patchFile = new File(INSTANCE.getTempDir(), "patch.jar");
        HttpRequests.request((String)url.toString()).gzip(false).forceHttps(forceHttps).saveToFile(patchFile, indicator);
        indicator.setText(IdeBundle.message((String)"update.preparing.patch.progress", (Object[])new Object[0]));
        return INSTANCE.preparePatchCommand(patchFile);
    }

    @JvmStatic
    public static final boolean installPluginUpdates(@NotNull Collection<? extends PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull(downloaders, (String)"downloaders");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        indicator.setText(IdeBundle.message((String)"progress.downloading.plugins", (Object[])new Object[0]));
        boolean installed = false;
        Set<String> disabledToUpdate = UpdateChecker.getDisabledToUpdatePlugins();
        for (PluginDownloader pluginDownloader : downloaders) {
            try {
                IdeaPluginDescriptor descriptor;
                if (!(disabledToUpdate.contains(pluginDownloader.getPluginId()) ^ true) || !pluginDownloader.prepareToInstall(indicator) || (descriptor = pluginDownloader.getDescriptor()) == null) continue;
                pluginDownloader.install();
                installed = true;
            }
            catch (Exception e) {
                Logger.getInstance(UpdateChecker.class).info((Throwable)e);
            }
        }
        return installed;
    }

    @JvmStatic
    public static final void cleanupPatch() {
        File tempDir = INSTANCE.getTempDir();
        if (tempDir.exists()) {
            FileUtil.delete((File)tempDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String[] preparePatchCommand(File patchFile) {
        void elements$iv;
        Object object;
        File launcher;
        File log4j = this.findLib("log4j.jar");
        File jna = this.findLib("jna.jar");
        File jnaUtils = this.findLib("jna-platform.jar");
        File tempDir = this.getTempDir();
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw (Throwable)new IOException("Cannot create temp directory: " + tempDir);
        }
        File log4jCopy = FilesKt.copyTo$default((File)log4j, (File)new File(tempDir, log4j.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaCopy = FilesKt.copyTo$default((File)jna, (File)new File(tempDir, jna.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaUtilsCopy = FilesKt.copyTo$default((File)jnaUtils, (File)new File(tempDir, jnaUtils.getName()), (boolean)true, (int)0, (int)4, null);
        String java = System.getProperty("java.home");
        if (FileUtil.isAncestor((String)PathManager.getHomePath(), (String)java, (boolean)true)) {
            File javaCopy = new File(tempDir, "jre");
            FileUtil.copyDir((File)new File(java), (File)javaCopy);
            java = javaCopy.getPath();
        }
        ArrayList args = CollectionsKt.arrayListOf((Object[])new String[0]);
        if (SystemInfo.isWindows && (launcher = new File(PathManager.getBinPath(), "VistaLauncher.exe")).canExecute()) {
            object = args;
            String string = Restarter.createTempExecutable(launcher).getPath();
            object.add(string);
        }
        Collection collection = args;
        object = new File(java, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java").getPath();
        collection.add(object);
        collection = args;
        object = "-Xmx750m";
        collection.add(object);
        collection = args;
        object = "-cp";
        collection.add(object);
        collection = args;
        object = new String[]{patchFile.getPath(), log4jCopy.getPath(), jnaCopy.getPath(), jnaUtilsCopy.getPath()};
        Object[] objectArray = (Object[])elements$iv;
        CharSequence charSequence = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"File.pathSeparator");
        object = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)charSequence, null, null, (int)0, null, null, (int)62, null);
        collection.add(object);
        collection = args;
        object = "-Djna.nosys=true";
        collection.add(object);
        collection = args;
        object = "-Djna.boot.library.path=";
        collection.add(object);
        collection = args;
        object = "-Djna.debug_load=true";
        collection.add(object);
        collection = args;
        object = "-Djna.debug_load.jna=true";
        collection.add(object);
        collection = args;
        object = "-Djava.io.tmpdir=" + tempDir.getPath();
        collection.add(object);
        collection = args;
        object = "-Didea.updater.log=" + PathManager.getLogPath();
        collection.add(object);
        collection = args;
        object = "-Dswing.defaultlaf=" + UIManager.getSystemLookAndFeelClassName();
        collection.add(object);
        collection = args;
        object = "com.intellij.updater.Runner";
        collection.add(object);
        collection = args;
        object = "install";
        collection.add(object);
        collection = args;
        object = PathManager.getHomePath();
        collection.add(object);
        String[] stringArray = ArrayUtil.toStringArray((Collection)args);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"ArrayUtil.toStringArray(args)");
        return stringArray;
    }

    private final File findLib(String libName) {
        File libFile = new File(PathManager.getLibPath(), libName);
        if (!libFile.exists()) {
            throw (Throwable)new IOException("Missing: " + libFile);
        }
        return libFile;
    }

    private final File getTempDir() {
        return new File(PathManager.getTempPath(), "patch-update");
    }

    private UpdateInstaller() {
        INSTANCE = this;
    }

    static {
        new UpdateInstaller();
    }
}

