/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Couple;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class KeyCodeTypeCommand
extends AlphaNumericTypeCommand {
    public static final String PREFIX = "%type";
    public static final String CODE_DELIMITER = ";";
    public static final String MODIFIER_DELIMITER = ":";

    public KeyCodeTypeCommand(String text, int line) {
        super(text, line);
    }

    @Override
    public ActionCallback _execute(PlaybackContext context) {
        String text = this.getText().substring(PREFIX.length()).trim();
        int textDelim = text.indexOf(" ");
        String codes = textDelim >= 0 ? text.substring(0, textDelim) : text;
        String unicode = codes.length() + 1 < text.length() ? text.substring(textDelim + 1) : "";
        ActionCallback result2 = new ActionCallback();
        KeyCodeTypeCommand.inWriteSafeContext(() -> {
            TypingTarget typingTarget = KeyCodeTypeCommand.findTarget(context);
            if (typingTarget != null) {
                typingTarget.type(unicode).doWhenDone(result2.createSetDoneRunnable()).doWhenRejected(() -> this.typeCodes(context, context.getRobot(), codes).notify(result2));
            } else {
                this.typeCodes(context, context.getRobot(), codes).notify(result2);
            }
        });
        return result2;
    }

    private ActionCallback typeCodes(PlaybackContext context, Robot robot, String codes) {
        ActionCallback result2 = new ActionCallback();
        Runnable runnable2 = () -> {
            String[] pairs;
            for (String eachPair : pairs = codes.split(CODE_DELIMITER)) {
                try {
                    String[] splits = eachPair.split(MODIFIER_DELIMITER);
                    Integer code2 = Integer.valueOf(splits[0]);
                    Integer modifier = Integer.valueOf(splits[1]);
                    this.type(robot, code2, modifier);
                }
                catch (NumberFormatException e) {
                    this.dumpError(context, "Invalid code: " + eachPair);
                    result2.setRejected();
                    return;
                }
            }
            result2.setDone();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        } else {
            runnable2.run();
        }
        return result2;
    }

    public static Couple<List<Integer>> parseKeyCodes(String keyCodesText) {
        ArrayList<Integer> codes = new ArrayList<Integer>();
        ArrayList<Integer> modifiers = new ArrayList<Integer>();
        if (keyCodesText != null) {
            String[] pairs;
            for (String each : pairs = keyCodesText.split(CODE_DELIMITER)) {
                String[] strings = each.split(MODIFIER_DELIMITER);
                if (strings.length != 2) continue;
                codes.add(Integer.valueOf(strings[0]));
                modifiers.add(Integer.valueOf(strings[1]));
            }
        }
        return Couple.of(codes, modifiers);
    }

    public static String unparseKeyCodes(Couple<List<Integer>> pairs) {
        StringBuilder result2 = new StringBuilder();
        List codes = (List)pairs.getFirst();
        List modifiers = (List)pairs.getSecond();
        for (int i2 = 0; i2 < codes.size(); ++i2) {
            Integer each = (Integer)codes.get(i2);
            result2.append(each.toString());
            result2.append(MODIFIER_DELIMITER);
            result2.append(modifiers.get(i2));
            if (i2 >= codes.size() - 1) continue;
            result2.append(CODE_DELIMITER);
        }
        return result2.toString();
    }
}

