/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.impl.AbstractDialog;
import com.intellij.openapi.ui.impl.FocusTrackbackProvider;
import com.intellij.openapi.ui.impl.HeadlessDialog;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.Splash;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.OwnerOptional;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public class DialogWrapperPeerImpl
extends DialogWrapperPeer
implements FocusTrackbackProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.DialogWrapper");
    private final DialogWrapper myWrapper;
    private AbstractDialog myDialog;
    private boolean myCanBeParent;
    private WindowManagerEx myWindowManager;
    private final List<Runnable> myDisposeActions;
    private Project myProject;
    private final ActionCallback myWindowFocusedCallback;
    private final ActionCallback myTypeAheadDone;
    private ActionCallback myTypeAheadCallback;

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper, @Nullable Project project2, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "<init>"));
        }
        if (ideModalityType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModalityType", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "<init>"));
        }
        this.myCanBeParent = true;
        this.myDisposeActions = new ArrayList<Runnable>();
        this.myWindowFocusedCallback = new ActionCallback("DialogFocusedCallback");
        this.myTypeAheadDone = new ActionCallback("DialogTypeAheadDone");
        this.myWrapper = wrapper;
        this.myTypeAheadCallback = this.myWrapper.isTypeAheadEnabled() ? new ActionCallback() : null;
        this.myWindowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.hasComponent(WindowManager.class)) {
            this.myWindowManager = (WindowManagerEx)WindowManager.getInstance();
        }
        Window window = null;
        if (this.myWindowManager != null) {
            Window focusedWindow;
            if (project2 == null) {
                project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            }
            this.myProject = project2;
            window = this.myWindowManager.suggestParentWindow(project2);
            if (window == null && (focusedWindow = this.myWindowManager.getMostRecentFocusedWindow()) instanceof IdeFrameImpl) {
                window = focusedWindow;
            }
            if (window == null) {
                IdeFrame[] frames;
                for (IdeFrame frame : frames = this.myWindowManager.getAllProjectFrames()) {
                    if (!(frame instanceof IdeFrameImpl) || !((IdeFrameImpl)frame).isActive()) continue;
                    window = (IdeFrameImpl)frame;
                    break;
                }
            }
        }
        Window owner = window != null ? window : (!this.isHeadless() ? JOptionPane.getRootFrame() : null);
        this.createDialog(owner, canBeParent, ideModalityType);
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper, @Nullable Project project2, boolean canBeParent) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "<init>"));
        }
        this(wrapper, project2, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper, boolean canBeParent) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "<init>"));
        }
        this(wrapper, (Project)null, canBeParent);
    }

    public boolean isHeadless() {
        return DialogWrapperPeerImpl.isHeadlessEnv();
    }

    public Object[] getCurrentModalEntities() {
        return LaterInvocator.getCurrentModalEntities();
    }

    public static boolean isHeadlessEnv() {
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return GraphicsEnvironment.isHeadless();
        }
        return app.isUnitTestMode() || app.isHeadlessEnvironment();
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper, @NotNull Component parent, boolean canBeParent) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "<init>"));
        }
        this.myCanBeParent = true;
        this.myDisposeActions = new ArrayList<Runnable>();
        this.myWindowFocusedCallback = new ActionCallback("DialogFocusedCallback");
        this.myTypeAheadDone = new ActionCallback("DialogTypeAheadDone");
        this.myWrapper = wrapper;
        this.myWindowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.hasComponent(WindowManager.class)) {
            this.myWindowManager = (WindowManagerEx)WindowManager.getInstance();
        }
        OwnerOptional.fromComponent(parent).ifWindow((Consumer<Window>)((Consumer)window -> this.createDialog((Window)window, canBeParent)));
    }

    public DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper, Window owner, boolean canBeParent, DialogWrapper.IdeModalityType ideModalityType) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "<init>"));
        }
        this.myCanBeParent = true;
        this.myDisposeActions = new ArrayList<Runnable>();
        this.myWindowFocusedCallback = new ActionCallback("DialogFocusedCallback");
        this.myTypeAheadDone = new ActionCallback("DialogTypeAheadDone");
        this.myWrapper = wrapper;
        this.myWindowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.hasComponent(WindowManager.class)) {
            this.myWindowManager = (WindowManagerEx)WindowManager.getInstance();
        }
        this.createDialog(owner, canBeParent);
        if (!this.isHeadless()) {
            Dialog.ModalityType modalityType = DialogWrapper.IdeModalityType.IDE.toAwtModality();
            if (Registry.is((String)"ide.perProjectModality")) {
                modalityType = ideModalityType.toAwtModality();
            }
            this.myDialog.setModalityType(modalityType);
        }
    }

    @Deprecated
    public DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper, boolean canBeParent, boolean applicationModalIfPossible) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "<init>"));
        }
        this(wrapper, null, canBeParent, applicationModalIfPossible);
    }

    @Deprecated
    public DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper, Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "<init>"));
        }
        this(wrapper, owner, canBeParent, applicationModalIfPossible ? DialogWrapper.IdeModalityType.IDE : DialogWrapper.IdeModalityType.PROJECT);
    }

    public void setUndecorated(boolean undecorated) {
        this.myDialog.setUndecorated(undecorated);
    }

    public void addMouseListener(MouseListener listener2) {
        this.myDialog.addMouseListener(listener2);
    }

    public void addMouseListener(MouseMotionListener listener2) {
        this.myDialog.addMouseMotionListener(listener2);
    }

    public void addKeyListener(KeyListener listener2) {
        this.myDialog.addKeyListener(listener2);
    }

    private void createDialog(@Nullable Window owner, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModalityType", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "createDialog"));
        }
        if (this.isHeadless()) {
            this.myDialog = new HeadlessDialog(this.myWrapper);
        } else {
            this.myDialog = new MyDialog(owner, this.myWrapper, this.myProject, this.myWindowFocusedCallback, this.myTypeAheadDone, this.myTypeAheadCallback);
            UIUtil.suppressFocusStealing((Window)this.getWindow());
            this.myDialog.setModalityType(ideModalityType.toAwtModality());
            this.myCanBeParent = canBeParent;
        }
    }

    private void createDialog(@Nullable Window owner, boolean canBeParent) {
        this.createDialog(owner, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    public void toFront() {
        this.myDialog.toFront();
    }

    public void toBack() {
        this.myDialog.toBack();
    }

    protected void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        for (Runnable runnable2 : this.myDisposeActions) {
            runnable2.run();
        }
        this.myDisposeActions.clear();
        Runnable disposer = () -> {
            Disposer.dispose((Disposable)this.myDialog);
            this.myProject = null;
            SwingUtilities.invokeLater(() -> {
                if (this.myDialog != null && this.myDialog.getRootPane() != null) {
                    this.myDialog.remove(this.myDialog.getRootPane());
                }
            });
        };
        UIUtil.invokeLaterIfNeeded((Runnable)disposer);
    }

    private boolean isProgressDialog() {
        return this.myWrapper.isModalProgress();
    }

    @Nullable
    public Container getContentPane() {
        return this.getRootPane() != null ? this.myDialog.getContentPane() : null;
    }

    public void validate() {
        this.myDialog.validate();
    }

    public void repaint() {
        this.myDialog.repaint();
    }

    public Window getOwner() {
        return this.myDialog.getOwner();
    }

    public Window getWindow() {
        return this.myDialog.getWindow();
    }

    public JRootPane getRootPane() {
        return this.myDialog.getRootPane();
    }

    public Dimension getSize() {
        return this.myDialog.getSize();
    }

    public String getTitle() {
        return this.myDialog.getTitle();
    }

    public void pack() {
        this.myDialog.pack();
    }

    public void setAppIcons() {
        AppUIUtil.updateWindowIcon(this.getWindow());
    }

    public Dimension getPreferredSize() {
        return this.myDialog.getPreferredSize();
    }

    public void setModal(boolean modal) {
        this.myDialog.setModal(modal);
    }

    public boolean isModal() {
        return this.myDialog.isModal();
    }

    public boolean isVisible() {
        return this.myDialog.isVisible();
    }

    public boolean isShowing() {
        return this.myDialog.isShowing();
    }

    public void setSize(int width, int height) {
        this.myDialog.setSize(width, height);
    }

    public void setTitle(String title) {
        this.myDialog.setTitle(title);
    }

    public void isResizable() {
        this.myDialog.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myDialog.setResizable(resizable);
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myDialog.getLocation();
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "getLocation"));
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl", "setLocation"));
        }
        this.myDialog.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myDialog.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionCallback show() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        if (this.myTypeAheadCallback != null) {
            IdeFocusManager.getInstance((Project)this.myProject).typeAheadUntil(this.myTypeAheadCallback);
        }
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        ActionCallback result2 = new ActionCallback();
        AnCancelAction anCancelAction = new AnCancelAction();
        JRootPane rootPane = this.getRootPane();
        anCancelAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, rootPane);
        this.myDisposeActions.add(() -> anCancelAction.unregisterCustomShortcutSet(rootPane));
        if (!this.myCanBeParent && this.myWindowManager != null) {
            this.myWindowManager.doNotSuggestAsParent(this.myDialog.getWindow());
        }
        CommandProcessorEx commandProcessor = ApplicationManager.getApplication() != null ? (CommandProcessorEx)CommandProcessor.getInstance() : null;
        boolean appStarted = commandProcessor != null;
        boolean changeModalityState = appStarted && this.myDialog.isModal() && !this.isProgressDialog();
        Project project2 = this.myProject;
        if (changeModalityState) {
            commandProcessor.enterModal();
            if (Registry.is((String)"ide.perProjectModality")) {
                LaterInvocator.enterModal(project2, this.myDialog.getWindow());
            } else {
                LaterInvocator.enterModal(this.myDialog);
            }
        }
        if (appStarted) {
            this.hidePopupsIfNeeded();
        }
        try {
            this.myDialog.show();
        }
        finally {
            if (changeModalityState) {
                commandProcessor.leaveModal();
                if (Registry.is((String)"ide.perProjectModality")) {
                    LaterInvocator.leaveModal(project2, this.myDialog.getWindow());
                } else {
                    LaterInvocator.leaveModal(this.myDialog);
                }
            }
            this.myDialog.getFocusManager().doWhenFocusSettlesDown(result2.createSetDoneRunnable());
        }
        return result2;
    }

    private void hidePopupsIfNeeded() {
        if (!SystemInfo.isMac) {
            return;
        }
        StackingPopupDispatcher.getInstance().hidePersistentPopups();
        this.myDisposeActions.add(() -> StackingPopupDispatcher.getInstance().restorePersistentPopups());
    }

    @Override
    public FocusTrackback getFocusTrackback() {
        return this.myDialog.getFocusTrackback();
    }

    private static void setupSelectionOnPreferredComponent(JComponent component) {
        if (component instanceof JTextField) {
            JTextField field = (JTextField)component;
            String text = field.getText();
            if (text != null && field.getClientProperty(HAVE_INITIAL_SELECTION) == null) {
                field.setSelectionStart(0);
                field.setSelectionEnd(text.length());
            }
        } else if (component instanceof JComboBox) {
            JComboBox combobox = (JComboBox)component;
            combobox.getEditor().selectAll();
        }
    }

    public void setContentPane(JComponent content) {
        this.myDialog.setContentPane(content);
    }

    public void centerInParent() {
        this.myDialog.centerInParent();
    }

    public void setAutoRequestFocus(boolean b) {
        UIUtil.setAutoRequestFocus((Window)((JDialog)((Object)this.myDialog)), (boolean)b);
    }

    private static class MyDialog
    extends JDialog
    implements DialogWrapperDialog,
    DataProvider,
    FocusTrackback.Provider,
    Queryable,
    AbstractDialog {
        private final WeakReference<DialogWrapper> myDialogWrapper;
        private Dimension myInitialSize;
        private String myDimensionServiceKey;
        private boolean myOpened;
        private boolean myActivated;
        private FocusTrackback myFocusTrackback;
        private MyWindowListener myWindowListener;
        private final WeakReference<Project> myProject;
        private final ActionCallback myFocusedCallback;
        private final ActionCallback myTypeAheadDone;
        private final ActionCallback myTypeAheadCallback;

        public MyDialog(Window owner, DialogWrapper dialogWrapper, Project project2, @NotNull ActionCallback focused, @NotNull ActionCallback typeAheadDone, ActionCallback typeAheadCallback) {
            if (focused == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focused", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog", "<init>"));
            }
            if (typeAheadDone == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeAheadDone", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog", "<init>"));
            }
            super(owner);
            this.myOpened = false;
            this.myActivated = false;
            this.myDialogWrapper = new WeakReference<DialogWrapper>(dialogWrapper);
            this.myProject = project2 != null ? new WeakReference<Project>(project2) : null;
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt(){

                @Override
                protected boolean accept(Component aComponent) {
                    if (UIUtil.isFocusProxy((Component)aComponent)) {
                        return false;
                    }
                    return super.accept(aComponent);
                }
            });
            this.myFocusedCallback = focused;
            this.myTypeAheadDone = typeAheadDone;
            this.myTypeAheadCallback = typeAheadCallback;
            long typeAhead = this.getDialogWrapper().getTypeAheadTimeoutMs();
            if (typeAhead <= 0L) {
                this.myTypeAheadDone.setDone();
            }
            this.setDefaultCloseOperation(0);
            this.myWindowListener = new MyWindowListener();
            this.addWindowListener(this.myWindowListener);
        }

        @Override
        public JDialog getWindow() {
            return this;
        }

        public void putInfo(@NotNull Map<String, String> info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog", "putInfo"));
            }
            info.put("dialog", this.getTitle());
        }

        @Override
        public FocusTrackback getFocusTrackback() {
            return this.myFocusTrackback;
        }

        public DialogWrapper getDialogWrapper() {
            return (DialogWrapper)this.myDialogWrapper.get();
        }

        @Override
        public void centerInParent() {
            this.setLocationRelativeTo(this.getOwner());
        }

        public Object getData(String dataId) {
            DialogWrapper wrapper = (DialogWrapper)this.myDialogWrapper.get();
            if (wrapper instanceof DataProvider) {
                return ((DataProvider)wrapper).getData(dataId);
            }
            if (wrapper instanceof TypeSafeDataProvider) {
                TypeSafeDataProviderAdapter adapter = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)wrapper);
                return adapter.getData(dataId);
            }
            return null;
        }

        @Override
        public void setSize(int width, int height) {
            this._setSizeForLocation(width, height, null);
        }

        private void _setSizeForLocation(int width, int height, @Nullable Point initial) {
            Point location = initial != null ? initial : this.getLocation();
            Rectangle rect = new Rectangle(location.x, location.y, width, height);
            ScreenUtil.fitToScreen((Rectangle)rect);
            if (initial != null || location.x != rect.x || location.y != rect.y) {
                this.setLocation(rect.x, rect.y);
            }
            super.setSize(rect.width, rect.height);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            Rectangle rect = new Rectangle(x, y, width, height);
            ScreenUtil.fitToScreen((Rectangle)rect);
            super.setBounds(rect.x, rect.y, rect.width, rect.height);
        }

        @Override
        public void setBounds(Rectangle r) {
            ScreenUtil.fitToScreen((Rectangle)r);
            super.setBounds(r);
        }

        @Override
        @NotNull
        protected JRootPane createRootPane() {
            DialogRootPane dialogRootPane = new DialogRootPane();
            if (dialogRootPane == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog", "createRootPane"));
            }
            return dialogRootPane;
        }

        @Override
        public void show() {
            IdeEventQueue queue;
            this.myFocusTrackback = new FocusTrackback((Object)this.getDialogWrapper(), this.getParent(), true);
            DialogWrapper dialogWrapper = this.getDialogWrapper();
            boolean isAutoAdjustable = dialogWrapper.isAutoAdjustable();
            Point location = null;
            if (isAutoAdjustable) {
                this.pack();
                Dimension packedSize = this.getSize();
                Dimension minSize = this.getMinimumSize();
                this.setSize(Math.max(packedSize.width, minSize.width), Math.max(packedSize.height, minSize.height));
                this.setSize((int)((float)this.getWidth() * dialogWrapper.getHorizontalStretch()), (int)((float)this.getHeight() * dialogWrapper.getVerticalStretch()));
                this.myDimensionServiceKey = dialogWrapper.getDimensionKey();
                if (this.myDimensionServiceKey != null) {
                    Project projectGuess = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
                    location = DimensionService.getInstance().getLocation(this.myDimensionServiceKey, projectGuess);
                    Dimension size = DimensionService.getInstance().getSize(this.myDimensionServiceKey, projectGuess);
                    if (size != null) {
                        this.myInitialSize = new Dimension(size);
                        this._setSizeForLocation(this.myInitialSize.width, this.myInitialSize.height, location);
                    }
                }
                if (this.myInitialSize == null) {
                    this.myInitialSize = this.getSize();
                }
            }
            if (location == null) {
                location = dialogWrapper.getInitialLocation();
            }
            if (location != null) {
                this.setLocation(location);
            } else {
                this.setLocationRelativeTo(this.getOwner());
            }
            if (isAutoAdjustable) {
                Rectangle bounds = this.getBounds();
                ScreenUtil.fitToScreen((Rectangle)bounds);
                this.setBounds(bounds);
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    final DialogWrapper wrapper = this.getDialogWrapper();
                    if (wrapper != null && myFocusTrackback != null) {
                        myFocusTrackback.cleanParentWindow();
                        myFocusTrackback.registerFocusComponent(new FocusTrackback.ComponentQuery(){

                            @Override
                            public Component getComponent() {
                                return wrapper.getPreferredFocusedComponent();
                            }
                        });
                    }
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    if (!this.isModal()) {
                        Ref focusManager = new Ref(null);
                        Project project2 = this.getProject();
                        if (project2 != null && !project2.isDisposed()) {
                            focusManager.set((Object)this.getFocusManager());
                            ((IdeFocusManager)focusManager.get()).doWhenFocusSettlesDown(() -> this.disposeFocusTrackbackIfNoChildWindowFocused((IdeFocusManager)focusManager.get()));
                        } else {
                            this.disposeFocusTrackbackIfNoChildWindowFocused((IdeFocusManager)focusManager.get());
                        }
                    }
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    ID _native;
                    if (!SystemInfo.isMacOSLion) {
                        return;
                    }
                    Window window = e.getWindow();
                    if (window instanceof Dialog && (_native = MacUtil.findWindowForTitle((String)((Dialog)window).getTitle())) != null && _native.intValue() > 0) {
                        Foundation.invoke((ID)_native, (String)"setCollectionBehavior:", (Object[])new Object[]{256});
                    }
                }
            });
            if (Registry.is((String)"actionSystem.fixLostTyping") && (queue = IdeEventQueue.getInstance()) != null) {
                queue.getKeyEventDispatcher().resetState();
            }
            if (SystemInfo.isMac && this.myProject != null && Registry.is((String)"ide.mac.fix.dialog.showing") && !dialogWrapper.isModalProgress()) {
                IdeFrame frame = WindowManager.getInstance().getIdeFrame((Project)this.myProject.get());
                AppIcon.getInstance().requestFocus(frame);
            }
            this.setBackground(UIUtil.getPanelBackground());
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            if (app != null && !app.isLoaded() && Splash.BOUNDS != null) {
                Point loc = this.getLocation();
                loc.y = Splash.BOUNDS.y + Splash.BOUNDS.height;
                this.setLocation(loc);
            }
            super.show();
        }

        @Nullable
        private Project getProject() {
            return (Project)SoftReference.dereference(this.myProject);
        }

        @Override
        public IdeFocusManager getFocusManager() {
            Project project2 = this.getProject();
            if (project2 != null && !project2.isDisposed()) {
                return IdeFocusManager.getInstance((Project)project2);
            }
            return IdeFocusManager.findInstance();
        }

        private void disposeFocusTrackbackIfNoChildWindowFocused(@Nullable IdeFocusManager focusManager) {
            if (this.myFocusTrackback == null) {
                return;
            }
            DialogWrapper wrapper = (DialogWrapper)this.myDialogWrapper.get();
            if (wrapper == null || !wrapper.isShowing()) {
                this.myFocusTrackback.dispose();
                return;
            }
            if (focusManager != null) {
                Component c = focusManager.getFocusedDescendantFor((Component)wrapper.getContentPane());
                if (c == null) {
                    this.myFocusTrackback.dispose();
                }
            } else {
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (owner == null || !SwingUtilities.isDescendingFrom(owner, wrapper.getContentPane())) {
                    this.myFocusTrackback.dispose();
                }
            }
        }

        @Override
        public void hide() {
            super.hide();
            if (this.myFocusTrackback != null && !this.myFocusTrackback.isSheduledForRestore() && !this.myFocusTrackback.isWillBeSheduledForRestore()) {
                this.myFocusTrackback.setWillBeSheduledForRestore();
                IdeFocusManager mgr = this.getFocusManager();
                Runnable r = () -> {
                    if (this.myFocusTrackback != null) {
                        this.myFocusTrackback.restoreFocus();
                    }
                    this.myFocusTrackback = null;
                };
                mgr.doWhenFocusSettlesDown(r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            BufferStrategy strategy;
            if (this.isShowing()) {
                this.hide();
            }
            if (this.myWindowListener != null) {
                this.myWindowListener.saveSize();
                this.removeWindowListener(this.myWindowListener);
                this.myWindowListener = null;
            }
            if (this.myFocusTrackback != null && !this.myFocusTrackback.isSheduledForRestore() && !this.myFocusTrackback.isWillBeSheduledForRestore()) {
                this.myFocusTrackback.dispose();
                this.myFocusTrackback = null;
            }
            if ((strategy = this.getBufferStrategy()) != null) {
                strategy.dispose();
            }
            super.dispose();
            this.removeAll();
            if (this.rootPane != null) {
                try {
                    Disposer.clearOwnFields((Object)this.rootPane);
                    this.rootPane = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Object object = this.getTreeLock();
                synchronized (object) {
                    List list = (List)ReflectionUtil.getStaticFieldValue(Dialog.class, List.class, (String)"modalDialogs");
                    list.remove(this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public Component getMostRecentFocusOwner() {
            JComponent toFocus;
            DialogWrapper wrapper;
            if (!this.myOpened && (wrapper = this.getDialogWrapper()) != null && (toFocus = wrapper.getPreferredFocusedComponent()) != null) {
                return toFocus;
            }
            return super.getMostRecentFocusOwner();
        }

        @Override
        public void paint(Graphics g) {
            if (!SystemInfo.isMac || UIUtil.isUnderAquaLookAndFeel()) {
                UISettings.setupAntialiasing((Graphics)g);
            }
            super.paint(g);
        }

        private class DialogRootPane
        extends JRootPane
        implements DataProvider {
            private final boolean myGlassPaneIsSet;
            private Dimension myLastMinimumSize;

            private DialogRootPane() {
                this.setGlassPane(new IdeGlassPaneImpl(this));
                this.myGlassPaneIsSet = true;
                this.putClientProperty("DIALOG_ROOT_PANE", true);
            }

            @Override
            @NotNull
            protected JLayeredPane createLayeredPane() {
                JBLayeredPane p = new JBLayeredPane();
                p.setName(this.getName() + ".layeredPane");
                JBLayeredPane jBLayeredPane = p;
                if (jBLayeredPane == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog$DialogRootPane", "createLayeredPane"));
                }
                return jBLayeredPane;
            }

            @Override
            public void validate() {
                Dimension size;
                Window window;
                super.validate();
                DialogWrapper wrapper = (DialogWrapper)MyDialog.this.myDialogWrapper.get();
                if (wrapper != null && wrapper.isAutoAdjustable() && (window = wrapper.getWindow()) != null && !((size = this.getMinimumSize()) != null ? size.equals(this.myLastMinimumSize) : this.myLastMinimumSize == null)) {
                    if (size == null) {
                        this.myLastMinimumSize = null;
                    } else {
                        this.myLastMinimumSize = new Dimension(size);
                        JBInsets.addTo((Dimension)size, (Insets)window.getInsets());
                    }
                    window.setMinimumSize(size);
                }
            }

            @Override
            public void setGlassPane(Component glass) {
                if (this.myGlassPaneIsSet) {
                    LOG.warn("Setting of glass pane for DialogWrapper is prohibited", (Throwable)new Exception());
                    return;
                }
                super.setGlassPane(glass);
            }

            @Override
            public void setContentPane(Container contentPane) {
                super.setContentPane(contentPane);
                if (contentPane != null) {
                    contentPane.addMouseMotionListener(new MouseMotionAdapter(){});
                }
            }

            public Object getData(@NonNls String dataId) {
                DialogWrapper wrapper = (DialogWrapper)MyDialog.this.myDialogWrapper.get();
                return wrapper != null && PlatformDataKeys.UI_DISPOSABLE.is(dataId) ? wrapper.getDisposable() : null;
            }
        }

        private class MyWindowListener
        extends WindowAdapter {
            private MyWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DialogWrapper dialogWrapper = MyDialog.this.getDialogWrapper();
                if (dialogWrapper.shouldCloseOnCross()) {
                    dialogWrapper.doCancelAction((AWTEvent)e);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.saveSize();
            }

            public void saveSize() {
                if (MyDialog.this.myDimensionServiceKey != null && MyDialog.this.myInitialSize != null && MyDialog.this.myOpened) {
                    Project projectGuess = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)MyDialog.this));
                    Point location = MyDialog.this.getLocation();
                    DimensionService.getInstance().setLocation(MyDialog.this.myDimensionServiceKey, location, projectGuess);
                    Dimension size = MyDialog.this.getSize();
                    if (!MyDialog.this.myInitialSize.equals(size)) {
                        DimensionService.getInstance().setSize(MyDialog.this.myDimensionServiceKey, size, projectGuess);
                    }
                    MyDialog.this.myOpened = false;
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(() -> {
                    MyDialog.this.myOpened = true;
                    DialogWrapper activeWrapper = this.getActiveWrapper();
                    for (JComponent c : UIUtil.uiTraverser((Component)e.getWindow()).filter(JComponent.class)) {
                        c.putClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, AntialiasingType.getAAHintForSwingComponent());
                    }
                    if (activeWrapper == null) {
                        MyDialog.this.myFocusedCallback.setRejected();
                        MyDialog.this.myTypeAheadDone.setRejected();
                    }
                });
            }

            @Override
            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(() -> {
                    JComponent toFocus;
                    DialogWrapper wrapper = this.getActiveWrapper();
                    if (wrapper == null && !MyDialog.this.myFocusedCallback.isProcessed()) {
                        MyDialog.this.myFocusedCallback.setRejected();
                        MyDialog.this.myTypeAheadDone.setRejected();
                        return;
                    }
                    if (MyDialog.this.myActivated) {
                        return;
                    }
                    MyDialog.this.myActivated = true;
                    JComponent jComponent = toFocus = wrapper == null ? null : wrapper.getPreferredFocusedComponent();
                    if (MyDialog.this.getRootPane() != null && toFocus == null) {
                        toFocus = MyDialog.this.getRootPane().getDefaultButton();
                    }
                    if (MyDialog.this.getRootPane() != null) {
                        IJSwingUtilities.moveMousePointerOn(MyDialog.this.getRootPane().getDefaultButton());
                    }
                    DialogWrapperPeerImpl.setupSelectionOnPreferredComponent(toFocus);
                    if (toFocus != null) {
                        if (MyDialog.this.isShowing() && MyDialog.this.isActive()) {
                            MyDialog.this.getFocusManager().requestFocus((Component)toFocus, true);
                            this.notifyFocused(wrapper);
                        }
                    } else if (MyDialog.this.isShowing()) {
                        this.notifyFocused(wrapper);
                    }
                    if (MyDialog.this.myTypeAheadCallback != null) {
                        MyDialog.this.myTypeAheadCallback.setDone();
                    }
                });
            }

            private void notifyFocused(DialogWrapper wrapper) {
                MyDialog.this.myFocusedCallback.setDone();
                long timeout = wrapper.getTypeAheadTimeoutMs();
                if (timeout > 0L) {
                    SimpleTimer.getInstance().setUp((Runnable)new EdtRunnable(){

                        public void runEdt() {
                            MyDialog.this.myTypeAheadDone.setDone();
                        }
                    }, timeout);
                }
            }

            private DialogWrapper getActiveWrapper() {
                DialogWrapper activeWrapper = MyDialog.this.getDialogWrapper();
                if (activeWrapper == null || !activeWrapper.isShowing()) {
                    return null;
                }
                return activeWrapper;
            }
        }
    }

    private class AnCancelAction
    extends AnAction
    implements DumbAware {
        private AnCancelAction() {
        }

        public void update(AnActionEvent e) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            e.getPresentation().setEnabled(false);
            if (focusOwner instanceof JComponent && SpeedSearchBase.hasActiveSpeedSearch((JComponent)focusOwner)) {
                return;
            }
            if (StackingPopupDispatcher.getInstance().isPopupFocused()) {
                return;
            }
            JTree tree = (JTree)UIUtil.getParentOfType(JTree.class, (Component)focusOwner);
            JTable table = (JTable)UIUtil.getParentOfType(JTable.class, (Component)focusOwner);
            if ((tree != null || table != null) && this.hasNoEditingTreesOrTablesUpward(focusOwner)) {
                e.getPresentation().setEnabled(true);
            }
        }

        private boolean hasNoEditingTreesOrTablesUpward(Component comp) {
            while (comp != null) {
                if (this.isEditingTreeOrTable(comp)) {
                    return false;
                }
                comp = comp.getParent();
            }
            return true;
        }

        private boolean isEditingTreeOrTable(Component comp) {
            if (comp instanceof JTree) {
                return ((JTree)comp).isEditing();
            }
            if (comp instanceof JTable) {
                return ((JTable)comp).isEditing();
            }
            return false;
        }

        public void actionPerformed(AnActionEvent e) {
            DialogWrapperPeerImpl.this.myWrapper.doCancelAction((AWTEvent)e.getInputEvent());
        }
    }
}

