/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.LibrarySettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsService {
    public static ProjectSettingsService getInstance(Project project2) {
        return (ProjectSettingsService)ServiceManager.getService((Project)project2, ProjectSettingsService.class);
    }

    public void openProjectSettings() {
    }

    public void openGlobalLibraries() {
    }

    public void openLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/ProjectSettingsService", "openLibrary"));
        }
    }

    public void openModuleSettings(Module module2) {
    }

    public boolean canOpenModuleSettings() {
        return false;
    }

    public void openModuleLibrarySettings(Module module2) {
    }

    public boolean canOpenModuleLibrarySettings() {
        return false;
    }

    public void openContentEntriesSettings(Module module2) {
    }

    public boolean canOpenContentEntriesSettings() {
        return false;
    }

    public void openModuleDependenciesSettings(@NotNull Module module2, @Nullable OrderEntry orderEntry) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/ProjectSettingsService", "openModuleDependenciesSettings"));
        }
    }

    public boolean canOpenModuleDependenciesSettings() {
        return false;
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/roots/ui/configuration/ProjectSettingsService", "openLibraryOrSdkSettings"));
        }
        Configurable additionalSettingsConfigurable = ProjectSettingsService.getLibrarySettingsConfigurable(orderEntry);
        if (additionalSettingsConfigurable != null) {
            ShowSettingsUtil.getInstance().showSettingsDialog(orderEntry.getOwnerModule().getProject(), additionalSettingsConfigurable.getDisplayName());
        }
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        return ProjectSettingsService.getLibrarySettingsConfigurable(orderEntry) != null;
    }

    @Nullable
    private static Configurable getLibrarySettingsConfigurable(OrderEntry orderEntry) {
        if (!(orderEntry instanceof LibraryOrderEntry)) {
            return null;
        }
        LibraryOrderEntry libOrderEntry = (LibraryOrderEntry)orderEntry;
        Library lib = libOrderEntry.getLibrary();
        if (lib instanceof LibraryEx) {
            Project project2 = libOrderEntry.getOwnerModule().getProject();
            PersistentLibraryKind libKind = ((LibraryEx)lib).getKind();
            if (libKind != null) {
                return LibrarySettingsProvider.getAdditionalSettingsConfigurable(project2, (LibraryKind)libKind);
            }
        }
        return null;
    }

    public boolean processModulesMoved(Module[] modules, @Nullable ModuleGroup targetGroup) {
        return false;
    }

    public void showModuleConfigurationDialog(@Nullable String moduleToSelect, @Nullable String editorNameToSelect) {
    }

    public Sdk chooseAndSetSdk() {
        return null;
    }
}

