/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ModuleSourceSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Chunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GeneralProjectSettingsElement
extends ProjectStructureElement {
    public GeneralProjectSettingsElement(@NotNull StructureConfigurableContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/GeneralProjectSettingsElement", "<init>"));
        }
        super(context);
    }

    @Override
    public String getPresentableText() {
        return "Project";
    }

    @Override
    public String getPresentableName() {
        return ProjectStructureConfigurable.getInstance(this.myContext.getProject()).getProjectConfig().getProjectName();
    }

    @Override
    public String getTypeName() {
        return "Project";
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        Object place;
        ProjectSdksModel model;
        Sdk sdk;
        Project project2 = this.myContext.getProject();
        if (this.containsModuleWithInheritedSdk() && (sdk = (model = ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel()).getProjectSdk()) == null) {
            place = new PlaceInProjectStructureBase(project2, ProjectStructureConfigurable.getInstance(project2).createProjectConfigurablePlace(), this);
            problemsHolder.registerProblem(ProjectBundle.message((String)"project.roots.project.jdk.problem.message", (Object[])new Object[0]), null, ProjectStructureProblemType.error("project-sdk-not-defined"), (PlaceInProjectStructure)place, null);
        }
        List sourceSetCycles = ModuleCompilerUtil.computeSourceSetCycles((ModulesProvider)this.myContext.getModulesConfigurator());
        ArrayList<String> cycles = new ArrayList<String>();
        for (Chunk chunk : sourceSetCycles) {
            Set sourceSets = chunk.getNodes();
            ArrayList<String> names = new ArrayList<String>();
            for (ModuleSourceSet sourceSet : sourceSets) {
                String name = sourceSet.getDisplayName();
                names.add(names.isEmpty() ? name : StringUtil.decapitalize((String)name));
            }
            cycles.add(StringUtil.join(names, (String)", "));
        }
        if (!cycles.isEmpty()) {
            String description;
            String message;
            place = new PlaceInProjectStructureBase(project2, ProjectStructureConfigurable.getInstance(project2).createModulesPlace(), this);
            if (cycles.size() > 1) {
                message = "Circular dependencies";
                String br = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
                StringBuilder cyclesString = new StringBuilder();
                for (int i2 = 0; i2 < cycles.size(); ++i2) {
                    cyclesString.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;").append(i2 + 1).append(". ").append((String)cycles.get(i2));
                }
                description = ProjectBundle.message((String)"module.circular.dependency.warning.description", (Object[])new Object[]{cyclesString});
            } else {
                message = ProjectBundle.message((String)"module.circular.dependency.warning.short", (Object[])new Object[]{StringUtil.decapitalize((String)((String)cycles.get(0)))});
                description = null;
            }
            problemsHolder.registerProblem(new ProjectStructureProblemDescription(message, description, (PlaceInProjectStructure)place, ProjectStructureProblemType.warning("module-circular-dependency"), Collections.emptyList()));
        }
    }

    private boolean containsModuleWithInheritedSdk() {
        for (Module module2 : this.myContext.getModules()) {
            ModuleRootModel rootModel = this.myContext.getModulesConfigurator().getRootModel(module2);
            if (!rootModel.isSdkInherited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return "project:general";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GeneralProjectSettingsElement;
    }

    @Override
    public int hashCode() {
        return 0;
    }
}

