/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleFileIndexImpl
extends FileIndexBase
implements ModuleFileIndex {
    private final Module myModule;
    private final ContentFilter myContentFilter;

    public ModuleFileIndexImpl(Module module2, DirectoryIndex directoryIndex) {
        super(directoryIndex, FileTypeRegistry.getInstance(), module2.getProject());
        this.myModule = module2;
        this.myContentFilter = new ContentFilter();
    }

    public boolean iterateContent(@NotNull ContentIterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "iterateContent"));
        }
        Set contentRoots = (Set)ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile[][] allRoots;
            if (this.myModule.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            VirtualFile[][] virtualFileArray = allRoots = ModuleFileIndexImpl.getModuleContentAndSourceRoots(this.myModule);
            int n = virtualFileArray.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = virtualFileArray[j]) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                    if (!info.isInProject() || (parent = root.getParent()) != null && (parentInfo = this.myDirectoryIndex.getInfoForFile(parent)).isInProject() && this.myModule.equals(parentInfo.getModule())) continue;
                    result2.add(root);
                }
            }
            return result2;
        });
        for (VirtualFile contentRoot : contentRoots) {
            boolean finished = VfsUtilCore.iterateChildrenRecursively((VirtualFile)contentRoot, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator);
            if (finished) continue;
            return false;
        }
        return true;
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator iterator) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "iterateContentUnderDirectory"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "iterateContentUnderDirectory"));
        }
        return VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator);
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isInContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject() && this.myModule.equals(info.getModule());
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isInSourceContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && this.myModule.equals(info.getModule());
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "getOrderEntriesForFile"));
        }
        List<OrderEntry> list = ModuleFileIndexImpl.findAllOrderEntriesWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "getOrderEntriesForFile"));
        }
        return list;
    }

    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "getOrderEntryForFile"));
        }
        return ModuleFileIndexImpl.findOrderEntryWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isInTestSourceContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && this.myModule.equals(info.getModule()) && JavaModuleSourceRootTypes.isTestSourceOrResource(this.myDirectoryIndex.getSourceRootType(info));
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isUnderSourceRootOfType"));
        }
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "isUnderSourceRootOfType"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && this.myModule.equals(info.getModule()) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Nullable
    static OrderEntry findOrderEntryWithOwnerModule(@NotNull Module ownerModule, @NotNull List<OrderEntry> orderEntries) {
        if (ownerModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerModule", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "findOrderEntryWithOwnerModule"));
        }
        if (orderEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntries", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "findOrderEntryWithOwnerModule"));
        }
        if (orderEntries.size() < 10) {
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry.getOwnerModule() != ownerModule) continue;
                return orderEntry;
            }
            return null;
        }
        int index = Collections.binarySearch(orderEntries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        return index < 0 ? null : orderEntries.get(index);
    }

    @NotNull
    private static List<OrderEntry> findAllOrderEntriesWithOwnerModule(@NotNull Module ownerModule, @NotNull List<OrderEntry> entries) {
        int lastIndex;
        if (ownerModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerModule", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "findAllOrderEntriesWithOwnerModule"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "findAllOrderEntriesWithOwnerModule"));
        }
        if (entries.size() == 0) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "findAllOrderEntriesWithOwnerModule"));
            }
            return list;
        }
        if (entries.size() == 1) {
            OrderEntry entry = entries.get(0);
            ArrayList arrayList = entry.getOwnerModule() == ownerModule ? ContainerUtil.newArrayList(entries) : Collections.emptyList();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "findAllOrderEntriesWithOwnerModule"));
            }
            return arrayList;
        }
        int index = Collections.binarySearch(entries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        if (index < 0) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "findAllOrderEntriesWithOwnerModule"));
            }
            return list;
        }
        int firstIndex = index;
        while (firstIndex - 1 >= 0 && entries.get(firstIndex - 1).getOwnerModule() == ownerModule) {
            --firstIndex;
        }
        for (lastIndex = index + 1; lastIndex < entries.size() && entries.get(lastIndex).getOwnerModule() == ownerModule; ++lastIndex) {
        }
        ArrayList arrayList = ContainerUtil.newArrayList(entries.subList(firstIndex, lastIndex));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl", "findAllOrderEntriesWithOwnerModule"));
        }
        return arrayList;
    }

    private class ContentFilter
    implements VirtualFileFilter {
        private ContentFilter() {
        }

        public boolean accept(final @NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$ContentFilter", "accept"));
            }
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    if (ModuleFileIndexImpl.this.myModule.isDisposed()) {
                        return false;
                    }
                    if (file2.isDirectory()) {
                        DirectoryInfo info = ModuleFileIndexImpl.this.myDirectoryIndex.getInfoForFile(file2);
                        return info.isInProject() && ModuleFileIndexImpl.this.myModule.equals(info.getModule());
                    }
                    return !ModuleFileIndexImpl.this.myFileTypeRegistry.isFileIgnored(file2);
                }
            });
        }
    }

    private static class FakeOrderEntry
    implements OrderEntry {
        private final Module myOwnerModule;

        public FakeOrderEntry(Module ownerModule) {
            this.myOwnerModule = ownerModule;
        }

        @NotNull
        public VirtualFile[] getFiles(OrderRootType type) {
            throw new IncorrectOperationException();
        }

        @NotNull
        public String[] getUrls(OrderRootType rootType) {
            throw new IncorrectOperationException();
        }

        @NotNull
        public String getPresentableName() {
            throw new IncorrectOperationException();
        }

        public boolean isValid() {
            throw new IncorrectOperationException();
        }

        @NotNull
        public Module getOwnerModule() {
            Module module2 = this.myOwnerModule;
            if (module2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry", "getOwnerModule"));
            }
            return module2;
        }

        public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
            throw new IncorrectOperationException();
        }

        public int compareTo(@NotNull OrderEntry o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry", "compareTo"));
            }
            throw new IncorrectOperationException();
        }

        public boolean isSynthetic() {
            throw new IncorrectOperationException();
        }
    }
}

