/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Tag(value="activation")
public class TaskActivationState {
    @Tag(value="before_run")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeRunTasks = new ArrayList<String>();
    @Tag(value="before_sync")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeSyncTasks = new ArrayList<String>();
    @Tag(value="after_sync")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> afterSyncTasks = new ArrayList<String>();
    @Tag(value="before_compile")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeCompileTasks = new ArrayList<String>();
    @Tag(value="after_compile")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> afterCompileTasks = new ArrayList<String>();
    @Tag(value="after_rebuild")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> afterRebuildTask = new ArrayList<String>();
    @Tag(value="before_rebuild")
    @AbstractCollection(surroundWithTag=false, elementTag="task", elementValueAttribute="name")
    public List<String> beforeRebuildTask = new ArrayList<String>();

    public boolean isEmpty() {
        for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
            if (this.getTasks(phase).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<String> getTasks(@NotNull ExternalSystemTaskActivator.Phase phase) {
        if (phase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phase", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
        }
        switch (phase) {
            case AFTER_COMPILE: {
                List<String> list = this.afterCompileTasks;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list;
            }
            case BEFORE_COMPILE: {
                List<String> list = this.beforeCompileTasks;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list;
            }
            case AFTER_SYNC: {
                List<String> list = this.afterSyncTasks;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list;
            }
            case BEFORE_RUN: {
                List<String> list = this.beforeRunTasks;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list;
            }
            case BEFORE_SYNC: {
                List<String> list = this.beforeSyncTasks;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list;
            }
            case AFTER_REBUILD: {
                List<String> list = this.afterRebuildTask;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list;
            }
            case BEFORE_REBUILD: {
                List<String> list = this.beforeRebuildTask;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/TaskActivationState", "getTasks"));
                }
                return list;
            }
        }
        throw new IllegalArgumentException("Unknown task activation phase: " + (Object)((Object)phase));
    }
}

