/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizer;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectStructureCustomizerImpl
extends ExternalProjectStructureCustomizer {
    private final Set<? extends Key<? extends AbstractNamedData>> myKeys = ContainerUtil.set((Object[])new Key[]{ProjectKeys.PROJECT, ProjectKeys.MODULE});

    @Override
    @NotNull
    public Set<? extends Key<?>> getIgnorableDataKeys() {
        Set<? extends Key<? extends AbstractNamedData>> set2 = this.myKeys;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ExternalProjectStructureCustomizerImpl", "getIgnorableDataKeys"));
        }
        return set2;
    }

    @Override
    @NotNull
    public Set<? extends Key<?>> getPublicDataKeys() {
        Set<? extends Key<? extends AbstractNamedData>> set2 = this.myKeys;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ExternalProjectStructureCustomizerImpl", "getPublicDataKeys"));
        }
        return set2;
    }

    @Override
    @Nullable
    public Icon suggestIcon(@NotNull DataNode node, @NotNull ExternalSystemUiAware uiAware) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/importing/ExternalProjectStructureCustomizerImpl", "suggestIcon"));
        }
        if (uiAware == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiAware", "com/intellij/openapi/externalSystem/importing/ExternalProjectStructureCustomizerImpl", "suggestIcon"));
        }
        if (ProjectKeys.PROJECT.equals((Object)node.getKey())) {
            return uiAware.getProjectIcon();
        }
        if (ProjectKeys.MODULE.equals((Object)node.getKey())) {
            return uiAware.getProjectIcon();
        }
        return null;
    }

    @Override
    @NotNull
    public Couple<String> getRepresentationName(@NotNull DataNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/importing/ExternalProjectStructureCustomizerImpl", "getRepresentationName"));
        }
        if (ProjectKeys.PROJECT.equals((Object)node.getKey())) {
            ProjectData projectData = (ProjectData)node.getData();
            Couple couple = Couple.of((Object)("Project: " + projectData.getExternalName()), (Object)projectData.getDescription());
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ExternalProjectStructureCustomizerImpl", "getRepresentationName"));
            }
            return couple;
        }
        if (ProjectKeys.MODULE.equals((Object)node.getKey())) {
            ModuleData moduleData = (ModuleData)node.getData();
            Couple couple = Couple.of((Object)moduleData.getId(), (Object)moduleData.getDescription());
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ExternalProjectStructureCustomizerImpl", "getRepresentationName"));
            }
            return couple;
        }
        Couple<String> couple = super.getRepresentationName(node);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ExternalProjectStructureCustomizerImpl", "getRepresentationName"));
        }
        return couple;
    }
}

