/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class TextLayoutCache
implements PrioritizedDocumentListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(TextLayoutCache.class);
    private static final int MAX_CHUNKS_IN_ACTIVE_EDITOR = 1000;
    private static final int MAX_CHUNKS_IN_INACTIVE_EDITOR = 10;
    private final EditorView myView;
    private final Document myDocument;
    private final LineLayout myBidiNotRequiredMarker;
    private ArrayList<LineLayout> myLines = new ArrayList();
    private int myDocumentChangeOldEndLine;
    private LinkedHashMap<LineLayout.Chunk, Object> myLaidOutChunks = new LinkedHashMap<LineLayout.Chunk, Object>(1000, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<LineLayout.Chunk, Object> eldest) {
            if (this.size() > TextLayoutCache.this.getChunkCacheSizeLimit()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clearing chunk for " + TextLayoutCache.this.myView.getEditor().getVirtualFile());
                }
                eldest.getKey().clearCache();
                return true;
            }
            return false;
        }
    };

    TextLayoutCache(EditorView view) {
        this.myView = view;
        this.myDocument = view.getEditor().getDocument();
        this.myDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
        this.myBidiNotRequiredMarker = LineLayout.create(view, "", 0);
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)view.getEditor().getContentComponent(), (Activatable)new Activatable.Adapter(){

            public void hideNotify() {
                TextLayoutCache.this.trimChunkCache();
            }
        }));
    }

    @Override
    public int getPriority() {
        return 70;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDocumentChangeOldEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getOldLength());
    }

    public void documentChanged(DocumentEvent event) {
        int startLine = this.myDocument.getLineNumber(event.getOffset());
        int newEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getNewLength());
        this.invalidateLines(startLine, this.myDocumentChangeOldEndLine, newEndLine, true, LineLayout.isBidiLayoutRequired(event.getNewFragment()));
    }

    public void dispose() {
        this.myLines = null;
        this.myLaidOutChunks = null;
    }

    private int getAdjustedLineNumber(int offset) {
        return this.myDocument.getTextLength() == 0 ? -1 : this.myDocument.getLineNumber(offset);
    }

    void resetToDocumentSize(boolean documentChangedWithoutNotification) {
        this.checkDisposed();
        this.invalidateLines(0, this.myLines.size() - 1, this.myDocument.getLineCount() - 1, documentChangedWithoutNotification, documentChangedWithoutNotification);
    }

    void invalidateLines(int startLine, int endLine) {
        this.invalidateLines(startLine, endLine, endLine, false, false);
    }

    private void invalidateLines(int startLine, int oldEndLine, int newEndLine, boolean textChanged, boolean bidiRequiredForNewText) {
        this.checkDisposed();
        if (textChanged) {
            LineLayout lastOldLine;
            LineLayout firstOldLine = startLine >= 0 && startLine < this.myLines.size() ? this.myLines.get(startLine) : null;
            LineLayout lineLayout = lastOldLine = oldEndLine >= 0 && oldEndLine < this.myLines.size() ? this.myLines.get(oldEndLine) : null;
            if (firstOldLine == null || lastOldLine == null || !firstOldLine.isLtr() || !lastOldLine.isLtr()) {
                bidiRequiredForNewText = true;
            }
        }
        int endLine = Math.min(oldEndLine, newEndLine);
        for (int line = startLine; line <= endLine; ++line) {
            LineLayout lineLayout = this.myLines.get(line);
            if (lineLayout == null) continue;
            this.removeChunksFromCache(lineLayout);
            this.myLines.set(line, textChanged && bidiRequiredForNewText || !lineLayout.isLtr() ? null : this.myBidiNotRequiredMarker);
        }
        if (oldEndLine < newEndLine) {
            this.myLines.addAll(oldEndLine + 1, Collections.nCopies(newEndLine - oldEndLine, null));
        } else if (oldEndLine > newEndLine) {
            List<LineLayout> layouts = this.myLines.subList(newEndLine + 1, oldEndLine + 1);
            for (LineLayout layout : layouts) {
                if (layout == null) continue;
                this.removeChunksFromCache(layout);
            }
            layouts.clear();
        }
    }

    @NotNull
    LineLayout getLineLayout(int line) {
        LineLayout result2;
        this.checkDisposed();
        if (line >= this.myLines.size()) {
            LOG.error("Unexpected cache state", new Attachment[]{new Attachment("editorState.txt", this.myView.getEditor().dumpState())});
        }
        if ((result2 = this.myLines.get(line)) == null || result2 == this.myBidiNotRequiredMarker) {
            result2 = LineLayout.create(this.myView, line, result2 == this.myBidiNotRequiredMarker);
            this.myLines.set(line, result2);
        }
        LineLayout lineLayout = result2;
        if (lineLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextLayoutCache", "getLineLayout"));
        }
        return lineLayout;
    }

    boolean hasCachedLayoutFor(int line) {
        LineLayout layout = this.myLines.get(line);
        return layout != null && layout != this.myBidiNotRequiredMarker;
    }

    private int getChunkCacheSizeLimit() {
        return this.myView.getEditor().getContentComponent().isShowing() ? 1000 : 10;
    }

    void onChunkAccess(LineLayout.Chunk chunk) {
        this.myLaidOutChunks.put(chunk, null);
    }

    private void removeChunksFromCache(LineLayout layout) {
        layout.getChunksInLogicalOrder().forEach(this.myLaidOutChunks::remove);
    }

    private void trimChunkCache() {
        int limit = this.getChunkCacheSizeLimit();
        if (this.myLaidOutChunks.size() > limit) {
            Iterator<LineLayout.Chunk> it = this.myLaidOutChunks.keySet().iterator();
            while (this.myLaidOutChunks.size() > limit) {
                LineLayout.Chunk chunk = it.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clearing chunk for " + this.myView.getEditor().getVirtualFile());
                }
                chunk.clearCache();
                it.remove();
            }
        }
    }

    private void checkDisposed() {
        if (this.myLines == null) {
            this.myView.getEditor().throwDisposalError("Editor is already disposed");
        }
    }
}

