/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreCommandProcessor
extends CommandProcessorEx {
    protected CommandDescriptor myCurrentCommand;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myUndoTransparentCount;

    public void executeCommand(@NotNull Runnable runnable2, String name, Object groupId) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(null, runnable2, name, groupId);
    }

    public void executeCommand(Project project2, @NotNull Runnable runnable2, String name, Object groupId) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(project2, runnable2, name, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    public void executeCommand(Project project2, @NotNull Runnable runnable2, String name, Object groupId, Document document) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(project2, runnable2, name, groupId, UndoConfirmationPolicy.DEFAULT, document);
    }

    public void executeCommand(Project project2, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(project2, command, name, groupId, confirmationPolicy, null);
    }

    public void executeCommand(Project project2, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, Document document) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(project2, command, name, groupId, confirmationPolicy, true, document);
    }

    public void executeCommand(@Nullable Project project2, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean shouldRecordCommandForActiveDocument) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        this.executeCommand(project2, command, name, groupId, confirmationPolicy, shouldRecordCommandForActiveDocument, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(@Nullable Project project2, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean shouldRecordCommandForActiveDocument, @Nullable Document document) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        if (confirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationPolicy", "com/intellij/openapi/command/impl/CoreCommandProcessor", "executeCommand"));
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (project2 != null && project2.isDisposed()) {
            CommandLog.LOG.error("Project " + project2 + " already disposed");
            return;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("executeCommand: " + command + ", name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            command.run();
            return;
        }
        Throwable throwable = null;
        try {
            this.myCurrentCommand = new CommandDescriptor(command, project2, name, groupId, confirmationPolicy, shouldRecordCommandForActiveDocument, document);
            this.fireCommandStarted();
            command.run();
        }
        catch (Throwable th) {
            throwable = th;
        }
        finally {
            this.finishCommand(project2, this.myCurrentCommand, throwable);
        }
    }

    @Override
    @Nullable
    public Object startCommand(@NotNull Project project2, @Nls String name, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/command/impl/CoreCommandProcessor", "startCommand"));
        }
        if (undoConfirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "undoConfirmationPolicy", "com/intellij/openapi/command/impl/CoreCommandProcessor", "startCommand"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2.isDisposed()) {
            return null;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("startCommand: name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            return null;
        }
        Document document = groupId instanceof Ref && ((Ref)groupId).get() instanceof Document ? (Document)((Ref)groupId).get() : null;
        this.myCurrentCommand = new CommandDescriptor(EmptyRunnable.INSTANCE, project2, name, groupId, undoConfirmationPolicy, true, document);
        this.fireCommandStarted();
        return this.myCurrentCommand;
    }

    @Override
    public void finishCommand(Project project2, Object command, Throwable throwable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null, (Object)"no current command in progress");
        this.fireCommandFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCommandFinished() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        try {
            for (CommandListener listener2 : this.myListeners) {
                try {
                    listener2.beforeCommandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
        finally {
            this.myCurrentCommand = null;
            for (CommandListener listener2 : this.myListeners) {
                try {
                    listener2.commandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
    }

    @Override
    public void enterModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        this.myInterruptedCommands.push(currentCommand);
        if (currentCommand != null) {
            this.fireCommandFinished();
        }
    }

    @Override
    public void leaveModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand == null, (Object)("Command must not run: " + this.myCurrentCommand));
        this.myCurrentCommand = this.myInterruptedCommands.pop();
        if (this.myCurrentCommand != null) {
            this.fireCommandStarted();
        }
    }

    public void setCurrentCommandName(String name) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myName = name;
    }

    public void setCurrentCommandGroupId(Object groupId) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myGroupId = groupId;
    }

    @Nullable
    public Runnable getCurrentCommand() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myCommand : null;
    }

    @Nullable
    public String getCurrentCommandName() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myName;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myName : null;
        }
        return null;
    }

    @Nullable
    public Object getCurrentCommandGroupId() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myGroupId;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myGroupId : null;
        }
        return null;
    }

    @Nullable
    public Project getCurrentCommandProject() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myProject : null;
    }

    public void addCommandListener(@NotNull CommandListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addCommandListener"));
        }
        this.myListeners.add(listener2);
    }

    public void addCommandListener(final @NotNull CommandListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addCommandListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addCommandListener"));
        }
        this.addCommandListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoreCommandProcessor.this.removeCommandListener(listener2);
            }
        });
    }

    public void removeCommandListener(@NotNull CommandListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/command/impl/CoreCommandProcessor", "removeCommandListener"));
        }
        this.myListeners.remove(listener2);
    }

    public void runUndoTransparentAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/command/impl/CoreCommandProcessor", "runUndoTransparentAction"));
        }
        if (this.myUndoTransparentCount++ == 0) {
            this.fireUndoTransparentStarted();
        }
        try {
            action.run();
        }
        finally {
            if (--this.myUndoTransparentCount == 0) {
                this.fireUndoTransparentFinished();
            }
        }
    }

    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    public void markCurrentCommandAsGlobal(Project project2) {
    }

    public void addAffectedDocuments(Project project2, Document ... docs) {
        if (docs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docs", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addAffectedDocuments"));
        }
    }

    public void addAffectedFiles(Project project2, VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/command/impl/CoreCommandProcessor", "addAffectedFiles"));
        }
    }

    private void fireCommandStarted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        for (CommandListener listener2 : this.myListeners) {
            try {
                listener2.commandStarted(event);
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentStarted() {
        for (CommandListener listener2 : this.myListeners) {
            try {
                listener2.undoTransparentActionStarted();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentFinished() {
        for (CommandListener listener2 : this.myListeners) {
            try {
                listener2.undoTransparentActionFinished();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private static class CommandDescriptor {
        @NotNull
        public final Runnable myCommand;
        public final Project myProject;
        public String myName;
        public Object myGroupId;
        public final Document myDocument;
        @NotNull
        public final UndoConfirmationPolicy myUndoConfirmationPolicy;
        public final boolean myShouldRecordActionForActiveDocument;

        CommandDescriptor(@NotNull Runnable command, Project project2, String name, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, Document document) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/impl/CoreCommandProcessor$CommandDescriptor", "<init>"));
            }
            if (undoConfirmationPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "undoConfirmationPolicy", "com/intellij/openapi/command/impl/CoreCommandProcessor$CommandDescriptor", "<init>"));
            }
            this.myCommand = command;
            this.myProject = project2;
            this.myName = name;
            this.myGroupId = groupId;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myShouldRecordActionForActiveDocument = shouldRecordActionForActiveDocument;
            this.myDocument = document;
        }

        public String toString() {
            return "'" + this.myName + "', group: '" + this.myGroupId + "'";
        }
    }
}

