/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import org.jetbrains.annotations.NotNull;

final class ProxyShortcutSet
implements ShortcutSet {
    private final String myActionId;
    private final KeymapManager myKeymapManager;

    public ProxyShortcutSet(String actionId, KeymapManager keymapManager) {
        this.myActionId = actionId;
        this.myKeymapManager = keymapManager;
    }

    @NotNull
    public Shortcut[] getShortcuts() {
        Keymap keymap = this.myKeymapManager.getActiveKeymap();
        Shortcut[] shortcutArray = keymap.getShortcuts(this.myActionId);
        if (shortcutArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ProxyShortcutSet", "getShortcuts"));
        }
        return shortcutArray;
    }
}

