/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MockFileIndexFacade
extends FileIndexFacade {
    private final Module myModule = null;
    private final List<VirtualFile> myLibraryRoots = new ArrayList<VirtualFile>();

    public MockFileIndexFacade(Project project2) {
        super(project2);
    }

    public boolean isInContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileIndexFacade", "isInContent"));
        }
        return true;
    }

    public boolean isInSource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileIndexFacade", "isInSource"));
        }
        return true;
    }

    public boolean isInSourceContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileIndexFacade", "isInSourceContent"));
        }
        return true;
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileIndexFacade", "isInLibraryClasses"));
        }
        for (VirtualFile libraryRoot : this.myLibraryRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)libraryRoot, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileIndexFacade", "isInLibrarySource"));
        }
        return false;
    }

    public boolean isExcludedFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileIndexFacade", "isExcludedFile"));
        }
        return false;
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileIndexFacade", "isUnderIgnored"));
        }
        return false;
    }

    public Module getModuleForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileIndexFacade", "getModuleForFile"));
        }
        return this.myModule;
    }

    public boolean isValidAncestor(@NotNull VirtualFile baseDir, @NotNull VirtualFile child) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/mock/MockFileIndexFacade", "isValidAncestor"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/mock/MockFileIndexFacade", "isValidAncestor"));
        }
        return VfsUtilCore.isAncestor((VirtualFile)baseDir, (VirtualFile)child, (boolean)false);
    }

    @NotNull
    public ModificationTracker getRootModificationTracker() {
        ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
        if (modificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileIndexFacade", "getRootModificationTracker"));
        }
        return modificationTracker;
    }

    public void addLibraryRoot(VirtualFile file2) {
        this.myLibraryRoots.add(file2);
    }
}

