/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.HtmlHighlightingLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JavaHighlightingLexer
extends LayeredLexer {
    private boolean myAtStart;
    private boolean myModuleInfo;

    public JavaHighlightingLexer(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/lexer/JavaHighlightingLexer", "<init>"));
        }
        super(JavaParserDefinition.createLexer(languageLevel));
        this.myAtStart = true;
        this.myModuleInfo = false;
        this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\"', JavaTokenType.STRING_LITERAL), new IElementType[]{JavaTokenType.STRING_LITERAL}, IElementType.EMPTY_ARRAY);
        this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\'', JavaTokenType.STRING_LITERAL), new IElementType[]{JavaTokenType.CHARACTER_LITERAL}, IElementType.EMPTY_ARRAY);
        LayeredLexer docLexer = new LayeredLexer(JavaParserDefinition.createDocLexer(languageLevel));
        HtmlHighlightingLexer htmlLexer = new HtmlHighlightingLexer(null);
        htmlLexer.setHasNoEmbeddments(true);
        docLexer.registerLayer((Lexer)htmlLexer, new IElementType[]{JavaDocTokenType.DOC_COMMENT_DATA});
        this.registerSelfStoppingLayer((Lexer)docLexer, new IElementType[]{JavaDocElementType.DOC_COMMENT}, IElementType.EMPTY_ARRAY);
    }

    public IElementType getTokenType() {
        IElementType t = super.getTokenType();
        if (this.myAtStart && !this.isLayerActive() && !ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(t)) {
            this.myAtStart = false;
            boolean bl = this.myModuleInfo = t == JavaTokenType.IDENTIFIER && "module".equals(this.getTokenText());
        }
        if (this.myModuleInfo && t == JavaTokenType.IDENTIFIER) {
            switch (this.getTokenText()) {
                case "module": {
                    t = JavaTokenType.MODULE_KEYWORD;
                    break;
                }
                case "requires": {
                    t = JavaTokenType.REQUIRES_KEYWORD;
                    break;
                }
                case "exports": {
                    t = JavaTokenType.EXPORTS_KEYWORD;
                    break;
                }
                case "uses": {
                    t = JavaTokenType.USES_KEYWORD;
                    break;
                }
                case "provides": {
                    t = JavaTokenType.PROVIDES_KEYWORD;
                    break;
                }
                case "to": {
                    t = JavaTokenType.TO_KEYWORD;
                    break;
                }
                case "with": {
                    t = JavaTokenType.WITH_KEYWORD;
                }
            }
        }
        return t;
    }
}

