/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ProjectNameStep
extends ModuleWizardStep {
    private final JPanel myPanel;
    protected final JPanel myAdditionalContentPanel;
    protected NamePathComponent myNamePathComponent;
    protected final WizardContext myWizardContext;
    @Nullable
    protected final WizardMode myMode;
    private final ProjectFormatPanel myFormatPanel = new ProjectFormatPanel();

    public ProjectNameStep(WizardContext wizardContext, @Nullable WizardMode mode) {
        this.myWizardContext = wizardContext;
        this.myMode = mode;
        this.myNamePathComponent = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.project.files.location", (Object[])new Object[0]), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0])}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0]))}), true, false);
        String baseDir = this.myWizardContext.getProjectFileDirectory();
        String projectName = this.myWizardContext.getProjectName();
        String initialProjectName = projectName != null ? projectName : ProjectWizardUtil.findNonExistingFileName(baseDir, "untitled", "");
        this.myNamePathComponent.setPath(projectName == null ? baseDir + File.separator + initialProjectName : baseDir);
        this.myNamePathComponent.setNameValue(initialProjectName);
        this.myNamePathComponent.getNameComponent().select(0, initialProjectName.length());
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.myPanel.add((Component)this.myNamePathComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)10, (int)0, (int)20, (int)0), 0, 0));
        this.myNamePathComponent.setVisible(this.isStepVisible());
        this.myAdditionalContentPanel = new JPanel(new GridBagLayout());
        this.myPanel.add((Component)this.myAdditionalContentPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public boolean isStepVisible() {
        return this.myWizardContext.getProject() == null;
    }

    public void updateDataModel() {
        this.myWizardContext.setProjectName(this.getProjectName());
        String projectFileDirectory = this.getProjectFileDirectory();
        this.myWizardContext.setProjectFileDirectory(projectFileDirectory);
        ProjectBuilder moduleBuilder = this.myWizardContext.getProjectBuilder();
        if (moduleBuilder != null) {
            this.myWizardContext.setProjectBuilder(moduleBuilder);
            if (moduleBuilder instanceof ModuleBuilder) {
                ((ModuleBuilder)moduleBuilder).setContentEntryPath(projectFileDirectory);
            } else if (moduleBuilder instanceof ProjectFromSourcesBuilderImpl) {
                ((ProjectFromSourcesBuilderImpl)moduleBuilder).setBaseProjectPath(projectFileDirectory);
            }
        }
        this.myFormatPanel.updateData(this.myWizardContext);
    }

    public Icon getIcon() {
        return this.myWizardContext.getStepIcon();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNamePathComponent.getNameComponent();
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromCode.name";
    }

    public String getProjectFileDirectory() {
        return this.myNamePathComponent.getPath();
    }

    public String getProjectName() {
        return this.myNamePathComponent.getNameValue();
    }

    public boolean validate() throws ConfigurationException {
        return this.myNamePathComponent.validateNameAndPath(this.myWizardContext, this.myFormatPanel.isDefault());
    }
}

