/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilterDialog
extends DialogWrapper {
    private final TodoFilter myFilter;
    private final int myFilterIndex;
    private final List<TodoFilter> myFilters;
    private final JTextField myNameField;
    private final JScrollPane myPatternsScrollPane;

    public FilterDialog(Component parent, TodoFilter filter, int filterIndex, List<TodoFilter> filters, List<TodoPattern> patterns) {
        super(parent, true);
        this.setTitle(IdeBundle.message((String)"title.add.todo.filter", (Object[])new Object[0]));
        this.myFilter = filter;
        this.myFilterIndex = filterIndex;
        this.myFilters = filters;
        this.myNameField = new JBTextField(filter.getName());
        CheckBoxList patternsList = new CheckBoxList();
        patternsList.setSelectionMode(2);
        patternsList.setCheckBoxListListener((index, value) -> {
            if (value) {
                this.myFilter.addTodoPattern((TodoPattern)patternsList.getItemAt(index));
            } else {
                this.myFilter.removeTodoPattern((TodoPattern)patternsList.getItemAt(index));
            }
        });
        for (TodoPattern pattern : patterns) {
            patternsList.addItem((Object)pattern, pattern.getPatternString(), this.myFilter.contains(pattern));
        }
        if (patternsList.getItemsCount() > 0) {
            patternsList.setSelectedIndex(0);
        }
        this.myPatternsScrollPane = ScrollPaneFactory.createScrollPane((Component)patternsList);
        this.myPatternsScrollPane.setMinimumSize(new Dimension(300, -1));
        this.init();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String filterName = this.getNewFilterName();
        if (filterName.isEmpty()) {
            return new ValidationInfo(IdeBundle.message((String)"error.filter.name.should.be.specified", (Object[])new Object[0]), (JComponent)this.myNameField);
        }
        for (int i2 = 0; i2 < this.myFilters.size(); ++i2) {
            TodoFilter filter = this.myFilters.get(i2);
            if (this.myFilterIndex == i2 || !filterName.equals(filter.getName())) continue;
            return new ValidationInfo(IdeBundle.message((String)"error.filter.with.the.same.name.already.exists", (Object[])new Object[0]), (JComponent)this.myNameField);
        }
        if (this.myFilter.isEmpty()) {
            return new ValidationInfo(IdeBundle.message((String)"error.filter.should.contain.at.least.one.pattern", (Object[])new Object[0]), (JComponent)this.myPatternsScrollPane);
        }
        return super.doValidate();
    }

    @NotNull
    private String getNewFilterName() {
        String string = this.myNameField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/configurable/FilterDialog", "getNewFilterName"));
        }
        return string;
    }

    protected void doOKAction() {
        this.myFilter.setName(this.getNewFilterName());
        super.doOKAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/configurable/FilterDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.idesettings.todo.editfilter");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        JPanel patternListPanel = new JPanel(new BorderLayout());
        patternListPanel.setBorder(IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"group.todo.filter.patterns", (Object[])new Object[0])));
        patternListPanel.add((Component)this.myPatternsScrollPane, "Center");
        return FormBuilder.createFormBuilder().addLabeledComponent(IdeBundle.message((String)"label.todo.filter.name", (Object[])new Object[0]), (JComponent)this.myNameField).addComponentFillVertically((JComponent)patternListPanel, 0).getPanel();
    }
}

