/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.todo.FileTree;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.ide.util.treeView.TreeUpdatePass;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TodoTreeBuilder
extends AbstractTreeBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.todo.TodoTreeBuilder");
    protected final Project myProject;
    protected final FileTree myFileTree;
    protected final HashSet<VirtualFile> myDirtyFileSet;
    protected final HashMap<VirtualFile, EditorHighlighter> myFile2Highlighter;
    protected final PsiTodoSearchHelper mySearchHelper;
    private boolean myUpdatable;
    private final MyFileStatusListener myFileStatusListener;

    TodoTreeBuilder(JTree tree, DefaultTreeModel treeModel, Project project2) {
        super(tree, treeModel, null, MyComparator.ourInstance, false);
        this.myProject = project2;
        this.myFileTree = new FileTree();
        this.myDirtyFileSet = new HashSet();
        this.myFile2Highlighter = new HashMap();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        this.mySearchHelper = PsiTodoSearchHelper.SERVICE.getInstance((Project)this.myProject);
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeListener());
        this.myFileStatusListener = new MyFileStatusListener();
        this.setCanYieldUpdate(true);
    }

    public final void init() {
        TodoTreeStructure todoTreeStructure = this.createTreeStructure();
        this.setTreeStructure(todoTreeStructure);
        todoTreeStructure.setTreeBuilder(this);
        try {
            this.rebuildCache();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        this.initRootNode();
        Object selectableElement = todoTreeStructure.getFirstSelectableElement();
        if (selectableElement != null) {
            this.buildNodeForElement(selectableElement);
            DefaultMutableTreeNode node = this.getNodeForElement(selectableElement);
            if (node != null) {
                this.getTree().getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
            }
        }
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)this.myFileStatusListener);
    }

    public final void dispose() {
        FileStatusManager.getInstance((Project)this.myProject).removeFileStatusListener((FileStatusListener)this.myFileStatusListener);
        super.dispose();
    }

    final boolean isUpdatable() {
        return this.myUpdatable;
    }

    final void setUpdatable(boolean updatable) {
        if (this.myUpdatable != updatable) {
            this.myUpdatable = updatable;
            if (updatable) {
                DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> this.updateTree(false));
            }
        }
    }

    @NotNull
    protected abstract TodoTreeStructure createTreeStructure();

    protected boolean validateNode(Object child) {
        if (child instanceof ProjectViewNode) {
            ProjectViewNode projectViewNode = (ProjectViewNode)child;
            projectViewNode.update();
            if (projectViewNode.getValue() == null) {
                return false;
            }
        }
        return true;
    }

    public final TodoTreeStructure getTodoTreeStructure() {
        return (TodoTreeStructure)this.getTreeStructure();
    }

    protected final AbstractTreeUpdater createUpdater() {
        return new AbstractTreeUpdater(this){

            protected ActionCallback beforeUpdate(TreeUpdatePass pass) {
                if (!TodoTreeBuilder.this.myDirtyFileSet.isEmpty()) {
                    AsyncResult callback = new AsyncResult();
                    DumbService.getInstance((Project)TodoTreeBuilder.this.myProject).runWhenSmart(() -> {
                        try {
                            TodoTreeBuilder.this.validateCache();
                            TodoTreeBuilder.this.getTodoTreeStructure().validateCache();
                        }
                        finally {
                            callback.setDone();
                        }
                    });
                    return callback;
                }
                return ActionCallback.DONE;
            }
        };
    }

    public Iterator<PsiFile> getAllFiles() {
        final Iterator<VirtualFile> iterator = this.myFileTree.getFileIterator();
        return new Iterator<PsiFile>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            @Nullable
            public PsiFile next() {
                VirtualFile vFile = (VirtualFile)iterator.next();
                if (vFile == null || !vFile.isValid()) {
                    return null;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)TodoTreeBuilder.this.myProject).findFile(vFile);
                if (psiFile == null || !psiFile.isValid()) {
                    return null;
                }
                return psiFile;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException();
            }
        };
    }

    public Iterator<PsiFile> getFiles(PsiDirectory psiDirectory) {
        return this.getFiles(psiDirectory, true);
    }

    public Iterator<PsiFile> getFiles(PsiDirectory psiDirectory, boolean skip) {
        List<VirtualFile> files = this.myFileTree.getFiles(psiDirectory.getVirtualFile());
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>(files.size());
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file2 : files) {
            PsiDirectory directory;
            PsiFile psiFile;
            boolean isInContent;
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory);
            if (module2 != null && !(isInContent = ModuleRootManager.getInstance((Module)module2).getFileIndex().isInContent(file2)) || !file2.isValid() || (psiFile = psiManager.findFile(file2)) == null || (directory = psiFile.getContainingDirectory()) != null && skip && TodoTreeHelper.getInstance(this.myProject).skipDirectory(directory)) continue;
            psiFileList.add(psiFile);
        }
        return psiFileList.iterator();
    }

    public Iterator<PsiFile> getFilesUnderDirectory(PsiDirectory psiDirectory) {
        List<VirtualFile> files = this.myFileTree.getFilesUnderDirectory(psiDirectory.getVirtualFile());
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>(files.size());
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file2 : files) {
            PsiFile psiFile;
            boolean isInContent;
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory);
            if (module2 != null && !(isInContent = ModuleRootManager.getInstance((Module)module2).getFileIndex().isInContent(file2)) || !file2.isValid() || (psiFile = psiManager.findFile(file2)) == null) continue;
            psiFileList.add(psiFile);
        }
        return psiFileList.iterator();
    }

    public Iterator<PsiFile> getFiles(Module module2) {
        VirtualFile[] contentRoots;
        if (module2.isDisposed()) {
            return Collections.emptyList().iterator();
        }
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (VirtualFile virtualFile : contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            List<VirtualFile> files = this.myFileTree.getFiles(virtualFile);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            for (VirtualFile file2 : files) {
                PsiFile psiFile;
                if (fileIndex.getModuleForFile(file2) != module2 || !file2.isValid() || (psiFile = psiManager.findFile(file2)) == null) continue;
                psiFileList.add(psiFile);
            }
        }
        return psiFileList.iterator();
    }

    private boolean canContainTodoItems(PsiFile psiFile) {
        VirtualFile vFile = psiFile.getVirtualFile();
        return this.myFileTree.contains(vFile) || this.myDirtyFileSet.contains(vFile);
    }

    private void markFileAsDirty(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ide/todo/TodoTreeBuilder", "markFileAsDirty"));
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile != null) {
            this.myDirtyFileSet.add(vFile);
        }
    }

    void rebuildCache() {
        this.myFileTree.clear();
        this.myDirtyFileSet.clear();
        this.myFile2Highlighter.clear();
        this.collectFiles((Processor<VirtualFile>)((Processor)virtualFile -> {
            this.myFileTree.add((VirtualFile)virtualFile);
            return true;
        }));
        this.getTodoTreeStructure().validateCache();
    }

    void collectFiles(Processor<VirtualFile> collector) {
        PsiFile[] psiFiles;
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        for (PsiFile psiFile : psiFiles = this.mySearchHelper.findFilesWithTodoItems()) {
            if (this.mySearchHelper.getTodoItemsCount(psiFile) <= 0 || !treeStructure.accept(psiFile)) continue;
            collector.process((Object)psiFile.getVirtualFile());
        }
    }

    void rebuildCache(Set<VirtualFile> files) {
        this.myFileTree.clear();
        this.myDirtyFileSet.clear();
        this.myFile2Highlighter.clear();
        for (VirtualFile virtualFile : files) {
            this.myFileTree.add(virtualFile);
        }
        this.getTodoTreeStructure().validateCache();
    }

    private void validateCache() {
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        Iterator<VirtualFile> i2 = this.myDirtyFileSet.iterator();
        while (i2.hasNext()) {
            PsiFile psiFile;
            VirtualFile file2 = i2.next();
            PsiFile psiFile2 = psiFile = file2.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(file2) : null;
            if (psiFile == null || !treeStructure.accept(psiFile)) {
                if (this.myFileTree.contains(file2)) {
                    this.myFileTree.removeFile(file2);
                    if (this.myFile2Highlighter.containsKey((Object)file2)) {
                        this.myFile2Highlighter.remove((Object)file2);
                    }
                }
            } else {
                this.myFileTree.removeFile(file2);
                this.myFileTree.add(file2);
                if (this.myFile2Highlighter.containsKey((Object)file2)) {
                    Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
                    EditorHighlighter highlighter = (EditorHighlighter)this.myFile2Highlighter.get((Object)file2);
                    highlighter.setText(document.getCharsSequence());
                }
            }
            i2.remove();
        }
        LOG.assertTrue(this.myDirtyFileSet.isEmpty());
    }

    protected boolean isAutoExpandNode(NodeDescriptor descriptor) {
        return this.getTodoTreeStructure().isAutoExpandNode(descriptor);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        Object element = nodeDescriptor.getElement();
        if (element instanceof TodoItemNode) {
            return false;
        }
        if (element instanceof PsiFileNode) {
            try {
                return this.getTodoTreeStructure().mySearchHelper.getTodoItemsCount((PsiFile)((PsiFileNode)((Object)element)).getValue()) > 0;
            }
            catch (IndexNotReadyException e) {
                return true;
            }
        }
        return true;
    }

    public TodoItemNode getFirstPointerForElement(Object element) {
        if (element instanceof TodoItemNode) {
            return (TodoItemNode)element;
        }
        Object[] children2 = this.getTreeStructure().getChildElements(element);
        if (children2.length == 0) {
            return null;
        }
        Object firstChild = children2[0];
        if (firstChild instanceof TodoItemNode) {
            return (TodoItemNode)firstChild;
        }
        return this.getFirstPointerForElement(firstChild);
    }

    public TodoItemNode getLastPointerForElement(Object element) {
        if (element instanceof TodoItemNode) {
            return (TodoItemNode)element;
        }
        Object[] children2 = this.getTreeStructure().getChildElements(element);
        if (children2.length == 0) {
            return null;
        }
        Object firstChild = children2[children2.length - 1];
        if (firstChild instanceof TodoItemNode) {
            return (TodoItemNode)firstChild;
        }
        return this.getLastPointerForElement(firstChild);
    }

    protected final void updateTree(boolean later) {
        if (this.myUpdatable) {
            this.getUpdater().addSubtreeToUpdate(this.getRootNode());
            if (!later) {
                this.getUpdater().performUpdate();
            }
        }
    }

    static PsiFile getFileForNode(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof TodoFileNode) {
            return (PsiFile)((TodoFileNode)obj).getValue();
        }
        if (obj instanceof TodoItemNode) {
            SmartTodoItemPointer pointer = (SmartTodoItemPointer)((TodoItemNode)obj).getValue();
            return pointer.getTodoItem().getFile();
        }
        return null;
    }

    void collapseAll() {
        for (int row = this.getTree().getRowCount() - 1; row > 0; --row) {
            this.getTree().collapseRow(row);
        }
    }

    void setShowPackages(boolean state) {
        this.getTodoTreeStructure().setShownPackages(state);
        ArrayList pathsToExpand = new ArrayList();
        ArrayList pathsToSelect = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, pathsToSelect, (boolean)true);
        this.getTree().clearSelection();
        this.getTodoTreeStructure().validateCache();
        this.updateTree(false);
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, pathsToExpand, pathsToSelect, (boolean)true);
    }

    void setFlattenPackages(boolean state) {
        ArrayList pathsToExpand = new ArrayList();
        ArrayList pathsToSelect = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, pathsToSelect, (boolean)true);
        this.getTree().clearSelection();
        TodoTreeStructure todoTreeStructure = this.getTodoTreeStructure();
        todoTreeStructure.setFlattenPackages(state);
        todoTreeStructure.validateCache();
        this.updateTree(false);
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, pathsToExpand, pathsToSelect, (boolean)true);
    }

    void setTodoFilter(TodoFilter filter) {
        this.getTodoTreeStructure().setTodoFilter(filter);
        try {
            this.rebuildCache();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        this.updateTree(false);
    }

    public TodoItemNode getNextPointer(TodoItemNode pointer) {
        Object sibling = this.getNextSibling(pointer);
        if (sibling == null) {
            return null;
        }
        if (sibling instanceof TodoItemNode) {
            return (TodoItemNode)sibling;
        }
        return this.getFirstPointerForElement(sibling);
    }

    Object getNextSibling(Object obj) {
        Object parent = this.getTreeStructure().getParentElement(obj);
        if (parent == null) {
            return null;
        }
        Object[] children2 = this.getTreeStructure().getChildElements(parent);
        Arrays.sort(children2, this.getUi().getNodeDescriptorComparator());
        int idx = -1;
        for (int i2 = 0; i2 < children2.length; ++i2) {
            if (!obj.equals(children2[i2])) continue;
            idx = i2;
            break;
        }
        if (idx == -1) {
            return null;
        }
        if (idx < children2.length - 1) {
            return children2[idx + 1];
        }
        return this.getNextSibling(parent);
    }

    public TodoItemNode getPreviousPointer(TodoItemNode pointer) {
        Object sibling = this.getPreviousSibling(pointer);
        if (sibling == null) {
            return null;
        }
        if (sibling instanceof TodoItemNode) {
            return (TodoItemNode)sibling;
        }
        return this.getLastPointerForElement(sibling);
    }

    Object getPreviousSibling(Object obj) {
        Object parent = this.getTreeStructure().getParentElement(obj);
        if (parent == null) {
            return null;
        }
        Object[] children2 = this.getTreeStructure().getChildElements(parent);
        Arrays.sort(children2, this.getUi().getNodeDescriptorComparator());
        int idx = -1;
        for (int i2 = 0; i2 < children2.length; ++i2) {
            if (!obj.equals(children2[i2])) continue;
            idx = i2;
            break;
        }
        if (idx == -1) {
            return null;
        }
        if (idx > 0) {
            return children2[idx - 1];
        }
        return this.getPreviousSibling(parent);
    }

    public EditorHighlighter getHighlighter(PsiFile psiFile, Document document) {
        VirtualFile file2 = psiFile.getVirtualFile();
        if (this.myFile2Highlighter.containsKey((Object)file2)) {
            return (EditorHighlighter)this.myFile2Highlighter.get((Object)file2);
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((EditorColorsScheme)UsageTreeColorsScheme.getInstance().getScheme(), (String)file2.getName(), (Project)this.myProject);
        highlighter.setText(document.getCharsSequence());
        this.myFile2Highlighter.put((Object)file2, (Object)highlighter);
        return highlighter;
    }

    void setShowModules(boolean state) {
        this.getTodoTreeStructure().setShownModules(state);
        ArrayList pathsToExpand = new ArrayList();
        ArrayList pathsToSelect = new ArrayList();
        TreeBuilderUtil.storePaths((AbstractTreeBuilder)this, (DefaultMutableTreeNode)this.getRootNode(), pathsToExpand, pathsToSelect, (boolean)true);
        this.getTree().clearSelection();
        this.getTodoTreeStructure().validateCache();
        this.updateTree(false);
        TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this, pathsToExpand, pathsToSelect, (boolean)true);
    }

    public boolean isDirectoryEmpty(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/intellij/ide/todo/TodoTreeBuilder", "isDirectoryEmpty"));
        }
        return this.myFileTree.isDirectoryEmpty(psiDirectory.getVirtualFile());
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StatusBarProgress statusBarProgress = new StatusBarProgress();
        if (statusBarProgress == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/TodoTreeBuilder", "createProgressIndicator"));
        }
        return statusBarProgress;
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            TodoTreeBuilder.this.updateTree(true);
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/todo/TodoTreeBuilder$MyFileStatusListener", "fileStatusChanged"));
            }
            PsiFile psiFile = PsiManager.getInstance((Project)TodoTreeBuilder.this.myProject).findFile(virtualFile);
            if (psiFile != null && TodoTreeBuilder.this.canContainTodoItems(psiFile)) {
                TodoTreeBuilder.this.updateTree(true);
            }
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoTreeBuilder$MyPsiTreeChangeListener", "childAdded"));
            }
            if (e.getFile() != null) {
                TodoTreeBuilder.this.markFileAsDirty(e.getFile());
                TodoTreeBuilder.this.updateTree(true);
                return;
            }
            PsiElement child = e.getChild();
            if (!(child instanceof PsiFile)) {
                return;
            }
            PsiFile psiFile = (PsiFile)e.getChild();
            TodoTreeBuilder.this.markFileAsDirty(psiFile);
            TodoTreeBuilder.this.updateTree(true);
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoTreeBuilder$MyPsiTreeChangeListener", "beforeChildRemoval"));
            }
            PsiFile file2 = e.getFile();
            if (file2 != null) {
                TodoTreeBuilder.this.markFileAsDirty(file2);
                TodoTreeBuilder.this.updateTree(true);
                return;
            }
            PsiElement child = e.getChild();
            if (child instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)child;
                TodoTreeBuilder.this.markFileAsDirty(psiFile);
                TodoTreeBuilder.this.updateTree(true);
            } else if (child instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)child;
                Iterator<PsiFile> i2 = TodoTreeBuilder.this.getAllFiles();
                while (i2.hasNext()) {
                    PsiFile psiFile = i2.next();
                    if (psiFile == null || !PsiTreeUtil.isAncestor((PsiElement)psiDirectory, (PsiElement)psiFile, (boolean)true)) continue;
                    TodoTreeBuilder.this.markFileAsDirty(psiFile);
                }
                TodoTreeBuilder.this.updateTree(true);
            } else if (PsiTreeUtil.getParentOfType((PsiElement)child, PsiComment.class, (boolean)false) != null) {
                TodoTreeBuilder.this.markFileAsDirty(child.getContainingFile());
                TodoTreeBuilder.this.updateTree(true);
            }
        }

        public void childMoved(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoTreeBuilder$MyPsiTreeChangeListener", "childMoved"));
            }
            if (e.getFile() != null) {
                TodoTreeBuilder.this.markFileAsDirty(e.getFile());
                TodoTreeBuilder.this.updateTree(true);
                return;
            }
            if (e.getChild() instanceof PsiFile) {
                PsiFile psiFile = (PsiFile)e.getChild();
                if (!TodoTreeBuilder.this.canContainTodoItems(psiFile)) {
                    return;
                }
                TodoTreeBuilder.this.markFileAsDirty(psiFile);
                TodoTreeBuilder.this.updateTree(true);
            } else if (e.getChild() instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)e.getChild();
                boolean shouldUpdate = false;
                Iterator<PsiFile> i2 = TodoTreeBuilder.this.getAllFiles();
                while (i2.hasNext()) {
                    PsiFile psiFile = i2.next();
                    if (psiFile == null || !PsiTreeUtil.isAncestor((PsiElement)psiDirectory, (PsiElement)psiFile, (boolean)true)) continue;
                    TodoTreeBuilder.this.markFileAsDirty(psiFile);
                    shouldUpdate = true;
                }
                if (shouldUpdate) {
                    TodoTreeBuilder.this.updateTree(true);
                }
            }
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoTreeBuilder$MyPsiTreeChangeListener", "childReplaced"));
            }
            if (e.getFile() != null) {
                TodoTreeBuilder.this.markFileAsDirty(e.getFile());
                TodoTreeBuilder.this.updateTree(true);
            }
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoTreeBuilder$MyPsiTreeChangeListener", "childrenChanged"));
            }
            if (e.getFile() != null) {
                TodoTreeBuilder.this.markFileAsDirty(e.getFile());
                TodoTreeBuilder.this.updateTree(true);
            }
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
            PsiDirectory psiDirectory;
            Iterator<PsiFile> iterator;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoTreeBuilder$MyPsiTreeChangeListener", "propertyChanged"));
            }
            String propertyName = e.getPropertyName();
            if (propertyName.equals("roots")) {
                TodoTreeBuilder.this.getUpdater().runBeforeUpdate(() -> DumbService.getInstance((Project)TodoTreeBuilder.this.myProject).runWhenSmart(() -> TodoTreeBuilder.this.rebuildCache()));
                TodoTreeBuilder.this.updateTree(true);
            } else if ("writable".equals(propertyName) || "fileName".equals(propertyName)) {
                PsiFile psiFile = (PsiFile)e.getElement();
                if (!TodoTreeBuilder.this.canContainTodoItems(psiFile)) {
                    return;
                }
                TodoTreeBuilder.this.updateTree(true);
            } else if ("directoryName".equals(propertyName) && (iterator = TodoTreeBuilder.this.getFiles(psiDirectory = (PsiDirectory)e.getElement())).hasNext()) {
                TodoTreeBuilder.this.updateTree(true);
            }
        }
    }

    private static final class MyComparator
    implements Comparator<NodeDescriptor> {
        public static final Comparator<NodeDescriptor> ourInstance = new MyComparator();

        private MyComparator() {
        }

        @Override
        public int compare(NodeDescriptor descriptor1, NodeDescriptor descriptor2) {
            int weight2;
            int weight1 = descriptor1.getWeight();
            if (weight1 != (weight2 = descriptor2.getWeight())) {
                return weight1 - weight2;
            }
            return descriptor1.getIndex() - descriptor2.getIndex();
        }
    }
}

