/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.impl.java.AccessLevelProvider;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ui.UIUtil;

public abstract class JavaClassTreeElementBase<Value extends PsiElement>
extends PsiTreeElementBase<Value>
implements AccessLevelProvider,
ColoredItemPresentation,
LocationPresentation {
    private final boolean myIsInherited;
    protected String myLocation;

    protected JavaClassTreeElementBase(boolean isInherited, Value element) {
        super(element);
        this.myIsInherited = isInherited;
    }

    public boolean isInherited() {
        return this.myIsInherited;
    }

    public boolean isPublic() {
        Object element = this.getElement();
        return !(element instanceof PsiModifierListOwner) || ((PsiModifierListOwner)element).hasModifierProperty("public");
    }

    @Override
    public int getAccessLevel() {
        Object element = this.getElement();
        if (!(element instanceof PsiModifierListOwner)) {
            return 4;
        }
        PsiModifierList modifierList = ((PsiModifierListOwner)element).getModifierList();
        if (modifierList == null) {
            return 4;
        }
        return PsiUtil.getAccessLevel((PsiModifierList)modifierList);
    }

    @Override
    public int getSubLevel() {
        return 0;
    }

    @Override
    public String getLocationString() {
        if (!Registry.is((String)"show.method.base.class.in.java.file.structure")) {
            return null;
        }
        if (this.isInherited()) {
            if (this.myLocation == null) {
                Object element = this.getElement();
                if (element instanceof PsiMember) {
                    PsiClass cls = ((PsiMember)element).getContainingClass();
                    if (cls == null) {
                        this.myLocation = "";
                    } else {
                        this.myLocation = cls.getName();
                        this.myLocation = UIUtil.rightArrow() + this.myLocation;
                    }
                } else {
                    this.myLocation = "";
                }
            }
            return StringUtil.isEmpty((String)this.myLocation) ? null : this.myLocation;
        }
        return super.getLocationString();
    }

    public String getLocationPrefix() {
        return this.isInherited() ? " " : " (";
    }

    public String getLocationSuffix() {
        return this.isInherited() ? "" : ")";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JavaClassTreeElementBase that = (JavaClassTreeElementBase)o;
        return this.myIsInherited == that.myIsInherited;
    }

    public TextAttributesKey getTextAttributesKey() {
        try {
            return this.isDeprecated() ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null;
        }
        catch (IndexNotReadyException ignore) {
            return null;
        }
    }

    private boolean isDeprecated() {
        Object element = this.getElement();
        return element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated();
    }
}

