/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.StatePreservingNavigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPsiBasedNode<Value>
extends ProjectViewNode<Value>
implements ValidateableNode,
StatePreservingNavigatable {
    private static final Logger LOG = Logger.getInstance((String)AbstractPsiBasedNode.class.getName());

    protected AbstractPsiBasedNode(Project project2, Value value, ViewSettings viewSettings) {
        super(project2, value, viewSettings);
    }

    @Nullable
    protected abstract PsiElement extractPsiFromValue();

    @Nullable
    protected abstract Collection<AbstractTreeNode> getChildrenImpl();

    protected abstract void updateImpl(PresentationData var1);

    @NotNull
    public final Collection<AbstractTreeNode> getChildren() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            ArrayList<AbstractTreeNode> arrayList = new ArrayList<AbstractTreeNode>();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode", "getChildren"));
            }
            return arrayList;
        }
        boolean valid = psiElement.isValid();
        if (!LOG.assertTrue(valid)) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode", "getChildren"));
            }
            return list;
        }
        Collection<AbstractTreeNode> children2 = this.getChildrenImpl();
        Collection<Object> collection = children2 != null ? children2 : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode", "getChildren"));
        }
        return collection;
    }

    public boolean isValid() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement != null && psiElement.isValid();
    }

    protected boolean isMarkReadOnly() {
        AbstractTreeNode parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof AbstractPsiBasedNode) {
            PsiElement psiElement = ((AbstractPsiBasedNode)parent).extractPsiFromValue();
            return psiElement instanceof PsiDirectory;
        }
        Object parentValue = parent.getValue();
        return parentValue instanceof PsiDirectory || parentValue instanceof Module;
    }

    public FileStatus getFileStatus() {
        VirtualFile file2 = this.getVirtualFileForValue();
        if (file2 == null) {
            return FileStatus.NOT_CHANGED;
        }
        return FileStatusManager.getInstance((Project)this.getProject()).getStatus(file2);
    }

    @Nullable
    private VirtualFile getVirtualFileForValue() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null) {
            return null;
        }
        return PsiUtilBase.getVirtualFile((PsiElement)psiElement);
    }

    public void update(PresentationData data) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!this.validate()) {
                return;
            }
            PsiElement value = this.extractPsiFromValue();
            LOG.assertTrue(value.isValid());
            int flags = this.getIconableFlags();
            try {
                Icon icon = value.getIcon(flags);
                data.setIcon(icon);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            data.setPresentableText(this.myName);
            try {
                if (this.isDeprecated()) {
                    data.setAttributesKey(CodeInsightColors.DEPRECATED_ATTRIBUTES);
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            this.updateImpl(data);
            data.setIcon(AbstractPsiBasedNode.patchIcon(this.myProject, data.getIcon(true), this.getVirtualFile()));
            for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)this.myProject)) {
                decorator.decorate(this, data);
            }
        });
    }

    @Iconable.IconFlags
    protected int getIconableFlags() {
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        return flags;
    }

    @Nullable
    public static Icon patchIcon(@NotNull Project project2, @Nullable Icon original, @Nullable VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode", "patchIcon"));
        }
        if (file2 == null || original == null) {
            return original;
        }
        Icon icon = original;
        Bookmark bookmarkAtFile = BookmarkManager.getInstance(project2).findFileBookmark(file2);
        if (bookmarkAtFile != null) {
            RowIcon composite = new RowIcon(2, RowIcon.Alignment.CENTER);
            composite.setIcon(icon, 0);
            composite.setIcon(bookmarkAtFile.getIcon(), 1);
            icon = composite;
        }
        if (!file2.isWritable()) {
            icon = LayeredIcon.create((Icon)icon, (Icon)PlatformIcons.LOCKED_ICON);
        }
        if (file2.is(VFileProperty.SYMLINK)) {
            icon = LayeredIcon.create((Icon)icon, (Icon)PlatformIcons.SYMLINK_ICON);
        }
        return icon;
    }

    protected boolean isDeprecated() {
        return false;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode", "contains"));
        }
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile valueFile = containingFile.getVirtualFile();
        return valueFile != null && file2.equals(valueFile);
    }

    @Nullable
    public NavigationItem getNavigationItem() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement instanceof NavigationItem ? (NavigationItem)psiElement : null;
    }

    public void navigate(boolean requestFocus, boolean preserveState) {
        if (this.canNavigate()) {
            if (requestFocus || preserveState) {
                NavigationUtil.openFileWithPsiElement(this.extractPsiFromValue(), requestFocus, requestFocus);
            } else {
                this.getNavigationItem().navigate(requestFocus);
            }
        }
    }

    public void navigate(boolean requestFocus) {
        this.navigate(requestFocus, false);
    }

    public boolean canNavigate() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigate();
    }

    public boolean canNavigateToSource() {
        NavigationItem item = this.getNavigationItem();
        return item != null && item.canNavigateToSource();
    }

    @Nullable
    protected String calcTooltip() {
        return null;
    }

    public boolean validate() {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            this.setValue(null);
        }
        return this.getValue() != null;
    }
}

