/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.dataRules;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageDataUtil;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileArrayRule
implements GetDataRule {
    @Nullable
    private static Set<VirtualFile> addFiles(@Nullable Set<VirtualFile> set2, VirtualFile[] files) {
        for (VirtualFile file2 : files) {
            set2 = VirtualFileArrayRule.addFile(set2, file2);
        }
        return set2;
    }

    @Nullable
    private static Set<VirtualFile> addFile(@Nullable Set<VirtualFile> set2, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return set2;
        }
        if (set2 == null) {
            set2 = ContainerUtil.newLinkedHashSet();
        }
        set2.add(file2);
        return set2;
    }

    @Override
    public Object getData(DataProvider dataProvider) {
        PsiElement[] psiElements;
        Module selectedModule;
        Module[] selectedModules;
        Project project2;
        Set<VirtualFile> result2 = null;
        FileSystemTree fileSystemTree = (FileSystemTree)FileSystemTree.DATA_KEY.getData(dataProvider);
        if (fileSystemTree != null) {
            result2 = VirtualFileArrayRule.addFiles(result2, fileSystemTree.getSelectedFiles());
        }
        if ((project2 = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataProvider)) != null && !project2.isDisposed()) {
            result2 = VirtualFileArrayRule.addFiles(result2, ProjectRootManager.getInstance((Project)project2).getContentRoots());
        }
        if ((selectedModules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataProvider)) != null && selectedModules.length > 0) {
            for (Module selectedModule2 : selectedModules) {
                result2 = VirtualFileArrayRule.addFiles(result2, ModuleRootManager.getInstance((Module)selectedModule2).getContentRoots());
            }
        }
        if ((selectedModule = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataProvider)) != null && !selectedModule.isDisposed()) {
            result2 = VirtualFileArrayRule.addFiles(result2, ModuleRootManager.getInstance((Module)selectedModule).getContentRoots());
        }
        if ((psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataProvider)) != null) {
            for (PsiElement element : psiElements) {
                result2 = VirtualFileArrayRule.addFilesFromPsiElement(result2, element);
            }
        }
        result2 = VirtualFileArrayRule.addFile(result2, (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataProvider));
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataProvider);
        if (psiFile != null) {
            result2 = VirtualFileArrayRule.addFile(result2, psiFile.getVirtualFile());
        }
        if (result2 != null) {
            return VfsUtilCore.toVirtualFileArray(result2);
        }
        PsiElement elem = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataProvider);
        if (elem != null) {
            result2 = VirtualFileArrayRule.addFilesFromPsiElement(result2, elem);
        }
        Usage[] usages = (Usage[])UsageView.USAGES_KEY.getData(dataProvider);
        UsageTarget[] usageTargets = (UsageTarget[])UsageView.USAGE_TARGETS_KEY.getData(dataProvider);
        if (usages != null || usageTargets != null) {
            for (VirtualFile file2 : UsageDataUtil.provideVirtualFileArray((Usage[])usages, (UsageTarget[])usageTargets)) {
                result2 = VirtualFileArrayRule.addFile(result2, file2);
            }
        }
        if (result2 == null) {
            Object[] objects = (Object[])dataProvider.getData(PlatformDataKeys.SELECTED_ITEMS.getName());
            if (objects != null) {
                VirtualFile[] files = new VirtualFile[objects.length];
                for (Object object : objects) {
                    if (!(object instanceof VirtualFile)) {
                        return null;
                    }
                    files[i] = (VirtualFile)object;
                }
                return files;
            }
            return null;
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    private static Set<VirtualFile> addFilesFromPsiElement(Set<VirtualFile> files, @NotNull PsiElement elem) {
        if (elem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/ide/impl/dataRules/VirtualFileArrayRule", "addFilesFromPsiElement"));
        }
        if (elem instanceof PsiDirectory) {
            files = VirtualFileArrayRule.addFile(files, ((PsiDirectory)elem).getVirtualFile());
        } else if (elem instanceof PsiFile) {
            files = VirtualFileArrayRule.addFile(files, ((PsiFile)elem).getVirtualFile());
        } else if (elem instanceof PsiDirectoryContainer) {
            for (PsiDirectory dir : ((PsiDirectoryContainer)elem).getDirectories()) {
                files = VirtualFileArrayRule.addFile(files, dir.getVirtualFile());
            }
        } else {
            PsiFile file2 = elem.getContainingFile();
            if (file2 != null) {
                files = VirtualFileArrayRule.addFile(files, file2.getVirtualFile());
            }
        }
        return files;
    }
}

