/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectUtil {
    private static final Logger LOG = Logger.getInstance(NewProjectUtil.class);

    private NewProjectUtil() {
    }

    public static void createNewProject(Project projectToClose, AbstractProjectWizard wizard) {
        boolean proceed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ProjectManager.getInstance().getDefaultProject(), ProjectBundle.message((String)"project.new.wizard.progress.title", (Object[])new Object[0]), true, null);
        if (!proceed) {
            return;
        }
        if (!wizard.showAndGet()) {
            return;
        }
        NewProjectUtil.createFromWizard(wizard, projectToClose);
    }

    public static Project createFromWizard(AbstractProjectWizard dialog2, Project projectToClose) {
        try {
            return NewProjectUtil.doCreate(dialog2, projectToClose);
        }
        catch (IOException e) {
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((String)e.getMessage(), (String)"Project Initialization Failed"));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Project doCreate(AbstractProjectWizard dialog2, @Nullable Project projectToClose) throws IOException {
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        String projectFilePath = dialog2.getNewProjectFilePath();
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject(projectFilePath, p)) continue;
            ProjectUtil.focusProjectWindow(p, false);
            return null;
        }
        ProjectBuilder projectBuilder = dialog2.getProjectBuilder();
        try {
            Project newProject;
            String name;
            File projectDir = new File(projectFilePath).getParentFile();
            LOG.assertTrue(projectDir != null, (Object)("Cannot create project in '" + projectFilePath + "': no parent file exists"));
            FileUtil.ensureExists((File)projectDir);
            if (StorageScheme.DIRECTORY_BASED == dialog2.getStorageScheme()) {
                FileUtil.ensureExists((File)new File(projectFilePath, ".idea"));
            }
            if (projectBuilder == null || !projectBuilder.isUpdate()) {
                name = dialog2.getProjectName();
                newProject = projectBuilder == null ? projectManager.newProject(name, projectFilePath, true, false) : projectBuilder.createProject(name, projectFilePath);
            } else {
                newProject = projectToClose;
            }
            if (newProject == null) {
                name = projectToClose;
                return name;
            }
            Sdk jdk2 = dialog2.getNewProjectJdk();
            if (jdk2 != null) {
                CommandProcessor.getInstance().executeCommand(newProject, () -> ApplicationManager.getApplication().runWriteAction(() -> NewProjectUtil.applyJdkToProject(newProject, jdk2)), null, null);
            }
            String compileOutput = dialog2.getNewCompileOutput();
            CommandProcessor.getInstance().executeCommand(newProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                String canonicalPath = compileOutput;
                try {
                    canonicalPath = FileUtil.resolveShortWindowsName((String)compileOutput);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                canonicalPath = FileUtil.toSystemIndependentName((String)canonicalPath);
                CompilerProjectExtension.getInstance((Project)newProject).setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)canonicalPath));
            }), null, null);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                newProject.save();
            }
            if (projectBuilder != null && !projectBuilder.validate(projectToClose, newProject)) {
                Project project2 = projectToClose;
                return project2;
            }
            if (newProject != projectToClose && !ApplicationManager.getApplication().isUnitTestMode()) {
                NewProjectUtil.closePreviousProject(projectToClose);
            }
            if (projectBuilder != null) {
                projectBuilder.commit(newProject, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            boolean need2OpenProjectStructure = projectBuilder == null || projectBuilder.isOpenProjectSettingsAfter();
            StartupManager.getInstance((Project)newProject).registerPostStartupActivity(() -> ApplicationManager.getApplication().invokeLater(() -> {
                if (newProject.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                if (need2OpenProjectStructure) {
                    ModulesConfigurator.showDialog(newProject, null, null);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (newProject.isDisposed()) {
                        return;
                    }
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)newProject).getToolWindow(ToolWindowId.PROJECT_VIEW);
                    if (toolWindow != null) {
                        toolWindow.activate(null);
                    }
                }, ModalityState.NON_MODAL);
            }, ModalityState.NON_MODAL));
            if (newProject != projectToClose) {
                boolean fullScreen;
                IdeFocusManager instance;
                IdeFrame lastFocusedFrame;
                ProjectUtil.updateLastProjectLocation(projectFilePath);
                if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
                    newProject.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
                }
                projectManager.openProject(newProject);
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                newProject.save();
            }
            Project project3 = newProject;
            return project3;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    public static void applyJdkToProject(@NotNull Project project2, @NotNull Sdk jdk2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/NewProjectUtil", "applyJdkToProject"));
        }
        if (jdk2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/ide/impl/NewProjectUtil", "applyJdkToProject"));
        }
        ProjectRootManagerEx rootManager = ProjectRootManagerEx.getInstanceEx((Project)project2);
        rootManager.setProjectSdk(jdk2);
        JavaSdkVersion version = JavaSdk.getInstance().getVersion(jdk2);
        if (version != null) {
            LanguageLevel maxLevel = version.getMaxLanguageLevel();
            LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
            LanguageLevelProjectExtension ext = LanguageLevelProjectExtension.getInstance((Project)project2);
            if (extension.isDefault() || maxLevel.compareTo((Enum)ext.getLanguageLevel()) < 0) {
                ext.setLanguageLevel(maxLevel);
            }
        }
    }

    public static void closePreviousProject(Project projectToClose) {
        int exitCode;
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length > 0 && (exitCode = ProjectUtil.confirmOpenNewProject(true)) == 1) {
            ProjectUtil.closeAndDispose(projectToClose != null ? projectToClose : openProjects[openProjects.length - 1]);
        }
    }
}

