/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.customize.IdSet;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.PlatformImplIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.Nullable;

public class PluginGroups {
    static final String CORE = "Core";
    private static final int MAX_DESCR_LENGTH = 55;
    public static final String IDEA_VIM_PLUGIN_ID = "IdeaVIM";
    final Map<String, Pair<Icon, List<String>>> myTree = new LinkedHashMap<String, Pair<Icon, List<String>>>();
    final Map<String, String> myFeaturedPlugins = new LinkedHashMap<String, String>();
    private final Map<String, List<IdSet>> myGroups = new LinkedHashMap<String, List<IdSet>>();
    private final Map<String, String> myDescriptions = new LinkedHashMap<String, String>();
    private final List<IdeaPluginDescriptor> myPluginsFromRepository = new ArrayList<IdeaPluginDescriptor>();
    private Collection<String> myDisabledPluginIds = new HashSet<String>();
    private IdeaPluginDescriptor[] myAllPlugins;
    private boolean myInitialized = false;
    private Set<String> myFeaturedIds = new HashSet<String>();
    private Runnable myLoadingCallback = null;

    public PluginGroups() {
        this.myAllPlugins = PluginManagerCore.loadDescriptors(null, ContainerUtil.newArrayList());
        SwingWorker<List<IdeaPluginDescriptor>, Object> worker = new SwingWorker<List<IdeaPluginDescriptor>, Object>(){

            @Override
            protected List<IdeaPluginDescriptor> doInBackground() throws Exception {
                try {
                    return RepositoryHelper.loadPlugins(null);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }

            @Override
            protected void done() {
                block5: {
                    try {
                        PluginGroups.this.myPluginsFromRepository.addAll((Collection)this.get());
                        if (PluginGroups.this.myLoadingCallback != null) {
                            PluginGroups.this.myLoadingCallback.run();
                        }
                    }
                    catch (InterruptedException e) {
                        if (PluginGroups.this.myLoadingCallback != null) {
                            PluginGroups.this.myLoadingCallback.run();
                        }
                    }
                    catch (ExecutionException e) {
                        if (PluginGroups.this.myLoadingCallback == null) break block5;
                        PluginGroups.this.myLoadingCallback.run();
                    }
                }
            }
        };
        worker.execute();
        PluginManagerCore.loadDisabledPlugins(new File(PathManager.getConfigPath()).getPath(), this.myDisabledPluginIds);
        this.initGroups(this.myTree, this.myFeaturedPlugins);
        this.initCloudPlugins();
    }

    public void setLoadingCallback(Runnable loadingCallback) {
        this.myLoadingCallback = loadingCallback;
        if (!this.myPluginsFromRepository.isEmpty()) {
            this.myLoadingCallback.run();
        }
    }

    private void initCloudPlugins() {
        CloudConfigProvider provider = CloudConfigProvider.getProvider();
        if (provider == null) {
            return;
        }
        List<String> plugins2 = provider.getInstalledPlugins();
        if (plugins2.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, String>> I = this.myFeaturedPlugins.entrySet().iterator();
        while (I.hasNext()) {
            String value = I.next().getValue();
            if (ContainerUtil.find(plugins2, plugin -> value.endsWith(":" + plugin)) == null) continue;
            I.remove();
        }
        for (String plugin2 : plugins2) {
            this.myFeaturedPlugins.put(plugin2, "#Cloud:#Cloud:" + plugin2);
        }
    }

    protected void initGroups(Map<String, Pair<Icon, List<String>>> tree, Map<String, String> featuredPlugins) {
        tree.put(CORE, (Pair<Icon, List<String>>)Pair.create((Object)null, Arrays.asList("com.intellij.copyright", "com.intellij.java-i18n", "org.intellij.intelliLang", "com.intellij.properties", "Refactor-X", "Type Migration", "ZKM")));
        tree.put("Java Frameworks", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.JavaFrameworks, Arrays.asList("com.intellij.appengine", "org.intellij.grails", "com.intellij.gwt", "com.intellij.vaadin", "JBoss Seam:com.intellij.seam,com.intellij.seam.pages,com.intellij.seam.pageflow", "JBoss jBPM:JBPM", "Struts:StrutsAssistant,com.intellij.struts2", "com.intellij.hibernate", "Spring:com.intellij.spring.batch,com.intellij.spring.data,com.intellij.spring.integration,com.intellij.spring.osgi,com.intellij.spring.security,com.intellij.spring,com.intellij.spring.webflow,com.intellij.spring.ws,com.intellij.aop", "Java EE:com.intellij.javaee.batch,com.intellij.beanValidation,com.intellij.cdi,com.intellij.javaee,com.intellij.jsf,com.intellij.javaee.extensions,com.jetbrains.restWebServices,Web Services (JAX-WS),com.intellij.javaee.webSocket,com.intellij.jsp,com.intellij.persistence", "com.intellij.freemarker", "com.intellij.tapestry", "com.intellij.velocity", "Guice", "com.intellij.aspectj", "Osmorc")));
        tree.put("Build Tools", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.BuildTools, Arrays.asList("AntSupport", "Maven:org.jetbrains.idea.maven,org.jetbrains.idea.maven.ext", "org.jetbrains.plugins.gradle")));
        tree.put("Web Development", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.WebDevelopment, Arrays.asList("HTML:HtmlTools,QuirksMode,W3Validators", "org.jetbrains.plugins.haml", "com.jetbrains.plugins.jade", "com.intellij.css", "org.jetbrains.plugins.less", "org.jetbrains.plugins.sass", "org.jetbrains.plugins.stylus", "JavaScript:JavaScript,JavaScriptDebugger,JSIntentionPowerPack", "org.coffeescript", "com.intellij.flex", "com.intellij.plugins.html.instantEditing", "com.jetbrains.restClient")));
        PluginGroups.addVcsGroup(tree);
        tree.put("Test Tools", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.TestTools, Arrays.asList("JUnit", "TestNG-J", "cucumber-java", "cucumber", "Coverage:Coverage,Emma")));
        tree.put("Application Servers", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.ApplicationServers, Arrays.asList("com.intellij.javaee.view", "Geronimo", "GlassFish", "JBoss", "Jetty", "Resin", "Tomcat", "Weblogic", "WebSphere", "com.intellij.dmserver", "JSR45Plugin")));
        tree.put("Clouds", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.Clouds, Arrays.asList("CloudFoundry", "CloudBees", "Heroku", "OpenShift")));
        tree.put("Swing", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.Swing, Arrays.asList("com.intellij.uiDesigner")));
        tree.put("Android", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.Android, Arrays.asList("org.jetbrains.android", "com.intellij.android-designer")));
        tree.put("Database Tools", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.DatabaseTools, Arrays.asList("com.intellij.database")));
        tree.put("Other Tools", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.OtherTools, Arrays.asList("ByteCodeViewer", "com.intellij.dsm", "org.jetbrains.idea.eclipse", "Remote Access:com.jetbrains.plugins.webDeployment,org.jetbrains.plugins.remote-run", "Task Management:com.intellij.tasks,com.intellij.tasks.timeTracking", "org.jetbrains.plugins.terminal", "com.intellij.diagram", "org.jetbrains.plugins.yaml", "XSLT and XPath:XPathView,XSLT-Debugger")));
        tree.put("Plugin Development", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.PluginDevelopment, Arrays.asList("DevKit")));
        featuredPlugins.put("Scala", "Custom Languages:Plugin for Scala language support:org.intellij.scala");
        featuredPlugins.put("Live Edit Tool", "Web Development:Provides live edit HTML/CSS/JavaScript:com.intellij.plugins.html.instantEditing");
        PluginGroups.addVimPlugin(featuredPlugins);
        featuredPlugins.put("NodeJS", "JavaScript:Node.js integration:NodeJS");
        featuredPlugins.put("Angular", "Web Development:Angular 1&2 support:AngularJS");
        featuredPlugins.put("Atlassian Connector", "Tools Integration:Integration for Atlassian JIRA, Bamboo, Crucible, FishEye:atlassian-idea-plugin");
    }

    public static void addVcsGroup(Map<String, Pair<Icon, List<String>>> tree) {
        tree.put("Version Controls", (Pair<Icon, List<String>>)Pair.create((Object)PlatformImplIcons.VersionControls, Arrays.asList("ClearcasePlugin", "CVS", "Git4Idea", "org.jetbrains.plugins.github", "hg4idea", "PerforceDirectPlugin", "Subversion", "TFS")));
    }

    public static void addVimPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("IdeaVim", "Editor:Emulates Vim editor:IdeaVIM");
    }

    public static void addLuaPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("Lua", "Custom Languages:Lua language support:Lua");
    }

    public static void addGoPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("Go", "Custom Languages:Go language support:ro.redeul.google.go");
    }

    public static void addMarkdownPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("Markdown", "Custom Languages:Markdown language support:org.intellij.plugins.markdown");
    }

    public static void addConfigurationServerPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("Configuration Server", "Team Work:Supports sharing settings between installations of IntelliJ Platform based products used by the same developer on different computers:IdeaServerPlugin");
    }

    public static void addTeamCityPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("TeamCity Integration", "Tools Integration:Integration with JetBrains TeamCity - innovative solution for continuous integration and build management:Jetbrains TeamCity Plugin");
    }

    private void initIfNeed() {
        if (this.myInitialized) {
            return;
        }
        this.myInitialized = true;
        for (Map.Entry<String, Pair<Icon, List<String>>> entry : this.myTree.entrySet()) {
            String group = entry.getKey();
            if (CORE.equals(group)) continue;
            ArrayList<IdSet> idSets = new ArrayList<IdSet>();
            StringBuilder description = new StringBuilder();
            for (String idDescription : (List)entry.getValue().getSecond()) {
                IdSet idSet = new IdSet(this, idDescription);
                String idSetTitle = idSet.getTitle();
                if (idSetTitle == null) continue;
                idSets.add(idSet);
                if (description.length() > 0) {
                    description.append(", ");
                }
                description.append(idSetTitle);
            }
            this.myGroups.put(group, idSets);
            if (description.length() > 55) {
                int lastWord = description.lastIndexOf(",", 55);
                description.delete(lastWord, description.length()).append("...");
            }
            description.insert(0, "<html><body><center><i>");
            this.myDescriptions.put(group, description.toString());
        }
    }

    Map<String, Pair<Icon, List<String>>> getTree() {
        this.initIfNeed();
        return this.myTree;
    }

    Map<String, String> getFeaturedPlugins() {
        this.initIfNeed();
        return this.myFeaturedPlugins;
    }

    public String getDescription(String group) {
        this.initIfNeed();
        return this.myDescriptions.get(group);
    }

    public List<IdSet> getSets(String group) {
        this.initIfNeed();
        return this.myGroups.get(group);
    }

    @Nullable
    IdeaPluginDescriptor findPlugin(String id) {
        for (IdeaPluginDescriptor pluginDescriptor : this.myAllPlugins) {
            PluginId pluginId = pluginDescriptor.getPluginId();
            if (pluginId == null || !StringUtil.equals((CharSequence)pluginId.getIdString(), (CharSequence)id)) continue;
            return pluginDescriptor;
        }
        return null;
    }

    boolean isIdSetAllEnabled(IdSet set2) {
        for (String id : set2.getIds()) {
            if (this.isPluginEnabled(id)) continue;
            return false;
        }
        return true;
    }

    void setIdSetEnabled(IdSet set2, boolean enabled) {
        for (String id : set2.getIds()) {
            this.setPluginEnabledWithDependencies(id, enabled);
        }
    }

    public Collection<String> getDisabledPluginIds() {
        return Collections.unmodifiableCollection(this.myDisabledPluginIds);
    }

    public List<IdeaPluginDescriptor> getPluginsFromRepository() {
        return this.myPluginsFromRepository;
    }

    boolean isPluginEnabled(String pluginId) {
        this.initIfNeed();
        return !this.myDisabledPluginIds.contains(pluginId);
    }

    IdSet getSet(String pluginId) {
        this.initIfNeed();
        for (List<IdSet> sets : this.myGroups.values()) {
            for (IdSet set2 : sets) {
                for (String id : set2.getIds()) {
                    if (!id.equals(pluginId)) continue;
                    return set2;
                }
            }
        }
        return null;
    }

    void setFeaturedPluginEnabled(String pluginId, boolean enabled) {
        if (enabled) {
            this.myFeaturedIds.add(pluginId);
        } else {
            this.myFeaturedIds.remove(pluginId);
        }
        WelcomeWizardUtil.setFeaturedPluginsToInstall(this.myFeaturedIds);
    }

    void setPluginEnabledWithDependencies(String pluginId, boolean enabled) {
        this.initIfNeed();
        HashSet<String> ids = new HashSet<String>();
        this.collectInvolvedIds(pluginId, enabled, ids);
        HashSet<IdSet> sets = new HashSet<IdSet>();
        for (String id : ids) {
            IdSet set2 = this.getSet(id);
            if (set2 == null) continue;
            sets.add(set2);
        }
        for (IdSet set3 : sets) {
            ids.addAll(Arrays.asList(set3.getIds()));
        }
        for (String id : ids) {
            if (enabled) {
                this.myDisabledPluginIds.remove(id);
                continue;
            }
            this.myDisabledPluginIds.add(id);
        }
    }

    private void collectInvolvedIds(String pluginId, boolean toEnable, Set<String> ids) {
        ids.add(pluginId);
        if (toEnable) {
            for (String id2 : this.getNonOptionalDependencies(pluginId)) {
                this.collectInvolvedIds(id2, true, ids);
            }
        } else {
            Condition condition = id -> pluginId.equals(id.getIdString());
            for (IdeaPluginDescriptor plugin : this.myAllPlugins) {
                if (null == ContainerUtil.find((Object[])plugin.getDependentPluginIds(), (Condition)condition) || null != ContainerUtil.find((Object[])plugin.getOptionalDependentPluginIds(), (Condition)condition)) continue;
                this.collectInvolvedIds(plugin.getPluginId().getIdString(), false, ids);
            }
        }
    }

    private List<String> getNonOptionalDependencies(String id) {
        ArrayList<String> result2 = new ArrayList<String>();
        IdeaPluginDescriptor descriptor = this.findPlugin(id);
        if (descriptor != null) {
            for (PluginId pluginId : descriptor.getDependentPluginIds()) {
                if (pluginId.getIdString().equals("com.intellij") || ArrayUtil.contains((Object)pluginId, (Object[])descriptor.getOptionalDependentPluginIds())) continue;
                result2.add(pluginId.getIdString());
            }
        }
        return result2;
    }
}

