/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.RetrievableIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Bookmark
implements Navigatable,
Comparable<Bookmark> {
    public static final Icon DEFAULT_ICON = new MyCheckedIcon();
    private final VirtualFile myFile;
    @NotNull
    private OpenFileDescriptor myTarget;
    private final Project myProject;
    private Reference<RangeHighlighterEx> myHighlighterRef;
    private String myDescription;
    private char myMnemonic;

    public Bookmark(@NotNull Project project2, @NotNull VirtualFile file2, int line, @NotNull String description) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/bookmarks/Bookmark", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/bookmarks/Bookmark", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/ide/bookmarks/Bookmark", "<init>"));
        }
        this.myMnemonic = '\u0000';
        this.myFile = file2;
        this.myProject = project2;
        this.myDescription = description;
        this.myTarget = new OpenFileDescriptor(project2, file2, line, -1, true);
        this.addHighlighter();
    }

    @NotNull
    public static Font getBookmarkFont() {
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        if (font == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/bookmarks/Bookmark", "getBookmarkFont"));
        }
        return font;
    }

    @Override
    public int compareTo(Bookmark o) {
        int i2;
        int n = this.myMnemonic != '\u0000' ? (o.myMnemonic != '\u0000' ? this.myMnemonic - o.myMnemonic : -1) : (i2 = o.myMnemonic != '\u0000' ? 1 : 0);
        if (i2 != 0) {
            return i2;
        }
        i2 = this.myProject.getName().compareTo(o.myProject.getName());
        if (i2 != 0) {
            return i2;
        }
        i2 = this.myFile.getName().compareTo(o.getFile().getName());
        if (i2 != 0) {
            return i2;
        }
        return this.getTarget().compareTo(o.getTarget());
    }

    public void updateHighlighter() {
        this.release();
        this.addHighlighter();
    }

    private void addHighlighter() {
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.getFile());
        if (document != null) {
            this.createHighlighter((MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myProject, true));
        }
    }

    public RangeHighlighter createHighlighter(@NotNull MarkupModelEx markup) {
        RangeHighlighterEx highlighter;
        if (markup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markup", "com/intellij/ide/bookmarks/Bookmark", "createHighlighter"));
        }
        int line = this.getLine();
        if (line >= 0) {
            highlighter = markup.addPersistentLineHighlighter(line, 5001, null);
            if (highlighter != null) {
                highlighter.setGutterIconRenderer(new MyGutterIconRenderer(this));
                TextAttributes textAttributes = (TextAttributes)ObjectUtils.notNull((Object)EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BOOKMARKS_ATTRIBUTES), (Object)new TextAttributes());
                Color stripeColor = (Color)ObjectUtils.notNull((Object)textAttributes.getErrorStripeColor(), (Object)new JBColor(0, 0xDBDBDB));
                highlighter.setErrorStripeMarkColor(stripeColor);
                highlighter.setErrorStripeTooltip(this.getBookmarkTooltip());
                TextAttributes attributes = highlighter.getTextAttributes();
                if (attributes == null) {
                    attributes = new TextAttributes();
                }
                attributes.setBackgroundColor(textAttributes.getBackgroundColor());
                attributes.setForegroundColor(textAttributes.getForegroundColor());
                highlighter.setTextAttributes(attributes);
            }
        } else {
            highlighter = null;
        }
        this.myHighlighterRef = highlighter == null ? null : new WeakReference<RangeHighlighterEx>(highlighter);
        return highlighter;
    }

    @Nullable
    public Document getDocument() {
        return FileDocumentManager.getInstance().getCachedDocument(this.getFile());
    }

    public void release() {
        int line = this.getLine();
        if (line < 0) {
            return;
        }
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myProject, true);
        Document markupDocument = markup.getDocument();
        if (markupDocument.getLineCount() <= line) {
            return;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null) {
            this.myHighlighterRef = null;
            highlighter.dispose();
        }
    }

    private RangeHighlighterEx findMyHighlighter() {
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        RangeHighlighterEx result2 = (RangeHighlighterEx)SoftReference.dereference(this.myHighlighterRef);
        if (result2 != null) {
            return result2;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myProject, true);
        Document markupDocument = markup.getDocument();
        boolean startOffset = false;
        int endOffset = markupDocument.getTextLength();
        Ref found = new Ref();
        markup.processRangeHighlightersOverlappingWith(0, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
            if (renderer instanceof MyGutterIconRenderer && ((MyGutterIconRenderer)renderer).myBookmark == this) {
                found.set(highlighter);
                return false;
            }
            return true;
        }));
        result2 = (RangeHighlighterEx)found.get();
        this.myHighlighterRef = result2 == null ? null : new WeakReference<RangeHighlighterEx>(result2);
        return result2;
    }

    public Icon getIcon() {
        return this.myMnemonic == '\u0000' ? DEFAULT_ICON : MnemonicIcon.getIcon(this.myMnemonic);
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public char getMnemonic() {
        return this.myMnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.myMnemonic = Character.toUpperCase(mnemonic);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/bookmarks/Bookmark", "getFile"));
        }
        return virtualFile;
    }

    @Nullable
    public String getNotEmptyDescription() {
        return StringUtil.isEmpty((String)this.myDescription) ? null : this.myDescription;
    }

    public boolean isValid() {
        if (!this.getFile().isValid()) {
            return false;
        }
        if (this.getLine() == -1) {
            return true;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        return highlighter != null && highlighter.isValid();
    }

    public boolean canNavigate() {
        return this.getTarget().canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getTarget().canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        this.getTarget().navigate(requestFocus);
    }

    public int getLine() {
        Document document;
        int targetLine = this.myTarget.getLine();
        if (targetLine == -1) {
            return targetLine;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null && highlighter.isValid() && (document = this.getDocument()) != null) {
            return document.getLineNumber(highlighter.getStartOffset());
        }
        RangeMarker marker = this.myTarget.getRangeMarker();
        if (marker != null && marker.isValid()) {
            Document document2 = marker.getDocument();
            return document2.getLineNumber(marker.getStartOffset());
        }
        return targetLine;
    }

    private OpenFileDescriptor getTarget() {
        int line = this.getLine();
        if (line != this.myTarget.getLine()) {
            this.myTarget = new OpenFileDescriptor(this.myProject, this.myFile, line, -1, true);
        }
        return this.myTarget;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder(this.getQualifiedName());
        String description = StringUtil.escapeXml((String)this.getNotEmptyDescription());
        if (description != null) {
            result2.append(": ").append(description);
        }
        return result2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQualifiedName() {
        String presentableUrl = this.myFile.getPresentableUrl();
        if (this.myFile.isDirectory()) {
            return presentableUrl;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (psiFile == null) {
            return presentableUrl;
        }
        StructureViewBuilder builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(psiFile);
        if (builder instanceof TreeBasedStructureViewBuilder) {
            ItemPresentation presentation;
            Object element;
            StructureViewModel model = ((TreeBasedStructureViewBuilder)builder).createStructureViewModel(null);
            try {
                element = model.getCurrentEditorElement();
            }
            finally {
                model.dispose();
            }
            if (element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
                presentableUrl = ((NavigationItem)element).getName() + " " + presentation.getLocationString();
            }
        }
        return IdeBundle.message((String)"bookmark.file.X.line.Y", (Object[])new Object[]{presentableUrl, this.getLine() + 1});
    }

    private String getBookmarkTooltip() {
        String description;
        StringBuilder result2 = new StringBuilder("Bookmark");
        if (this.myMnemonic != '\u0000') {
            result2.append(" ").append(this.myMnemonic);
        }
        if ((description = StringUtil.escapeXml((String)this.getNotEmptyDescription())) != null) {
            result2.append(": ").append(description);
        }
        return result2.toString();
    }

    private static boolean darkBackground() {
        Color gutterBackground = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        if (gutterBackground == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        return ColorUtil.isDark((Color)gutterBackground);
    }

    private static class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final Bookmark myBookmark;

        public MyGutterIconRenderer(@NotNull Bookmark bookmark) {
            if (bookmark == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bookmark", "com/intellij/ide/bookmarks/Bookmark$MyGutterIconRenderer", "<init>"));
            }
            this.myBookmark = bookmark;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myBookmark.getIcon();
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/bookmarks/Bookmark$MyGutterIconRenderer", "getIcon"));
            }
            return icon;
        }

        public String getTooltipText() {
            return this.myBookmark.getBookmarkTooltip();
        }

        public boolean equals(Object obj) {
            return obj instanceof MyGutterIconRenderer && Comparing.equal((String)this.getTooltipText(), (String)((MyGutterIconRenderer)((Object)obj)).getTooltipText()) && Comparing.equal((Object)this.getIcon(), (Object)((MyGutterIconRenderer)((Object)obj)).getIcon());
        }

        public int hashCode() {
            return this.getIcon().hashCode();
        }
    }

    private static class MyCheckedIcon
    implements Icon,
    RetrievableIcon {
        private MyCheckedIcon() {
        }

        @Nullable
        public Icon retrieveIcon() {
            return PlatformIcons.CHECK_ICON;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            (Bookmark.darkBackground() ? AllIcons.Actions.CheckedGrey : AllIcons.Actions.CheckedBlack).paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return PlatformIcons.CHECK_ICON.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return PlatformIcons.CHECK_ICON.getIconHeight();
        }
    }

    static class MnemonicIcon
    implements Icon {
        private static final MnemonicIcon[] cache = new MnemonicIcon[36];
        private final char myMnemonic;

        @NotNull
        static MnemonicIcon getIcon(char mnemonic) {
            int index = mnemonic - 48;
            if (index > 9) {
                index -= 7;
            }
            if (index < 0 || index > cache.length - 1) {
                MnemonicIcon mnemonicIcon = new MnemonicIcon(mnemonic);
                if (mnemonicIcon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/bookmarks/Bookmark$MnemonicIcon", "getIcon"));
                }
                return mnemonicIcon;
            }
            if (cache[index] == null) {
                MnemonicIcon.cache[index] = new MnemonicIcon(mnemonic);
            }
            MnemonicIcon mnemonicIcon = cache[index];
            if (mnemonicIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/bookmarks/Bookmark$MnemonicIcon", "getIcon"));
            }
            return mnemonicIcon;
        }

        private MnemonicIcon(char mnemonic) {
            this.myMnemonic = mnemonic;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            g.setColor((Color)new JBColor(() -> !Bookmark.darkBackground() ? new Color(0xFFFFCC) : new Color(6770995)));
            g.fillRect(x, y, width, height);
            g.setColor((Color)JBColor.GRAY);
            g.drawRect(x, y, width, height);
            g.setColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground());
            Font oldFont = g.getFont();
            g.setFont(Bookmark.getBookmarkFont());
            UIUtil.drawCenteredString((Graphics2D)((Graphics2D)g), (Rectangle)new Rectangle(x, y, width, height), (String)Character.toString(this.myMnemonic));
            g.setFont(oldFont);
        }

        @Override
        public int getIconWidth() {
            return DEFAULT_ICON.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return DEFAULT_ICON.getIconHeight();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MnemonicIcon that = (MnemonicIcon)o;
            return this.myMnemonic == that.myMnemonic;
        }

        public int hashCode() {
            return this.myMnemonic;
        }
    }
}

