/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.NonProjectScopeDisablerEP;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextFieldUI;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.ide.util.gotoByName.GotoSymbolModel2;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.LanguagePsiElementExternalizer;
import com.intellij.lang.PsiElementExternalizer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.Changeable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gradient;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereAction
extends AnAction
implements CustomComponentAction,
DumbAware,
DataProvider,
RightAlignedToolbarAction {
    public static final String SE_HISTORY_KEY = "SearchEverywhereHistoryKey";
    public static final int SEARCH_FIELD_COLUMNS = 25;
    private static final int MAX_CLASSES = 6;
    private static final int MAX_FILES = 6;
    private static final int MAX_RUN_CONFIGURATION = 6;
    private static final int MAX_TOOL_WINDOWS = 4;
    private static final int MAX_SYMBOLS = 6;
    private static final int MAX_SETTINGS = 5;
    private static final int MAX_ACTIONS = 5;
    private static final int MAX_STRUCTURE = 10;
    private static final int MAX_RECENT_FILES = 10;
    private static final int DEFAULT_MORE_STEP_COUNT = 15;
    public static final int MAX_SEARCH_EVERYWHERE_HISTORY = 50;
    public static final int MAX_TOP_HIT = 15;
    private static final Logger LOG = Logger.getInstance((String)("#" + SearchEverywhereAction.class.getName()));
    private MyListRenderer myRenderer;
    MySearchTextField myPopupField;
    private volatile GotoClassModel2 myClassModel;
    private volatile GotoFileModel myFileModel;
    private volatile GotoActionItemProvider myActionProvider;
    private volatile GotoSymbolModel2 mySymbolsModel;
    private Component myFocusComponent;
    private JBPopup myPopup;
    private Map<String, String> myConfigurables = new HashMap<String, String>();
    private Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)ApplicationManager.getApplication());
    private JBList myList;
    private JCheckBox myNonProjectCheckBox;
    private AnActionEvent myActionEvent;
    private Set<AnAction> myDisabledActions = new HashSet<AnAction>();
    private Component myContextComponent;
    private CalcThread myCalcThread;
    private static AtomicBoolean ourShiftIsPressed = new AtomicBoolean(false);
    private static AtomicBoolean showAll = new AtomicBoolean(false);
    private volatile ActionCallback myCurrentWorker = ActionCallback.DONE;
    private int myHistoryIndex = 0;
    boolean mySkipFocusGain = false;
    private volatile JBPopup myBalloon;
    private int myPopupActualWidth;
    private Component myFocusOwner;
    private ChooseByNamePopup myFileChooseByName;
    private ChooseByNamePopup myClassChooseByName;
    private ChooseByNamePopup mySymbolsChooseByName;
    private StructureViewModel myStructureModel;
    private Editor myEditor;
    private FileEditor myFileEditor;
    private PsiFile myFile;
    private HistoryItem myHistoryItem;

    public JComponent createCustomComponent(Presentation presentation) {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel();
        panel2.setOpaque(false);
        JBLabel label = new JBLabel(AllIcons.Actions.FindPlain){
            {
                this.enableEvents(16L);
                this.enableEvents(32L);
            }
        };
        panel2.add((Component)label, "Center");
        SearchEverywhereAction.initTooltip((JLabel)label);
        label.addMouseListener(new MouseAdapter((JLabel)label){
            final /* synthetic */ JLabel val$label;
            {
                this.val$label = jLabel;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SearchEverywhereAction.this.myBalloon != null) {
                    SearchEverywhereAction.this.myBalloon.cancel();
                }
                SearchEverywhereAction.this.myFocusOwner = IdeFocusManager.findInstance().getFocusOwner();
                this.val$label.setToolTipText(null);
                IdeTooltipManager.getInstance().hideCurrentNow(false);
                SearchEverywhereAction.this.actionPerformed(null, e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                    this.val$label.setIcon(AllIcons.Actions.Find);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                    this.val$label.setIcon(AllIcons.Actions.FindPlain);
                }
            }
        });
        return panel2;
    }

    private static Gradient getGradientColors() {
        return new Gradient((Color)new JBColor(6657010, 4214878), (Color)new JBColor(3043277, 3490135));
    }

    private void updateComponents() {
        this.myList = new JBList(new SearchListModel()){
            int lastKnownHeight;
            {
                this.lastKnownHeight = JBUI.scale((int)30);
            }

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height == -1) {
                    size.height = this.lastKnownHeight;
                } else {
                    this.lastKnownHeight = size.height;
                }
                return new Dimension(Math.max(((SearchEverywhereAction)SearchEverywhereAction.this).myBalloon.getSize().width, Math.min(size.width - 2, SearchEverywhereAction.getPopupMaxWidth())), SearchEverywhereAction.this.myList.isEmpty() ? JBUI.scale((int)30) : size.height);
            }

            public void clearSelection() {
            }

            public Object getSelectedValue() {
                try {
                    return super.getSelectedValue();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
        this.myRenderer = new MyListRenderer(this.myList);
        this.myList.setCellRenderer((ListCellRenderer)((Object)this.myRenderer));
        this.myList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                int i2 = SearchEverywhereAction.this.myList.locationToIndex(e.getPoint());
                if (i2 != -1) {
                    SearchEverywhereAction.this.mySkipFocusGain = true;
                    SearchEverywhereAction.this.getField().requestFocus();
                    SwingUtilities.invokeLater(() -> {
                        SearchEverywhereAction.this.myList.setSelectedIndex(i2);
                        SearchEverywhereAction.this.doNavigate(i2);
                    });
                }
            }
        });
        this.myNonProjectCheckBox = new JCheckBox();
        this.myNonProjectCheckBox.setOpaque(false);
        this.myNonProjectCheckBox.setAlignmentX(1.0f);
        this.myNonProjectCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (showAll.get() != SearchEverywhereAction.this.myNonProjectCheckBox.isSelected()) {
                    showAll.set(!showAll.get());
                    JTextField editor = (JTextField)UIUtil.findComponentOfType((JComponent)SearchEverywhereAction.this.myBalloon.getContent(), JTextField.class);
                    if (editor != null) {
                        String pattern = editor.getText();
                        SearchEverywhereAction.this.myAlarm.cancelAllRequests();
                        SearchEverywhereAction.this.myAlarm.addRequest(() -> {
                            if (editor.hasFocus()) {
                                SearchEverywhereAction.this.rebuildList(pattern);
                            }
                        }, 30);
                    }
                }
            }
        });
    }

    private static void initTooltip(JLabel label) {
        String shortcutText = SearchEverywhereAction.getShortcut();
        label.setToolTipText("<html><body>Search Everywhere<br/>Press <b>" + shortcutText + "</b> to access<br/> - Classes<br/> - Files<br/> - Tool Windows<br/> - Actions<br/> - Settings</body></html>");
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return null;
    }

    private static String getShortcut() {
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("SearchEverywhere");
        String shortcutText = shortcuts.length == 0 ? "Double " + (SystemInfo.isMac ? "\u21e7" : "Shift") : KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
        return shortcutText;
    }

    private void initSearchField(final MySearchTextField search) {
        JBTextField editor = search.getTextEditor();
        editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((JTextField)editor){
            final /* synthetic */ JTextField val$editor;
            {
                this.val$editor = jTextField;
            }

            protected void textChanged(DocumentEvent e) {
                String pattern = this.val$editor.getText();
                if (this.val$editor.hasFocus()) {
                    SearchEverywhereAction.this.rebuildList(pattern);
                }
            }
        });
        editor.addFocusListener(new FocusAdapter((JTextField)editor){
            final /* synthetic */ JTextField val$editor;
            {
                this.val$editor = jTextField;
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (SearchEverywhereAction.this.mySkipFocusGain) {
                    SearchEverywhereAction.this.mySkipFocusGain = false;
                    return;
                }
                String text = "";
                search.setText(text);
                search.getTextEditor().setForeground(UIUtil.getLabelForeground());
                this.val$editor.setColumns(25);
                SearchEverywhereAction.this.myFocusComponent = e.getOppositeComponent();
                SwingUtilities.invokeLater(() -> {
                    JComponent parent = (JComponent)this.val$editor.getParent();
                    parent.revalidate();
                    parent.repaint();
                });
                SearchEverywhereAction.this.rebuildList(text);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SearchEverywhereAction.this.myPopup instanceof AbstractPopup && SearchEverywhereAction.this.myPopup.isVisible() && (SearchEverywhereAction.this.myList == e.getOppositeComponent() || ((AbstractPopup)SearchEverywhereAction.this.myPopup).getPopupWindow() == e.getOppositeComponent())) {
                    return;
                }
                if (SearchEverywhereAction.this.myNonProjectCheckBox == e.getOppositeComponent()) {
                    SearchEverywhereAction.this.mySkipFocusGain = true;
                    this.val$editor.requestFocus();
                    return;
                }
                SearchEverywhereAction.this.onFocusLost();
            }
        });
    }

    private void jumpNextGroup(boolean forward) {
        int index = this.myList.getSelectedIndex();
        SearchListModel model = this.getModel();
        if (index >= 0) {
            int newIndex = forward ? model.next(index) : model.prev(index);
            this.myList.setSelectedIndex(newIndex);
            int more = model.next(newIndex) - 1;
            if (more < newIndex) {
                more = this.myList.getItemsCount() - 1;
            }
            ScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)more, (int)(forward ? 1 : -1));
            ScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)newIndex, (int)(forward ? 1 : -1));
        }
    }

    private SearchListModel getModel() {
        return (SearchListModel)this.myList.getModel();
    }

    private ActionCallback onFocusLost() {
        ActionCallback result2 = new ActionCallback();
        UIUtil.invokeLaterIfNeeded(() -> {
            try {
                if (this.myCalcThread != null) {
                    this.myCalcThread.cancel();
                }
                this.myAlarm.cancelAllRequests();
                if (this.myBalloon != null && !this.myBalloon.isDisposed() && this.myPopup != null && !this.myPopup.isDisposed()) {
                    this.myBalloon.cancel();
                    this.myPopup.cancel();
                }
                SwingUtilities.invokeLater(() -> ActionToolbarImpl.updateAllToolbarsImmediately());
            }
            finally {
                result2.setDone();
            }
        });
        return result2;
    }

    private SearchTextField getField() {
        return this.myPopupField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNavigate(int index) {
        String pattern;
        DataManager dataManager = DataManager.getInstance();
        if (dataManager == null) {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataManager.getDataContext((Component)this.getField().getTextEditor()));
        assert (project2 != null);
        SearchListModel model = this.getModel();
        if (this.isMoreItem(index)) {
            pattern = this.myPopupField.getText();
            WidgetID wid = null;
            if (index == model.moreIndex.classes) {
                wid = WidgetID.CLASSES;
            } else if (index == model.moreIndex.files) {
                wid = WidgetID.FILES;
            } else if (index == model.moreIndex.settings) {
                wid = WidgetID.SETTINGS;
            } else if (index == model.moreIndex.actions) {
                wid = WidgetID.ACTIONS;
            } else if (index == model.moreIndex.symbols) {
                wid = WidgetID.SYMBOLS;
            } else if (index == model.moreIndex.runConfigurations) {
                wid = WidgetID.RUN_CONFIGURATIONS;
            }
            if (wid != null) {
                WidgetID widgetID = wid;
                this.myCurrentWorker.doWhenProcessed(() -> {
                    this.myCalcThread = new CalcThread(project2, pattern, true);
                    this.myPopupActualWidth = 0;
                    this.myCurrentWorker = this.myCalcThread.insert(index, widgetID);
                });
                return;
            }
        }
        pattern = this.getField().getText();
        Object value = this.myList.getSelectedValue();
        SearchEverywhereAction.saveHistory(project2, pattern, value);
        IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent((Component)this.getField().getTextEditor());
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
        }
        if (value instanceof BooleanOptionDescription) {
            BooleanOptionDescription option;
            option.setOptionState(!(option = (BooleanOptionDescription)value).isOptionEnabled());
            this.myList.revalidate();
            this.myList.repaint();
            this.getField().requestFocus();
            return;
        }
        if (value instanceof OptionsTopHitProvider) {
            SwingUtilities.invokeLater(() -> this.getField().setText("#" + ((OptionsTopHitProvider)value).getId() + " "));
            return;
        }
        Runnable onDone = null;
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            if (value instanceof PsiElement) {
                onDone = () -> NavigationUtil.activateFileWithPsiElement((PsiElement)value, true);
                return;
            }
            if (SearchEverywhereAction.isVirtualFile(value)) {
                onDone = () -> OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{new OpenFileDescriptor(project2, (VirtualFile)value)});
                return;
            }
            if (SearchEverywhereAction.isActionValue(value) || SearchEverywhereAction.isSetting(value) || SearchEverywhereAction.isRunConfiguration(value)) {
                focusManager.requestDefaultFocus(true);
                Component comp = this.myContextComponent;
                AnActionEvent event = this.myActionEvent;
                IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> {
                    Component c = comp;
                    if (c == null) {
                        c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    }
                    if (SearchEverywhereAction.isRunConfiguration(value)) {
                        Executor executor;
                        ChooseRunConfigurationPopup.ItemWrapper itemWrapper = (ChooseRunConfigurationPopup.ItemWrapper)value;
                        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)ObjectUtils.tryCast(itemWrapper.getValue(), RunnerAndConfigurationSettings.class);
                        if (settings != null && (executor = this.findExecutor(settings)) != null) {
                            itemWrapper.perform(project2, executor, dataManager.getDataContext(c));
                        }
                    } else {
                        GotoActionAction.openOptionOrPerformAction(value, pattern, project2, c, event);
                        if (SearchEverywhereAction.isToolWindowAction(value)) {
                            return;
                        }
                    }
                });
                return;
            }
            if (value instanceof Navigatable) {
                onDone = () -> OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{(Navigatable)value});
                return;
            }
        }
        finally {
            token.finish();
            ActionCallback callback = this.onFocusLost();
            if (onDone != null) {
                callback.doWhenDone(onDone);
            }
        }
        focusManager.requestDefaultFocus(true);
    }

    private boolean isMoreItem(int index) {
        SearchListModel model = this.getModel();
        return index == model.moreIndex.classes || index == model.moreIndex.files || index == model.moreIndex.settings || index == model.moreIndex.actions || index == model.moreIndex.symbols || index == model.moreIndex.runConfigurations;
    }

    private void rebuildList(String pattern) {
        assert (EventQueue.isDispatchThread()) : "Must be EDT";
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.getField().getTextEditor()));
        assert (project2 != null);
        this.myRenderer.myProject = project2;
        Runnable run = () -> {
            this.myCalcThread = new CalcThread(project2, pattern, false);
            this.myPopupActualWidth = 0;
            this.myCurrentWorker = this.myCalcThread.start();
        };
        if (this.myCurrentWorker.isDone()) {
            this.myCurrentWorker.doWhenDone(run);
        } else {
            this.myCurrentWorker.doWhenRejected(run);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        this.actionPerformed(e, null);
    }

    public void actionPerformed(AnActionEvent e, MouseEvent me) {
        RelativePoint showPoint;
        Window wnd;
        if (this.myBalloon != null && this.myBalloon.isVisible()) {
            showAll.set(!showAll.get());
            this.myNonProjectCheckBox.setSelected(showAll.get());
            this.rebuildList(this.myPopupField.getText());
            return;
        }
        this.myCurrentWorker = ActionCallback.DONE;
        if (e != null) {
            this.myEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
            this.myFileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
            this.myFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        }
        if (e == null && this.myFocusOwner != null) {
            e = AnActionEvent.createFromAnAction((AnAction)this, (InputEvent)me, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext(this.myFocusOwner));
        }
        if (e == null) {
            return;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> LookupManager.getInstance(project2).hideActiveLookup());
        this.updateComponents();
        this.myContextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(e.getDataContext());
        Window window = wnd = this.myContextComponent != null ? SwingUtilities.windowForComponent(this.myContextComponent) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (wnd == null && this.myContextComponent instanceof Window) {
            wnd = (Window)this.myContextComponent;
        }
        if (wnd == null || wnd.getParent() != null) {
            return;
        }
        this.myActionEvent = e;
        if (this.myPopupField != null) {
            Disposer.dispose((Disposable)this.myPopupField);
        }
        this.myPopupField = new MySearchTextField();
        this.myPopupField.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SearchEverywhereAction.this.myHistoryIndex = 0;
                SearchEverywhereAction.this.myHistoryItem = null;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    SearchEverywhereAction.this.myList.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    SearchEverywhereAction.this.myList.repaint();
                }
            }
        });
        this.initSearchField(this.myPopupField);
        this.myPopupField.setOpaque(false);
        JBTextField editor = this.myPopupField.getTextEditor();
        editor.setColumns(25);
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                Gradient gradient = SearchEverywhereAction.getGradientColors();
                ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, gradient.getStartColor(), 0.0f, this.getHeight(), gradient.getEndColor()));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        JLabel title = new JLabel(" Search Everywhere:       ");
        NonOpaquePanel topPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        title.setForeground((Color)new JBColor((Color)Gray._240, (Color)Gray._200));
        if (SystemInfo.isMac) {
            title.setFont(title.getFont().deriveFont(1, (float)title.getFont().getSize() - 1.0f));
        } else {
            title.setFont(title.getFont().deriveFont(1));
        }
        topPanel.add((Component)title, "West");
        JPanel controls = new JPanel(new BorderLayout());
        controls.setOpaque(false);
        JLabel settings = new JLabel(AllIcons.General.SearchEverywhereGear);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/SearchEverywhereAction$10", "onClick"));
                }
                SearchEverywhereAction.this.showSettings();
                return true;
            }
        }.installOn((Component)settings);
        controls.add((Component)settings, "East");
        this.myNonProjectCheckBox.setForeground((Color)new JBColor((Color)Gray._240, (Color)Gray._200));
        this.myNonProjectCheckBox.setText("Include non-project items (" + SearchEverywhereAction.getShortcut() + ")  ");
        if (!NonProjectScopeDisablerEP.isSearchInNonProjectDisabled()) {
            controls.add((Component)this.myNonProjectCheckBox, "West");
        }
        topPanel.add((Component)controls, "East");
        panel2.add((Component)((Object)this.myPopupField), "Center");
        panel2.add((Component)topPanel, "North");
        panel2.setBorder(IdeBorderFactory.createEmptyBorder((int)3, (int)5, (int)4, (int)5));
        DataManager.registerDataProvider((JComponent)panel2, (DataProvider)this);
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)editor);
        this.myBalloon = builder.setCancelOnClickOutside(true).setModalContext(false).setRequestFocus(true).setCancelCallback(() -> !this.mySkipFocusGain).createPopup();
        this.myBalloon.getContent().setBorder((Border)JBUI.Borders.empty());
        Window window2 = WindowManager.getInstance().suggestParentWindow(project2);
        project2.getMessageBus().connect((Disposable)this.myBalloon).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> SearchEverywhereAction.this.rebuildList(SearchEverywhereAction.this.myPopupField.getText()));
            }
        });
        Component parent = UIUtil.findUltimateParent((Component)window2);
        this.registerDataProvider(panel2, project2);
        if (parent != null) {
            int height;
            int n = height = UISettings.getInstance().SHOW_MAIN_TOOLBAR ? 135 : 115;
            if (parent instanceof IdeFrameImpl && ((IdeFrameImpl)parent).isInFullScreen()) {
                height -= 20;
            }
            showPoint = new RelativePoint(parent, new Point((parent.getSize().width - panel2.getPreferredSize().width) / 2, height));
        } else {
            showPoint = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        }
        this.myList.setFont(UIUtil.getListFont());
        this.myBalloon.show(showPoint);
        this.initSearchActions(this.myBalloon, this.myPopupField);
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)project2);
        focusManager.requestFocus((Component)editor, true);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("SearchEverywhere");
    }

    private void showSettings() {
        this.myPopupField.setText("");
        SearchListModel model = new SearchListModel();
        model.addElement((Object)new SEOption("Show files", "search.everywhere.files"));
        model.addElement((Object)new SEOption("Show symbols", "search.everywhere.symbols"));
        model.addElement((Object)new SEOption("Show tool windows", "search.everywhere.toolwindows"));
        model.addElement((Object)new SEOption("Show run configurations", "search.everywhere.configurations"));
        model.addElement((Object)new SEOption("Show actions", "search.everywhere.actions"));
        model.addElement((Object)new SEOption("Show IDE settings", "search.everywhere.settings"));
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        this.myCurrentWorker.doWhenProcessed(() -> {
            this.myList.setModel((ListModel)model);
            this.updatePopupBounds();
        });
    }

    private static void saveHistory(Project project2, String text, Object value) {
        PsiElement psiElement;
        Language language;
        String name;
        if (project2 == null || project2.isDisposed() || !project2.isInitialized()) {
            return;
        }
        HistoryType type = null;
        String fqn = null;
        if (SearchEverywhereAction.isActionValue(value)) {
            type = HistoryType.ACTION;
            AnAction action = (AnAction)(value instanceof GotoActionModel.ActionWrapper ? ((GotoActionModel.ActionWrapper)value).getAction() : value);
            fqn = ActionManager.getInstance().getId(action);
        } else if (value instanceof VirtualFile) {
            type = HistoryType.FILE;
            fqn = ((VirtualFile)value).getUrl();
        } else if (value instanceof ChooseRunConfigurationPopup.ItemWrapper) {
            type = HistoryType.RUN_CONFIGURATION;
            fqn = ((ChooseRunConfigurationPopup.ItemWrapper)value).getText();
        } else if (value instanceof PsiElement && (name = ((PsiElementExternalizer)LanguagePsiElementExternalizer.INSTANCE.forLanguage(language = (psiElement = (PsiElement)value).getLanguage())).getQualifiedName(psiElement)) != null) {
            type = HistoryType.PSI;
            fqn = language.getID() + "://" + name;
        }
        PropertiesComponent storage2 = PropertiesComponent.getInstance((Project)project2);
        String[] values = storage2.getValues(SE_HISTORY_KEY);
        List<HistoryItem> history = new ArrayList<HistoryItem>();
        if (values != null) {
            for (String s : values) {
                String[] split = s.split("\t");
                if (split.length != 3 || text.equals(split[0]) || StringUtil.isEmpty((String)split[0])) continue;
                history.add(new HistoryItem(split[0], split[1], split[2]));
            }
        }
        history.add(0, new HistoryItem(text, type == null ? null : type.name(), fqn));
        if (history.size() > 50) {
            history = history.subList(0, 50);
        }
        String[] newValues = new String[history.size()];
        for (int i2 = 0; i2 < newValues.length; ++i2) {
            newValues[i2] = ((HistoryItem)history.get(i2)).toString();
        }
        storage2.setValues(SE_HISTORY_KEY, newValues);
    }

    @Nullable
    public Executor findExecutor(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/actions/SearchEverywhereAction", "findExecutor"));
        }
        Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
        Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
        Executor executor = ourShiftIsPressed.get() ? runExecutor : debugExecutor;
        RunConfiguration runConf = settings.getConfiguration();
        if (executor == null || runConf == null) {
            return null;
        }
        ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)runConf);
        if (runner == null) {
            executor = runExecutor == executor ? debugExecutor : runExecutor;
        }
        return executor;
    }

    private void registerDataProvider(JPanel panel2, final Project project2) {
        DataManager.registerDataProvider((JComponent)panel2, (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                Object value = SearchEverywhereAction.this.myList.getSelectedValue();
                if (CommonDataKeys.PSI_ELEMENT.is(dataId) && value instanceof PsiElement) {
                    return value;
                }
                if (CommonDataKeys.VIRTUAL_FILE.is(dataId) && value instanceof VirtualFile) {
                    return value;
                }
                if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                    Object config;
                    if (value instanceof Navigatable) {
                        return value;
                    }
                    if (value instanceof ChooseRunConfigurationPopup.ItemWrapper && (config = ((ChooseRunConfigurationPopup.ItemWrapper)value).getValue()) instanceof RunnerAndConfigurationSettings) {
                        return new Navigatable(){

                            public void navigate(boolean requestFocus) {
                                Executor executor = SearchEverywhereAction.this.findExecutor((RunnerAndConfigurationSettings)config);
                                RunDialog.editConfiguration(project2, (RunnerAndConfigurationSettings)config, "Edit Configuration", executor);
                            }

                            public boolean canNavigate() {
                                return true;
                            }

                            public boolean canNavigateToSource() {
                                return true;
                            }
                        };
                    }
                }
                if (PlatformDataKeys.SEARCH_INPUT_TEXT.is(dataId)) {
                    return SearchEverywhereAction.this.myPopupField == null ? null : SearchEverywhereAction.this.myPopupField.getText();
                }
                return null;
            }
        });
    }

    private void initSearchActions(JBPopup balloon, MySearchTextField searchTextField) {
        JBTextField editor = searchTextField.getTextEditor();
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                SearchEverywhereAction.this.jumpNextGroup(true);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), (JComponent)editor, (Disposable)balloon);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                SearchEverywhereAction.this.jumpNextGroup(false);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)editor, (Disposable)balloon);
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                if (SearchEverywhereAction.this.myBalloon != null && SearchEverywhereAction.this.myBalloon.isVisible()) {
                    SearchEverywhereAction.this.myBalloon.cancel();
                }
                if (SearchEverywhereAction.this.myPopup != null && SearchEverywhereAction.this.myPopup.isVisible()) {
                    SearchEverywhereAction.this.myPopup.cancel();
                }
            }
        }.registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)editor, (Disposable)balloon);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                int index = SearchEverywhereAction.this.myList.getSelectedIndex();
                if (index != -1) {
                    SearchEverywhereAction.this.doNavigate(index);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER", "shift ENTER"}), (JComponent)editor, (Disposable)balloon);
        new DumbAwareAction((JTextField)editor){
            final /* synthetic */ JTextField val$editor;
            {
                this.val$editor = jTextField;
            }

            public void actionPerformed(AnActionEvent e) {
                PropertiesComponent storage2 = PropertiesComponent.getInstance((Project)e.getProject());
                String[] values = storage2.getValues(SearchEverywhereAction.SE_HISTORY_KEY);
                if (values != null && values.length > SearchEverywhereAction.this.myHistoryIndex) {
                    List data = StringUtil.split((String)values[SearchEverywhereAction.this.myHistoryIndex], (String)"\t");
                    SearchEverywhereAction.this.myHistoryItem = new HistoryItem((String)data.get(0), (String)data.get(1), (String)data.get(2));
                    SearchEverywhereAction.this.myHistoryIndex++;
                    this.val$editor.setText(((SearchEverywhereAction)SearchEverywhereAction.this).myHistoryItem.pattern);
                    this.val$editor.setCaretPosition(((SearchEverywhereAction)SearchEverywhereAction.this).myHistoryItem.pattern.length());
                    this.val$editor.moveCaretPosition(0);
                }
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(this.val$editor.getCaretPosition() == 0);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"LEFT"}), (JComponent)editor, (Disposable)balloon);
    }

    private static String getSettingText(OptionDescription value) {
        String hit = value.getHit();
        if (hit == null) {
            hit = value.getOption();
        }
        if ((hit = StringUtil.unescapeXml((String)hit)).length() > 60) {
            hit = hit.substring(0, 60) + "...";
        }
        hit = hit.replace("  ", " ");
        String text = hit.trim();
        text = StringUtil.trimEnd((String)text, (String)":");
        return text;
    }

    private static boolean isActionValue(Object o) {
        return o instanceof GotoActionModel.ActionWrapper || o instanceof AnAction;
    }

    private static boolean isSetting(Object o) {
        return o instanceof OptionDescription;
    }

    private static boolean isRunConfiguration(Object o) {
        return o instanceof ChooseRunConfigurationPopup.ItemWrapper;
    }

    private static boolean isVirtualFile(Object o) {
        return o instanceof VirtualFile;
    }

    private static Font getTitleFont() {
        return UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    private static boolean shouldSkipPattern(String pattern) {
        return Registry.is((String)"search.everywhere.pattern.checking") && StringUtil.split((String)pattern, (String)".").size() == 2;
    }

    protected void resetFields() {
        if (this.myBalloon != null) {
            JBPopup balloonToBeCanceled = this.myBalloon;
            SwingUtilities.invokeLater(() -> balloonToBeCanceled.cancel());
            this.myBalloon = null;
        }
        this.myCurrentWorker.doWhenProcessed(() -> {
            CalcThread lock;
            this.myFileModel = null;
            if (this.myFileChooseByName != null) {
                this.myFileChooseByName.close(false);
                this.myFileChooseByName = null;
            }
            if (this.myClassChooseByName != null) {
                this.myClassChooseByName.close(false);
                this.myClassChooseByName = null;
            }
            if (this.mySymbolsChooseByName != null) {
                this.mySymbolsChooseByName.close(false);
                this.mySymbolsChooseByName = null;
            }
            if ((lock = this.myCalcThread) != null) {
                CalcThread calcThread = lock;
                synchronized (calcThread) {
                    this.myClassModel = null;
                    this.myActionProvider = null;
                    this.mySymbolsModel = null;
                    this.myConfigurables.clear();
                    this.myFocusComponent = null;
                    this.myContextComponent = null;
                    this.myFocusOwner = null;
                    this.myRenderer.myProject = null;
                    this.myPopup = null;
                    this.myHistoryIndex = 0;
                    this.myPopupActualWidth = 0;
                    this.myCurrentWorker = ActionCallback.DONE;
                    showAll.set(false);
                    this.myCalcThread = null;
                    this.myEditor = null;
                    this.myFileEditor = null;
                    this.myStructureModel = null;
                    this.myDisabledActions.clear();
                }
            }
        });
        this.mySkipFocusGain = false;
    }

    private void updatePopupBounds() {
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            return;
        }
        Container parent = this.getField().getParent();
        Dimension size = this.myList.getParent().getParent().getPreferredSize();
        size.width = this.myPopupActualWidth - 2;
        if (size.width + 2 < parent.getWidth()) {
            size.width = parent.getWidth();
        }
        if (this.myList.getItemsCount() == 0) {
            size.height = JBUI.scale((int)30);
        }
        Dimension sz = new Dimension(size.width, this.myList.getPreferredSize().height);
        if (!SystemInfo.isMac) {
            if (sz.width > SearchEverywhereAction.getPopupMaxWidth() || sz.height > SearchEverywhereAction.getPopupMaxWidth()) {
                JBScrollPane pane = new JBScrollPane();
                int extraWidth = pane.getVerticalScrollBar().getWidth() + 1;
                int extraHeight = pane.getHorizontalScrollBar().getHeight() + 1;
                sz = new Dimension(Math.min(SearchEverywhereAction.getPopupMaxWidth(), Math.max(this.getField().getWidth(), sz.width + extraWidth)), Math.min(SearchEverywhereAction.getPopupMaxWidth(), sz.height + extraHeight));
                sz.width += 20;
                sz.height += 2;
            } else {
                sz.width += 2;
                sz.height += 2;
            }
        }
        sz.width = Math.max(sz.width, this.myPopup.getSize().width);
        this.myPopup.setSize(sz);
        if (this.myActionEvent != null && this.myActionEvent.getInputEvent() == null) {
            Point p = parent.getLocationOnScreen();
            p.y += parent.getHeight();
            if (parent.getWidth() < sz.width) {
                p.x -= sz.width - parent.getWidth();
            }
            this.myPopup.setLocation(p);
        } else {
            try {
                this.adjustPopup();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static int getPopupMaxWidth() {
        return PropertiesComponent.getInstance().getInt("search.everywhere.max.popup.width", JBUI.scale((int)600));
    }

    private void adjustPopup() {
        Dimension d = PopupPositionManager.PositionAdjuster.getPopupSize(this.myPopup);
        JComponent myRelativeTo = this.myBalloon.getContent();
        Point myRelativeOnScreen = myRelativeTo.getLocationOnScreen();
        Rectangle screen = ScreenUtil.getScreenRectangle((Point)myRelativeOnScreen);
        Rectangle popupRect = null;
        Rectangle r = new Rectangle(myRelativeOnScreen.x, myRelativeOnScreen.y + myRelativeTo.getHeight(), d.width, d.height);
        if (screen.contains(r)) {
            popupRect = r;
        }
        if (popupRect != null) {
            Point location = new Point(r.x, r.y);
            if (!location.equals(this.myPopup.getLocationOnScreen())) {
                this.myPopup.setLocation(location);
            }
        } else {
            if (r.y + d.height > screen.y + screen.height) {
                r.height = screen.y + screen.height - r.y - 2;
            }
            if (r.width > screen.width) {
                r.width = screen.width - 50;
            }
            if (r.x + r.width > screen.x + screen.width) {
                r.x = screen.x + screen.width - r.width - 2;
            }
            this.myPopup.setSize(r.getSize());
            this.myPopup.setLocation(r.getLocation());
        }
    }

    private static boolean isToolWindowAction(Object o) {
        return SearchEverywhereAction.isActionValue(o) && o instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)o).getAction() instanceof ActivateToolWindowAction;
    }

    private void fillConfigurablesIds(String pathToParent, Configurable[] configurables) {
        for (Configurable configurable : configurables) {
            if (!(configurable instanceof SearchableConfigurable)) continue;
            String id = ((SearchableConfigurable)configurable).getId();
            String name = configurable.getDisplayName();
            if (pathToParent != null) {
                name = pathToParent + " -> " + name;
            }
            this.myConfigurables.put(id, name);
            if (!(configurable instanceof SearchableConfigurable.Parent)) continue;
            this.fillConfigurablesIds(name, ((SearchableConfigurable.Parent)configurable).getConfigurables());
        }
    }

    private static JComponent createTitle(String titleText) {
        JLabel titleLabel = new JLabel(titleText);
        titleLabel.setFont(SearchEverywhereAction.getTitleFont());
        titleLabel.setForeground(UIUtil.getLabelDisabledForeground());
        SeparatorComponent separatorComponent = new SeparatorComponent(titleLabel.getPreferredSize().height / 2, (Color)new JBColor((Color)Gray._220, (Color)Gray._80), null);
        return JBUI.Panels.simplePanel((int)5, (int)10).addToCenter((Component)separatorComponent).addToLeft((Component)titleLabel).withBackground(UIUtil.getListBackground());
    }

    @Nullable
    private static HistoryType parseHistoryType(@Nullable String name) {
        try {
            return HistoryType.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        ModifierKeyDoubleClickHandler.getInstance().registerAction("SearchEverywhere", 16, -1, false);
        IdeEventQueue.getInstance().addPostprocessor(event -> {
            int keyCode;
            if (event instanceof KeyEvent && (keyCode = ((KeyEvent)event).getKeyCode()) == 16) {
                ourShiftIsPressed.set(event.getID() == 401);
            }
            return false;
        }, null);
    }

    private static class HistoryItem {
        final String pattern;
        final String type;
        final String fqn;

        private HistoryItem(String pattern, String type, String fqn) {
            this.pattern = pattern;
            this.type = type;
            this.fqn = fqn;
        }

        public String toString() {
            return this.pattern + "\t" + this.type + "\t" + this.fqn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistoryItem item = (HistoryItem)o;
            return this.pattern.equals(item.pattern);
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }
    }

    private static enum HistoryType {
        PSI,
        FILE,
        SETTING,
        ACTION,
        RUN_CONFIGURATION;

    }

    static class More
    extends JPanel {
        static final More instance = new More();
        final JLabel label = new JLabel("    ... more   ");

        private More() {
            super(new BorderLayout());
            this.add((Component)this.label, "Center");
        }

        static More get(boolean isSelected) {
            instance.setBackground(UIUtil.getListBackground((boolean)isSelected));
            More.instance.label.setForeground(UIUtil.getLabelDisabledForeground());
            More.instance.label.setFont(SearchEverywhereAction.getTitleFont());
            More.instance.label.setBackground(UIUtil.getListBackground((boolean)isSelected));
            return instance;
        }
    }

    private static class SearchListModel
    extends DefaultListModel {
        Vector myDelegate;
        volatile TitleIndex titleIndex = new TitleIndex();
        volatile MoreIndex moreIndex = new MoreIndex();

        private SearchListModel() {
            this.myDelegate = (Vector)ReflectionUtil.getField(DefaultListModel.class, (Object)this, Vector.class, (String)"delegate");
        }

        int next(int index) {
            int[] all = this.getAll();
            Arrays.sort(all);
            for (int next : all) {
                if (next <= index) continue;
                return next;
            }
            return 0;
        }

        int[] getAll() {
            return new int[]{this.titleIndex.topHit, this.titleIndex.recentFiles, this.titleIndex.structure, this.titleIndex.runConfigurations, this.titleIndex.classes, this.titleIndex.files, this.titleIndex.actions, this.titleIndex.settings, this.titleIndex.toolWindows, this.titleIndex.symbols, this.moreIndex.classes, this.moreIndex.actions, this.moreIndex.files, this.moreIndex.settings, this.moreIndex.symbols, this.moreIndex.runConfigurations, this.moreIndex.structure};
        }

        int prev(int index) {
            int[] all = this.getAll();
            Arrays.sort(all);
            for (int i2 = all.length - 1; i2 >= 0; --i2) {
                if (all[i2] == -1 || all[i2] >= index) continue;
                return all[i2];
            }
            return all[all.length - 1];
        }

        public void addElement(Object obj) {
            this.myDelegate.add(obj);
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    static class SearchResult
    extends ArrayList<Object> {
        boolean needMore;

        SearchResult() {
        }
    }

    static class TitleIndex {
        volatile int topHit = -1;
        volatile int recentFiles = -1;
        volatile int runConfigurations = -1;
        volatile int classes = -1;
        volatile int structure = -1;
        volatile int files = -1;
        volatile int actions = -1;
        volatile int settings = -1;
        volatile int toolWindows = -1;
        volatile int symbols = -1;
        final String gotoClassTitle;
        final String gotoFileTitle;
        final String gotoActionTitle;
        final String gotoSettingsTitle;
        final String gotoRecentFilesTitle;
        final String gotoRunConfigurationsTitle;
        final String gotoSymbolTitle;
        final String gotoStructureTitle;
        static final String toolWindowsTitle = "Tool Windows";

        TitleIndex() {
            String gotoClass = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoClass"));
            this.gotoClassTitle = StringUtil.isEmpty((String)gotoClass) ? "Classes" : "Classes (" + gotoClass + ")";
            String gotoFile = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoFile"));
            this.gotoFileTitle = StringUtil.isEmpty((String)gotoFile) ? "Files" : "Files (" + gotoFile + ")";
            String gotoAction = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoAction"));
            this.gotoActionTitle = StringUtil.isEmpty((String)gotoAction) ? "Actions" : "Actions (" + gotoAction + ")";
            String gotoSettings = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowSettings"));
            this.gotoSettingsTitle = StringUtil.isEmpty((String)gotoAction) ? ShowSettingsUtil.getSettingsMenuName() : ShowSettingsUtil.getSettingsMenuName() + " (" + gotoSettings + ")";
            String gotoRecentFiles = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("RecentFiles"));
            this.gotoRecentFilesTitle = StringUtil.isEmpty((String)gotoRecentFiles) ? "Recent Files" : "Recent Files (" + gotoRecentFiles + ")";
            String gotoSymbol = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("GotoSymbol"));
            this.gotoSymbolTitle = StringUtil.isEmpty((String)gotoSymbol) ? "Symbols" : "Symbols (" + gotoSymbol + ")";
            String gotoRunConfiguration = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ChooseDebugConfiguration"));
            if (StringUtil.isEmpty((String)gotoRunConfiguration)) {
                gotoRunConfiguration = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ChooseRunConfiguration"));
            }
            this.gotoRunConfigurationsTitle = StringUtil.isEmpty((String)gotoRunConfiguration) ? "Run Configurations" : "Run Configurations (" + gotoRunConfiguration + ")";
            String gotoStructure = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("FileStructurePopup"));
            this.gotoStructureTitle = StringUtil.isEmpty((String)gotoStructure) ? "File Structure" : "File Structure (" + gotoStructure + ")";
        }

        String getTitle(int index) {
            if (index == this.topHit) {
                return index == 0 ? "Top Hit" : "Top Hits";
            }
            if (index == this.recentFiles) {
                return this.gotoRecentFilesTitle;
            }
            if (index == this.structure) {
                return this.gotoStructureTitle;
            }
            if (index == this.runConfigurations) {
                return this.gotoRunConfigurationsTitle;
            }
            if (index == this.classes) {
                return this.gotoClassTitle;
            }
            if (index == this.files) {
                return this.gotoFileTitle;
            }
            if (index == this.toolWindows) {
                return toolWindowsTitle;
            }
            if (index == this.actions) {
                return this.gotoActionTitle;
            }
            if (index == this.settings) {
                return this.gotoSettingsTitle;
            }
            if (index == this.symbols) {
                return this.gotoSymbolTitle;
            }
            return null;
        }

        public void clear() {
            this.topHit = -1;
            this.runConfigurations = -1;
            this.recentFiles = -1;
            this.classes = -1;
            this.files = -1;
            this.structure = -1;
            this.actions = -1;
            this.settings = -1;
            this.toolWindows = -1;
        }

        public void shift(int index, int shift) {
            if (this.toolWindows != -1 && this.toolWindows > index) {
                this.toolWindows += shift;
            }
            if (this.settings != -1 && this.settings > index) {
                this.settings += shift;
            }
            if (this.actions != -1 && this.actions > index) {
                this.actions += shift;
            }
            if (this.files != -1 && this.files > index) {
                this.files += shift;
            }
            if (this.structure != -1 && this.structure > index) {
                this.structure += shift;
            }
            if (this.classes != -1 && this.classes > index) {
                this.classes += shift;
            }
            if (this.runConfigurations != -1 && this.runConfigurations > index) {
                this.runConfigurations += shift;
            }
            if (this.symbols != -1 && this.symbols > index) {
                this.symbols += shift;
            }
        }
    }

    static class MoreIndex {
        volatile int classes = -1;
        volatile int files = -1;
        volatile int actions = -1;
        volatile int settings = -1;
        volatile int symbols = -1;
        volatile int runConfigurations = -1;
        volatile int structure = -1;

        MoreIndex() {
        }

        public void shift(int index, int shift) {
            if (this.runConfigurations >= index) {
                this.runConfigurations += shift;
            }
            if (this.classes >= index) {
                this.classes += shift;
            }
            if (this.files >= index) {
                this.files += shift;
            }
            if (this.symbols >= index) {
                this.symbols += shift;
            }
            if (this.actions >= index) {
                this.actions += shift;
            }
            if (this.settings >= index) {
                this.settings += shift;
            }
            if (this.structure >= index) {
                this.structure += shift;
            }
        }
    }

    private class CalcThread
    implements Runnable {
        private final Project project;
        private final String pattern;
        private final ProgressIndicator myProgressIndicator = new ProgressIndicatorBase();
        private final ActionCallback myDone = new ActionCallback();
        private final SearchListModel myListModel;
        private final ArrayList<VirtualFile> myAlreadyAddedFiles = new ArrayList();
        private final ArrayList<AnAction> myAlreadyAddedActions = new ArrayList();

        public CalcThread(Project project2, String pattern, boolean reuseModel) {
            this.project = project2;
            this.pattern = pattern;
            this.myListModel = reuseModel ? (SearchListModel)SearchEverywhereAction.this.myList.getModel() : new SearchListModel();
        }

        @Override
        public void run() {
            try {
                this.check();
                SwingUtilities.invokeLater(() -> {
                    SearchEverywhereAction.this.myList.getEmptyText().setText("Searching...");
                    if (SearchEverywhereAction.this.myList.getModel() instanceof SearchListModel) {
                        SearchEverywhereAction.this.myAlarm.cancelAllRequests();
                        SearchEverywhereAction.this.myAlarm.addRequest(() -> {
                            if (!this.myDone.isRejected()) {
                                SearchEverywhereAction.this.myList.setModel((ListModel)this.myListModel);
                                this.updatePopup();
                            }
                        }, 50);
                    } else {
                        SearchEverywhereAction.this.myList.setModel((ListModel)this.myListModel);
                    }
                });
                if (this.pattern.trim().length() == 0) {
                    this.buildModelFromRecentFiles();
                    return;
                }
                this.checkModelsUpToDate();
                this.check();
                this.buildTopHit(this.pattern);
                this.check();
                if (!this.pattern.startsWith("#")) {
                    this.buildRecentFiles(this.pattern);
                    this.check();
                    this.runReadAction(() -> this.buildStructure(this.pattern), true);
                    this.updatePopup();
                    this.check();
                    this.buildToolWindows(this.pattern);
                    this.check();
                    this.updatePopup();
                    this.check();
                    this.runReadAction(() -> this.buildRunConfigurations(this.pattern), true);
                    this.runReadAction(() -> this.buildClasses(this.pattern), true);
                    this.runReadAction(() -> this.buildFiles(this.pattern), false);
                    this.runReadAction(() -> this.buildSymbols(this.pattern), true);
                    this.buildActionsAndSettings(this.pattern);
                    this.updatePopup();
                }
                this.updatePopup();
            }
            catch (ProcessCanceledException ignore) {
                this.myDone.setRejected();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.myDone.setRejected();
            }
            finally {
                if (!this.isCanceled()) {
                    SwingUtilities.invokeLater(() -> SearchEverywhereAction.this.myList.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT));
                    this.updatePopup();
                }
                if (!this.myDone.isProcessed()) {
                    this.myDone.setDone();
                }
            }
        }

        private void runReadAction(Runnable action, boolean checkDumb) {
            if (!checkDumb || !DumbService.getInstance((Project)this.project).isDumb()) {
                ApplicationManager.getApplication().runReadAction(action);
                this.updatePopup();
            }
        }

        protected void check() {
            this.myProgressIndicator.checkCanceled();
            if (this.myDone.isRejected()) {
                throw new ProcessCanceledException();
            }
            if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                throw new ProcessCanceledException();
            }
        }

        private synchronized void buildToolWindows(String pattern) {
            if (!Registry.is((String)"search.everywhere.toolwindows")) {
                return;
            }
            ArrayList<ActivateToolWindowAction> actions = new ArrayList<ActivateToolWindowAction>();
            for (ActivateToolWindowAction action : ToolWindowsGroup.getToolWindowActions(this.project, false)) {
                String text = action.getTemplatePresentation().getText();
                if (text == null || !StringUtil.startsWithIgnoreCase((String)text, (String)pattern)) continue;
                actions.add(action);
                if (actions.size() != 4) continue;
                break;
            }
            this.check();
            if (actions.isEmpty()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                this.myListModel.titleIndex.toolWindows = this.myListModel.size();
                for (Object toolWindow : actions) {
                    this.myListModel.addElement(toolWindow);
                }
            });
        }

        private SearchResult getActionsOrSettings(String pattern, int max, boolean actions) {
            SearchResult result2 = new SearchResult();
            if (actions && !Registry.is((String)"search.everywhere.actions") || !actions && !Registry.is((String)"search.everywhere.settings")) {
                return result2;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern)).build();
            if (SearchEverywhereAction.this.myActionProvider == null) {
                SearchEverywhereAction.this.myActionProvider = this.createActionProvider();
            }
            SearchEverywhereAction.this.myActionProvider.filterElements(pattern, true, (Processor<GotoActionModel.MatchedValue>)((Processor)matched -> {
                this.check();
                Comparable object = matched.value;
                if (this.myListModel.contains(object)) {
                    return true;
                }
                if (!actions && SearchEverywhereAction.isSetting(object)) {
                    if (matcher.matches(SearchEverywhereAction.getSettingText((OptionDescription)object))) {
                        result2.add(object);
                    }
                } else if (actions && !SearchEverywhereAction.isToolWindowAction(object) && SearchEverywhereAction.isActionValue(object)) {
                    AnAction action = object instanceof AnAction ? (AnAction)object : ((GotoActionModel.ActionWrapper)object).getAction();
                    CalcThread lock = SearchEverywhereAction.this.myCalcThread;
                    if (lock != null) {
                        CalcThread calcThread = lock;
                        synchronized (calcThread) {
                            if (this.isEnabled(action)) {
                                result2.add(object);
                            }
                        }
                    }
                }
                return result2.size() <= max;
            }));
            return result2;
        }

        private synchronized void buildActionsAndSettings(String pattern) {
            SearchResult actions = this.getActionsOrSettings(pattern, 5, true);
            SearchResult settings = this.getActionsOrSettings(pattern, 5, false);
            this.check();
            SwingUtilities.invokeLater(() -> {
                if (this.isCanceled()) {
                    return;
                }
                if (actions.size() > 0) {
                    this.myListModel.titleIndex.actions = this.myListModel.size();
                    for (Object action : actions) {
                        this.myListModel.addElement(action);
                    }
                }
                int n = this.myListModel.moreIndex.actions = actions.size() >= 5 ? this.myListModel.size() - 1 : -1;
                if (settings.size() > 0) {
                    this.myListModel.titleIndex.settings = this.myListModel.size();
                    for (Object setting : settings) {
                        this.myListModel.addElement(setting);
                    }
                }
                this.myListModel.moreIndex.settings = settings.size() >= 5 ? this.myListModel.size() - 1 : -1;
            });
        }

        private synchronized void buildFiles(String pattern) {
            SearchResult files = this.getFiles(pattern, showAll.get(), 6, SearchEverywhereAction.this.myFileChooseByName);
            this.check();
            if (files.size() > 0) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.files = this.myListModel.size();
                    for (Object file2 : files) {
                        this.myListModel.addElement(file2);
                    }
                    this.myListModel.moreIndex.files = files.needMore ? this.myListModel.size() - 1 : -1;
                });
            }
        }

        private synchronized void buildStructure(String pattern) {
            if (!Registry.is((String)"search.everywhere.structure") || SearchEverywhereAction.this.myStructureModel == null) {
                return;
            }
            ArrayList<StructureViewTreeElement> elements = new ArrayList<StructureViewTreeElement>();
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern)).build();
            this.fillStructure(SearchEverywhereAction.this.myStructureModel.getRoot(), elements, (Matcher)matcher);
            if (elements.size() > 0) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.structure = this.myListModel.size();
                    for (Object element : elements) {
                        this.myListModel.addElement(element);
                    }
                    this.myListModel.moreIndex.files = -1;
                });
            }
        }

        private void fillStructure(StructureViewTreeElement element, List<StructureViewTreeElement> elements, Matcher matcher) {
            TreeElement[] children2 = element.getChildren();
            this.check();
            for (TreeElement child : children2) {
                this.check();
                if (!(child instanceof StructureViewTreeElement)) continue;
                String text = child.getPresentation().getPresentableText();
                if (text != null && matcher.matches(text)) {
                    elements.add((StructureViewTreeElement)child);
                }
                this.fillStructure((StructureViewTreeElement)child, elements, matcher);
            }
        }

        private synchronized void buildSymbols(String pattern) {
            SearchResult symbols = this.getSymbols(pattern, 6, showAll.get(), SearchEverywhereAction.this.mySymbolsChooseByName);
            this.check();
            if (symbols.size() > 0) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.symbols = this.myListModel.size();
                    for (Object file2 : symbols) {
                        this.myListModel.addElement(file2);
                    }
                    this.myListModel.moreIndex.symbols = symbols.needMore ? this.myListModel.size() - 1 : -1;
                });
            }
        }

        @Nullable
        private ChooseRunConfigurationPopup.ItemWrapper getRunConfigurationByName(String name) {
            ChooseRunConfigurationPopup.ItemWrapper[] wrappers;
            for (ChooseRunConfigurationPopup.ItemWrapper wrapper : wrappers = ChooseRunConfigurationPopup.createSettingsList(this.project, new ExecutorProvider(){

                @Override
                public Executor getExecutor() {
                    return ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
                }
            }, false)) {
                if (!wrapper.getText().equals(name)) continue;
                return wrapper;
            }
            return null;
        }

        private synchronized void buildRunConfigurations(String pattern) {
            SearchResult runConfigurations = this.getConfigurations(pattern, 6);
            if (runConfigurations.size() > 0) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.runConfigurations = this.myListModel.size();
                    for (Object runConfiguration : runConfigurations) {
                        this.myListModel.addElement(runConfiguration);
                    }
                    this.myListModel.moreIndex.runConfigurations = runConfigurations.needMore ? this.myListModel.getSize() - 1 : -1;
                });
            }
        }

        private SearchResult getConfigurations(String pattern, int max) {
            SearchResult configurations = new SearchResult();
            if (!Registry.is((String)"search.everywhere.configurations")) {
                return configurations;
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)pattern).build();
            ChooseRunConfigurationPopup.ItemWrapper[] wrappers = ChooseRunConfigurationPopup.createSettingsList(this.project, new ExecutorProvider(){

                @Override
                public Executor getExecutor() {
                    return ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
                }
            }, false);
            this.check();
            for (ChooseRunConfigurationPopup.ItemWrapper wrapper : wrappers) {
                if (matcher.matches(wrapper.getText()) && !this.myListModel.contains(wrapper)) {
                    if (configurations.size() == max) {
                        configurations.needMore = true;
                        break;
                    }
                    configurations.add(wrapper);
                }
                this.check();
            }
            return configurations;
        }

        private synchronized void buildClasses(String pattern) {
            SearchResult classes = this.getClasses(pattern, showAll.get(), 6, SearchEverywhereAction.this.myClassChooseByName);
            this.check();
            if (classes.size() > 0) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.classes = this.myListModel.size();
                    for (Object file2 : classes) {
                        this.myListModel.addElement(file2);
                    }
                    this.myListModel.moreIndex.classes = -1;
                    if (classes.needMore) {
                        this.myListModel.moreIndex.classes = this.myListModel.size() - 1;
                    }
                });
            }
        }

        private SearchResult getSymbols(String pattern, int max, boolean includeLibs, ChooseByNamePopup chooseByNamePopup) {
            SearchResult symbols = new SearchResult();
            if (!Registry.is((String)"search.everywhere.symbols") || SearchEverywhereAction.shouldSkipPattern(pattern)) {
                return symbols;
            }
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.project);
            if (chooseByNamePopup == null) {
                return symbols;
            }
            ChooseByNameItemProvider provider = chooseByNamePopup.getProvider();
            provider.filterElements(chooseByNamePopup, pattern, includeLibs, this.myProgressIndicator, (Processor<Object>)((Processor)o -> {
                if (SearchEverywhereClassifier.EP_Manager.isSymbol(o) && !this.myListModel.contains(o) && !symbols.contains(o)) {
                    boolean isFileInScope;
                    PsiElement element = null;
                    if (o instanceof PsiElement) {
                        element = (PsiElement)o;
                    } else if (o instanceof PsiElementNavigationItem) {
                        element = ((PsiElementNavigationItem)o).getTargetElement();
                    }
                    VirtualFile virtualFile = SearchEverywhereClassifier.EP_Manager.getVirtualFile(o);
                    boolean isElementWithoutFile = element != null && element.getContainingFile() == null;
                    boolean bl = isFileInScope = virtualFile != null && (includeLibs || scope.accept(virtualFile));
                    if (isElementWithoutFile || isFileInScope) {
                        symbols.add(o);
                    }
                }
                symbols.needMore = symbols.size() == max;
                return !symbols.needMore;
            }));
            if (!includeLibs && symbols.isEmpty()) {
                return this.getSymbols(pattern, max, true, chooseByNamePopup);
            }
            return symbols;
        }

        private SearchResult getClasses(String pattern, boolean includeLibs, int max, ChooseByNamePopup chooseByNamePopup) {
            SearchResult classes = new SearchResult();
            if (chooseByNamePopup == null || SearchEverywhereAction.shouldSkipPattern(pattern)) {
                return classes;
            }
            chooseByNamePopup.getProvider().filterElements(chooseByNamePopup, pattern, includeLibs, this.myProgressIndicator, (Processor<Object>)((Processor)o -> {
                if (SearchEverywhereClassifier.EP_Manager.isClass(o) && !this.myListModel.contains(o) && !classes.contains(o)) {
                    if (classes.size() == max) {
                        classes.needMore = true;
                        return false;
                    }
                    PsiElement element = null;
                    if (o instanceof PsiElement) {
                        element = (PsiElement)o;
                    } else if (o instanceof PsiElementNavigationItem) {
                        element = ((PsiElementNavigationItem)o).getTargetElement();
                    }
                    classes.add(o);
                    if (element instanceof PsiNamedElement) {
                        String name = ((PsiNamedElement)element).getName();
                        VirtualFile virtualFile = SearchEverywhereClassifier.EP_Manager.getVirtualFile(o);
                        if (virtualFile != null && StringUtil.equals((CharSequence)name, (CharSequence)virtualFile.getNameWithoutExtension())) {
                            this.myAlreadyAddedFiles.add(virtualFile);
                        }
                    }
                }
                return true;
            }));
            if (!includeLibs && classes.isEmpty()) {
                return this.getClasses(pattern, true, max, chooseByNamePopup);
            }
            return classes;
        }

        private SearchResult getFiles(String pattern, boolean includeLibs, int max, ChooseByNamePopup chooseByNamePopup) {
            SearchResult files = new SearchResult();
            if (chooseByNamePopup == null || !Registry.is((String)"search.everywhere.files")) {
                return files;
            }
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.project);
            chooseByNamePopup.getProvider().filterElements(chooseByNamePopup, pattern, true, this.myProgressIndicator, (Processor<Object>)((Processor)o -> {
                VirtualFile file2 = null;
                if (o instanceof VirtualFile) {
                    file2 = (VirtualFile)o;
                } else if (o instanceof PsiFile) {
                    file2 = ((PsiFile)o).getVirtualFile();
                } else if (o instanceof PsiDirectory) {
                    file2 = ((PsiDirectory)o).getVirtualFile();
                }
                if (!(file2 == null || pattern.indexOf(32) != -1 && file2.getName().indexOf(32) == -1 || !includeLibs && (!scope.accept(file2) || this.myListModel.contains(file2) || this.myAlreadyAddedFiles.contains(file2)) || files.contains(file2))) {
                    if (files.size() == max) {
                        files.needMore = true;
                        return false;
                    }
                    files.add(file2);
                }
                return true;
            }));
            if (!includeLibs && files.isEmpty()) {
                return this.getFiles(pattern, true, max, chooseByNamePopup);
            }
            return files;
        }

        private synchronized void buildRecentFiles(String pattern) {
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern)).build();
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            List<VirtualFile> selected = Arrays.asList(FileEditorManager.getInstance((Project)this.project).getSelectedFiles());
            for (VirtualFile file2 : (VirtualFile[])ArrayUtil.reverseArray((Object[])EditorHistoryManager.getInstance(this.project).getFiles())) {
                if ((StringUtil.isEmptyOrSpaces((String)pattern) || matcher.matches(file2.getName())) && !files.contains(file2) && !selected.contains(file2)) {
                    files.add(file2);
                }
                if (files.size() > 10) break;
            }
            if (files.size() > 0) {
                this.myAlreadyAddedFiles.addAll(files);
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    this.myListModel.titleIndex.recentFiles = this.myListModel.size();
                    for (Object file2 : files) {
                        this.myListModel.addElement(file2);
                    }
                    this.updatePopup();
                });
            }
        }

        private boolean isCanceled() {
            return this.myProgressIndicator.isCanceled() || this.myDone.isRejected();
        }

        private synchronized void buildTopHit(String pattern) {
            HistoryType type;
            ArrayList<Object> elements = new ArrayList<Object>();
            HistoryItem history = SearchEverywhereAction.this.myHistoryItem;
            if (history != null && (type = SearchEverywhereAction.parseHistoryType(history.type)) != null) {
                switch (type) {
                    case PSI: {
                        if (DumbService.isDumb((Project)this.project)) break;
                        ApplicationManager.getApplication().runReadAction(() -> {
                            int i2 = history.fqn.indexOf("://");
                            if (i2 != -1) {
                                PsiElement psi;
                                String langId = history.fqn.substring(0, i2);
                                Language language = Language.findLanguageByID((String)langId);
                                String psiFqn = history.fqn.substring(i2 + 3);
                                if (language != null && (psi = ((PsiElementExternalizer)LanguagePsiElementExternalizer.INSTANCE.forLanguage(language)).findByQualifiedName(this.project, psiFqn)) != null) {
                                    VirtualFile file2;
                                    elements.add(psi);
                                    PsiFile psiFile = psi.getContainingFile();
                                    if (psiFile != null && (file2 = psiFile.getVirtualFile()) != null) {
                                        this.myAlreadyAddedFiles.add(file2);
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case FILE: {
                        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(history.fqn);
                        if (file2 == null) break;
                        elements.add(file2);
                        break;
                    }
                    case SETTING: {
                        break;
                    }
                    case ACTION: {
                        AnAction action = ActionManager.getInstance().getAction(history.fqn);
                        if (action == null) break;
                        elements.add(action);
                        this.myAlreadyAddedActions.add(action);
                        break;
                    }
                    case RUN_CONFIGURATION: {
                        if (DumbService.isDumb((Project)this.project)) break;
                        ApplicationManager.getApplication().runReadAction(() -> {
                            ChooseRunConfigurationPopup.ItemWrapper runConfiguration = this.getRunConfigurationByName(history.fqn);
                            if (runConfiguration != null) {
                                elements.add(runConfiguration);
                            }
                        });
                    }
                }
            }
            Consumer consumer = o -> {
                if (SearchEverywhereAction.isSetting(o) || SearchEverywhereAction.isVirtualFile(o) || SearchEverywhereAction.isActionValue(o) || o instanceof PsiElement || o instanceof OptionsTopHitProvider) {
                    if (o instanceof AnAction && this.myAlreadyAddedActions.contains(o)) {
                        return;
                    }
                    elements.add(o);
                }
            };
            if (pattern.startsWith("#") && !pattern.contains(" ")) {
                String id = pattern.substring(1);
                HashSet<String> ids = new HashSet<String>();
                for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
                    String providerId;
                    this.check();
                    if (!(provider instanceof OptionsTopHitProvider) || ids.contains(providerId = ((OptionsTopHitProvider)provider).getId()) || !StringUtil.startsWithIgnoreCase((String)providerId, (String)id)) continue;
                    consumer.consume((Object)provider);
                    ids.add(providerId);
                }
            } else {
                ActionManager actionManager = ActionManager.getInstance();
                List actions = AbbreviationManager.getInstance().findActions(pattern);
                for (String actionId : actions) {
                    consumer.consume((Object)actionManager.getAction(actionId));
                }
                for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
                    this.check();
                    if (provider instanceof OptionsTopHitProvider && !((OptionsTopHitProvider)provider).isEnabled(this.project)) continue;
                    provider.consumeTopHits(pattern, consumer, this.project);
                }
            }
            if (elements.size() > 0) {
                SwingUtilities.invokeLater(() -> {
                    if (this.isCanceled()) {
                        return;
                    }
                    for (Object element : new ArrayList(elements)) {
                        if (!(element instanceof AnAction)) continue;
                        if (!this.isEnabled((AnAction)element)) {
                            elements.remove(element);
                        }
                        if (!this.isCanceled()) continue;
                        return;
                    }
                    if (this.isCanceled() || elements.isEmpty()) {
                        return;
                    }
                    this.myListModel.titleIndex.topHit = this.myListModel.size();
                    for (Object element : ContainerUtil.getFirstItems((List)elements, (int)15)) {
                        this.myListModel.addElement(element);
                    }
                });
            }
        }

        protected boolean isEnabled(AnAction action) {
            boolean enabled;
            if (SearchEverywhereAction.this.myDisabledActions.contains(action)) {
                return false;
            }
            AnActionEvent e = new AnActionEvent(SearchEverywhereAction.this.myActionEvent.getInputEvent(), SearchEverywhereAction.this.myActionEvent.getDataContext(), SearchEverywhereAction.this.myActionEvent.getPlace(), action.getTemplatePresentation().clone(), SearchEverywhereAction.this.myActionEvent.getActionManager(), SearchEverywhereAction.this.myActionEvent.getModifiers());
            ApplicationManager.getApplication().invokeAndWait(() -> ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)e, (boolean)false), ModalityState.NON_MODAL);
            Presentation presentation = e.getPresentation();
            boolean bl = enabled = presentation.isEnabled() && presentation.isVisible() && !StringUtil.isEmpty((String)presentation.getText());
            if (!enabled) {
                SearchEverywhereAction.this.myDisabledActions.add(action);
            }
            return enabled;
        }

        private synchronized void checkModelsUpToDate() {
            if (SearchEverywhereAction.this.myClassModel == null) {
                SearchEverywhereAction.this.myClassModel = new GotoClassModel2(this.project);
                SearchEverywhereAction.this.myFileModel = new GotoFileModel(this.project);
                SearchEverywhereAction.this.mySymbolsModel = new GotoSymbolModel2(this.project);
                SearchEverywhereAction.this.myFileChooseByName = ChooseByNamePopup.createPopup(this.project, (ChooseByNameModel)SearchEverywhereAction.this.myFileModel, (PsiElement)null);
                SearchEverywhereAction.this.myClassChooseByName = ChooseByNamePopup.createPopup(this.project, (ChooseByNameModel)SearchEverywhereAction.this.myClassModel, (PsiElement)null);
                SearchEverywhereAction.this.mySymbolsChooseByName = ChooseByNamePopup.createPopup(this.project, (ChooseByNameModel)SearchEverywhereAction.this.mySymbolsModel, (PsiElement)null);
                this.project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
                SearchEverywhereAction.this.myActionProvider = this.createActionProvider();
                SearchEverywhereAction.this.myConfigurables.clear();
                SearchEverywhereAction.this.fillConfigurablesIds(null, ShowSettingsUtilImpl.getConfigurables(this.project, true));
            }
            if (SearchEverywhereAction.this.myStructureModel == null && SearchEverywhereAction.this.myFileEditor != null && Registry.is((String)"search.everywhere.structure")) {
                this.runReadAction(() -> {
                    StructureViewBuilder structureViewBuilder = SearchEverywhereAction.this.myFileEditor.getStructureViewBuilder();
                    if (structureViewBuilder == null) {
                        return;
                    }
                    StructureView structureView = structureViewBuilder.createStructureView(SearchEverywhereAction.this.myFileEditor, this.project);
                    SearchEverywhereAction.this.myStructureModel = structureView.getTreeModel();
                }, true);
            }
        }

        private void buildModelFromRecentFiles() {
            this.buildRecentFiles("");
        }

        private GotoActionItemProvider createActionProvider() {
            GotoActionModel model = new GotoActionModel(this.project, SearchEverywhereAction.this.myFocusComponent, SearchEverywhereAction.this.myEditor, SearchEverywhereAction.this.myFile){

                @Override
                protected GotoActionModel.MatchMode actionMatches(@NotNull String pattern, MinusculeMatcher matcher, @NotNull AnAction anAction) {
                    if (pattern == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/actions/SearchEverywhereAction$CalcThread$3", "actionMatches"));
                    }
                    if (anAction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anAction", "com/intellij/ide/actions/SearchEverywhereAction$CalcThread$3", "actionMatches"));
                    }
                    GotoActionModel.MatchMode mode = super.actionMatches(pattern, matcher, anAction);
                    return mode == GotoActionModel.MatchMode.NAME ? mode : GotoActionModel.MatchMode.NONE;
                }
            };
            return new GotoActionItemProvider(model);
        }

        private void updatePopup() {
            this.check();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CalcThread.this.myListModel.update();
                    SearchEverywhereAction.this.myList.revalidate();
                    SearchEverywhereAction.this.myList.repaint();
                    SearchEverywhereAction.this.myRenderer.recalculateWidth();
                    if (SearchEverywhereAction.this.myBalloon == null || SearchEverywhereAction.this.myBalloon.isDisposed()) {
                        return;
                    }
                    if (SearchEverywhereAction.this.myPopup == null || !SearchEverywhereAction.this.myPopup.isVisible()) {
                        ScrollingUtil.installActions((JList)SearchEverywhereAction.this.myList, (JComponent)SearchEverywhereAction.this.getField().getTextEditor());
                        JBScrollPane content = new JBScrollPane((Component)SearchEverywhereAction.this.myList){
                            {
                                if (UIUtil.isUnderDarcula()) {
                                    this.setBorder(null);
                                }
                            }

                            public Dimension getPreferredSize() {
                                Dimension size = super.getPreferredSize();
                                Dimension listSize = SearchEverywhereAction.this.myList.getPreferredSize();
                                if (size.height > listSize.height || SearchEverywhereAction.this.myList.getModel().getSize() == 0) {
                                    size.height = Math.max(JBUI.scale((int)30), listSize.height);
                                }
                                if (size.width < ((SearchEverywhereAction)SearchEverywhereAction.this).myBalloon.getSize().width) {
                                    size.width = ((SearchEverywhereAction)SearchEverywhereAction.this).myBalloon.getSize().width;
                                }
                                return size;
                            }
                        };
                        content.setHorizontalScrollBarPolicy(31);
                        content.setMinimumSize(new Dimension(((SearchEverywhereAction)SearchEverywhereAction.this).myBalloon.getSize().width, 30));
                        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content, null);
                        SearchEverywhereAction.this.myPopup = builder.setRequestFocus(false).setCancelKeyEnabled(false).setResizable(true).setCancelCallback(() -> {
                            boolean canClose;
                            JBPopup balloon = SearchEverywhereAction.this.myBalloon;
                            AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
                            if (event instanceof MouseEvent) {
                                Component comp = ((MouseEvent)event).getComponent();
                                if (balloon != null && UIUtil.getWindow((Component)comp) == UIUtil.getWindow((Component)balloon.getContent())) {
                                    return false;
                                }
                            }
                            boolean bl = canClose = balloon == null || balloon.isDisposed() || !SearchEverywhereAction.this.getField().getTextEditor().hasFocus() && !SearchEverywhereAction.this.mySkipFocusGain;
                            if (canClose) {
                                PropertiesComponent.getInstance().setValue("search.everywhere.max.popup.width", Math.max(content.getWidth(), JBUI.scale((int)600)), JBUI.scale((int)600));
                            }
                            return canClose;
                        }).setShowShadow(false).setShowBorder(false).createPopup();
                        SearchEverywhereAction.this.myPopup.getContent().setBorder(null);
                        Disposer.register((Disposable)SearchEverywhereAction.this.myPopup, (Disposable)new Disposable(){

                            public void dispose() {
                                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                                    JLabel label;
                                    Component component;
                                    SearchEverywhereAction.this.resetFields();
                                    SearchEverywhereAction.this.myNonProjectCheckBox.setSelected(false);
                                    SwingUtilities.invokeLater(() -> ActionToolbarImpl.updateAllToolbarsImmediately());
                                    if (SearchEverywhereAction.this.myActionEvent != null && SearchEverywhereAction.this.myActionEvent.getInputEvent() instanceof MouseEvent && (component = SearchEverywhereAction.this.myActionEvent.getInputEvent().getComponent()) != null && (label = (JLabel)UIUtil.getParentOfType(JLabel.class, (Component)component)) != null) {
                                        SwingUtilities.invokeLater(() -> label.setIcon(AllIcons.Actions.FindPlain));
                                    }
                                    SearchEverywhereAction.this.myActionEvent = null;
                                });
                            }
                        });
                        SearchEverywhereAction.this.updatePopupBounds();
                        SearchEverywhereAction.this.myPopup.show(new RelativePoint((Component)SearchEverywhereAction.this.getField().getParent(), new Point(0, SearchEverywhereAction.this.getField().getParent().getHeight())));
                        ActionManager.getInstance().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

                            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                                if (action instanceof TextComponentEditorAction) {
                                    return;
                                }
                                if (SearchEverywhereAction.this.myPopup != null) {
                                    SearchEverywhereAction.this.myPopup.cancel();
                                }
                            }
                        }, (Disposable)SearchEverywhereAction.this.myPopup);
                    } else {
                        SearchEverywhereAction.this.myList.revalidate();
                        SearchEverywhereAction.this.myList.repaint();
                    }
                    ScrollingUtil.ensureSelectionExists((JList)SearchEverywhereAction.this.myList);
                    if (SearchEverywhereAction.this.myList.getModel().getSize() > 0) {
                        SearchEverywhereAction.this.updatePopupBounds();
                    }
                }
            });
        }

        public ActionCallback cancel() {
            this.myProgressIndicator.cancel();
            this.myDone.setRejected();
            return this.myDone;
        }

        public ActionCallback insert(int index, WidgetID id) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.runReadAction(() -> {
                try {
                    SearchResult result2 = id == WidgetID.CLASSES ? this.getClasses(this.pattern, showAll.get(), 15, SearchEverywhereAction.this.myClassChooseByName) : (id == WidgetID.FILES ? this.getFiles(this.pattern, showAll.get(), 15, SearchEverywhereAction.this.myFileChooseByName) : (id == WidgetID.RUN_CONFIGURATIONS ? this.getConfigurations(this.pattern, 15) : (id == WidgetID.SYMBOLS ? this.getSymbols(this.pattern, 15, showAll.get(), SearchEverywhereAction.this.mySymbolsChooseByName) : (id == WidgetID.ACTIONS ? this.getActionsOrSettings(this.pattern, 15, true) : (id == WidgetID.SETTINGS ? this.getActionsOrSettings(this.pattern, 15, false) : new SearchResult())))));
                    this.check();
                    SwingUtilities.invokeLater(() -> {
                        try {
                            int shift = 0;
                            int i2 = index + 1;
                            for (Object o : result2) {
                                this.myListModel.insertElementAt(o, i2);
                                ++shift;
                                ++i2;
                            }
                            MoreIndex moreIndex = this.myListModel.moreIndex;
                            this.myListModel.titleIndex.shift(index, shift);
                            moreIndex.shift(index, shift);
                            if (!result2.needMore) {
                                switch (id) {
                                    case CLASSES: {
                                        moreIndex.classes = -1;
                                        break;
                                    }
                                    case FILES: {
                                        moreIndex.files = -1;
                                        break;
                                    }
                                    case ACTIONS: {
                                        moreIndex.actions = -1;
                                        break;
                                    }
                                    case SETTINGS: {
                                        moreIndex.settings = -1;
                                        break;
                                    }
                                    case SYMBOLS: {
                                        moreIndex.symbols = -1;
                                        break;
                                    }
                                    case RUN_CONFIGURATIONS: {
                                        moreIndex.runConfigurations = -1;
                                    }
                                }
                            }
                            ScrollingUtil.selectItem((JList)SearchEverywhereAction.this.myList, (int)index);
                            this.myDone.setDone();
                        }
                        catch (Exception e) {
                            this.myDone.setRejected();
                        }
                    });
                }
                catch (Exception e) {
                    this.myDone.setRejected();
                }
            }, true));
            return this.myDone;
        }

        public ActionCallback start() {
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            return this.myDone;
        }
    }

    static enum WidgetID {
        CLASSES,
        FILES,
        ACTIONS,
        SETTINGS,
        SYMBOLS,
        RUN_CONFIGURATIONS;

    }

    private class MyListRenderer
    extends ColoredListCellRenderer {
        ColoredListCellRenderer myLocation;
        SearchEverywherePsiRenderer myFileRenderer;
        ListCellRenderer myActionsRenderer;
        private String myLocationString;
        private Icon myLocationIcon;
        private Project myProject;
        private MyAccessibleComponent myMainPanel;
        private JLabel myTitle;

        MyListRenderer(JBList myList) {
            if (myList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myList", "com/intellij/ide/actions/SearchEverywhereAction$MyListRenderer", "<init>"));
            }
            this.myLocation = new ColoredListCellRenderer(){

                protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/SearchEverywhereAction$MyListRenderer$1", "customizeCellRenderer"));
                    }
                    this.setPaintFocusBorder(false);
                    this.append(MyListRenderer.this.myLocationString, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.setIcon(MyListRenderer.this.myLocationIcon);
                }
            };
            this.myFileRenderer = new SearchEverywherePsiRenderer((JList)SearchEverywhereAction.this.myList);
            this.myActionsRenderer = new GotoActionModel.GotoActionListCellRenderer((Function<OptionDescription, String>)Function.TO_STRING);
            this.myMainPanel = new MyAccessibleComponent(new BorderLayout());
            this.myTitle = new JLabel();
            assert (myList == SearchEverywhereAction.this.myList);
        }

        public void clear() {
            super.clear();
            this.myLocation.clear();
            this.myLocationString = null;
            this.myLocationIcon = null;
        }

        public void setLocationString(String locationString) {
            this.myLocationString = locationString;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int width;
            Color bg;
            this.myLocationString = null;
            String pattern = "*" + SearchEverywhereAction.this.myPopupField.getText();
            Matcher matcher = NameUtil.buildMatcher((String)pattern, (int)0, (boolean)true, (boolean)true);
            Component cmp = SearchEverywhereAction.this.isMoreItem(index) ? More.get(isSelected) : SearchEverywhereClassifier.EP_Manager.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (cmp == null) {
                cmp = this.tryFileRenderer(matcher, list, value, index, isSelected, cellHasFocus);
            }
            if (cmp == null) {
                if (value instanceof GotoActionModel.ActionWrapper) {
                    cmp = this.myActionsRenderer.getListCellRendererComponent(list, new GotoActionModel.MatchedValue((GotoActionModel.ActionWrapper)value, pattern), index, isSelected, isSelected);
                } else {
                    cmp = super.getListCellRendererComponent(list, value, index, isSelected, isSelected);
                    JPanel p = new JPanel(new BorderLayout());
                    p.setBackground(UIUtil.getListBackground((boolean)isSelected));
                    p.add(cmp, "Center");
                    cmp = p;
                }
            }
            if (this.myLocationString != null || value instanceof BooleanOptionDescription) {
                Component rightComponent;
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setBackground(UIUtil.getListBackground((boolean)isSelected));
                panel2.add(cmp, "Center");
                if (value instanceof BooleanOptionDescription) {
                    OnOffButton button = new OnOffButton();
                    button.setSelected(((BooleanOptionDescription)value).isOptionEnabled());
                    rightComponent = button;
                } else {
                    rightComponent = this.myLocation.getListCellRendererComponent(list, value, index, isSelected, isSelected);
                }
                panel2.add(rightComponent, "East");
                cmp = panel2;
            }
            if ((bg = cmp.getBackground()) == null) {
                cmp.setBackground(UIUtil.getListBackground((boolean)isSelected));
                bg = cmp.getBackground();
            }
            this.myMainPanel.setBorder((Border)new CustomLineBorder(bg, 0, 0, 2, 0));
            String title = ((SearchEverywhereAction)SearchEverywhereAction.this).getModel().titleIndex.getTitle(index);
            this.myMainPanel.removeAll();
            if (title != null) {
                this.myTitle.setText(title);
                this.myMainPanel.add((Component)SearchEverywhereAction.createTitle(" " + title), "North");
            }
            this.myMainPanel.add(cmp, "Center");
            if (cmp instanceof Accessible) {
                this.myMainPanel.setAccessible((Accessible)((Object)cmp));
            }
            if ((width = this.myMainPanel.getPreferredSize().width) > SearchEverywhereAction.this.myPopupActualWidth) {
                SearchEverywhereAction.this.myPopupActualWidth = width;
            }
            return this.myMainPanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Component tryFileRenderer(Matcher matcher, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof VirtualFile && this.myProject != null) {
                Object object = value = ((VirtualFile)value).isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory((VirtualFile)value) : PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)value);
            }
            if (value instanceof PsiElement) {
                MatcherHolder.associateMatcher(list, matcher);
                try {
                    Component component = this.myFileRenderer.getListCellRendererComponent(list, value, index, isSelected, isSelected);
                    return component;
                }
                finally {
                    MatcherHolder.associateMatcher(list, null);
                }
            }
            return null;
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/SearchEverywhereAction$MyListRenderer", "customizeCellRenderer"));
            }
            this.setPaintFocusBorder(false);
            this.setIcon(EmptyIcon.ICON_16);
            ApplicationManager.getApplication().runReadAction(() -> {
                if (value instanceof PsiElement) {
                    String name1 = SearchEverywhereAction.this.myClassModel.getElementName(value);
                    assert (name1 != null);
                    this.append(name1);
                } else if (value instanceof ChooseRunConfigurationPopup.ItemWrapper) {
                    Executor executor;
                    ChooseRunConfigurationPopup.ItemWrapper wrapper = (ChooseRunConfigurationPopup.ItemWrapper)value;
                    this.append(wrapper.getText());
                    this.setIcon(wrapper.getIcon());
                    RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)ObjectUtils.tryCast(wrapper.getValue(), RunnerAndConfigurationSettings.class);
                    if (settings != null && (executor = SearchEverywhereAction.this.findExecutor(settings)) != null) {
                        this.setLocationString(executor.getId());
                        this.myLocationIcon = executor.getToolWindowIcon();
                    }
                } else if (SearchEverywhereAction.isVirtualFile(value)) {
                    VirtualFile file2 = (VirtualFile)value;
                    if (file2 instanceof VirtualFilePathWrapper) {
                        this.append(((VirtualFilePathWrapper)file2).getPresentablePath());
                    } else {
                        this.append(file2.getName());
                    }
                    this.setIcon(IconUtil.getIcon((VirtualFile)file2, (int)2, (Project)this.myProject));
                } else if (SearchEverywhereAction.isActionValue(value)) {
                    String groupName;
                    GotoActionModel.ActionWrapper actionWithParentGroup = value instanceof GotoActionModel.ActionWrapper ? (GotoActionModel.ActionWrapper)value : null;
                    AnAction anAction = actionWithParentGroup == null ? (AnAction)value : actionWithParentGroup.getAction();
                    Presentation templatePresentation = anAction.getTemplatePresentation();
                    Icon icon = templatePresentation.getIcon();
                    if (anAction instanceof ActivateToolWindowAction) {
                        String id = ((ActivateToolWindowAction)anAction).getToolWindowId();
                        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(id);
                        if (toolWindow != null) {
                            icon = toolWindow.getIcon();
                        }
                    }
                    this.append(String.valueOf(templatePresentation.getText()));
                    if (actionWithParentGroup != null && !StringUtil.isEmpty((String)(groupName = actionWithParentGroup.getGroupName()))) {
                        this.setLocationString(groupName);
                    }
                    String string = groupName = actionWithParentGroup == null ? null : actionWithParentGroup.getGroupName();
                    if (!StringUtil.isEmpty((String)groupName)) {
                        this.setLocationString(groupName);
                    }
                    if (icon != null && icon.getIconWidth() <= 16 && icon.getIconHeight() <= 16) {
                        this.setIcon(IconUtil.toSize((Icon)icon, (int)16, (int)16));
                    }
                } else if (SearchEverywhereAction.isSetting(value)) {
                    String text = SearchEverywhereAction.getSettingText((OptionDescription)value);
                    SimpleTextAttributes attrs = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (value instanceof Changeable && ((Changeable)value).hasChanged()) {
                        if (selected) {
                            attrs = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                        } else {
                            SimpleTextAttributes base = SimpleTextAttributes.LINK_BOLD_ATTRIBUTES;
                            attrs = base.derive(1, base.getFgColor(), null, null);
                        }
                    }
                    this.append(text, attrs);
                    String id = ((OptionDescription)value).getConfigurableId();
                    String name1 = (String)SearchEverywhereAction.this.myConfigurables.get(id);
                    if (name1 != null) {
                        this.setLocationString(name1);
                    }
                } else if (value instanceof OptionsTopHitProvider) {
                    this.append("#" + ((OptionsTopHitProvider)value).getId());
                } else {
                    ItemPresentation presentation = null;
                    if (value instanceof ItemPresentation) {
                        presentation = (ItemPresentation)value;
                    } else if (value instanceof NavigationItem) {
                        presentation = ((NavigationItem)value).getPresentation();
                    }
                    if (presentation != null) {
                        Icon icon;
                        String text = presentation.getPresentableText();
                        this.append(text == null ? value.toString() : text);
                        String location = presentation.getLocationString();
                        if (!StringUtil.isEmpty((String)location)) {
                            this.setLocationString(location);
                        }
                        if ((icon = presentation.getIcon(false)) != null) {
                            this.setIcon(icon);
                        }
                    }
                }
            });
        }

        public void recalculateWidth() {
            ListModel model = SearchEverywhereAction.this.myList.getModel();
            this.myTitle.setIcon(EmptyIcon.ICON_16);
            this.myTitle.setFont(SearchEverywhereAction.getTitleFont());
            for (int index = 0; index < model.getSize(); ++index) {
                String title = ((SearchEverywhereAction)SearchEverywhereAction.this).getModel().titleIndex.getTitle(index);
                if (title == null) continue;
                this.myTitle.setText(title);
            }
            this.myTitle.setForeground((Color)Gray._122);
            this.myTitle.setAlignmentY(1.0f);
        }

        private class MyAccessibleComponent
        extends JPanel {
            private Accessible myAccessible;

            public MyAccessibleComponent(LayoutManager layout) {
                super(layout);
            }

            void setAccessible(Accessible comp) {
                this.myAccessible = comp;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                this.accessibleContext = this.myAccessible != null ? this.myAccessible.getAccessibleContext() : super.getAccessibleContext();
                return this.accessibleContext;
            }
        }
    }

    private static class MySearchTextField
    extends SearchTextField
    implements DataProvider,
    Disposable {
        public MySearchTextField() {
            super(false);
            JBTextField editor = this.getTextEditor();
            editor.setOpaque(false);
            if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
                editor.setUI((MacIntelliJTextFieldUI)MacIntelliJTextFieldUI.createUI((JComponent)editor));
                editor.setBorder(new MacIntelliJTextBorder());
            } else {
                editor.setUI((DarculaTextFieldUI)DarculaTextFieldUI.createUI((JComponent)editor));
                editor.setBorder(new DarculaTextBorder());
            }
            editor.putClientProperty("JTextField.Search.noBorderRing", Boolean.TRUE);
            if (UIUtil.isUnderDarcula()) {
                editor.setBackground((Color)Gray._45);
                editor.setForeground((Color)Gray._240);
            }
        }

        protected boolean isSearchControlUISupported() {
            return true;
        }

        protected boolean hasIconsOutsideOfTextField() {
            return false;
        }

        protected void showPopup() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
                return this.getTextEditor().getText();
            }
            return null;
        }

        public void dispose() {
        }
    }

    static class SEOption
    extends BooleanOptionDescription {
        private final String myKey;

        public SEOption(String option, String registryKey) {
            super(option, null);
            this.myKey = registryKey;
        }

        public boolean isOptionEnabled() {
            return Registry.is((String)this.myKey);
        }

        public void setOptionState(boolean enabled) {
            Registry.get((String)this.myKey).setValue(enabled);
        }
    }
}

