/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SaveAsDirectoryBasedFormatAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (!SaveAsDirectoryBasedFormatAction.isConvertableProject(project2) || Messages.showOkCancelDialog((Project)project2, (String)"Project will be saved and reopened in new Directory-Based format.\nAre you sure you want to continue?", (String)"Save Project to Directory-Based Format", (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        IProjectStore store = ProjectKt.getStateStore(project2);
        String baseDir = PathUtilRt.getParentPath((String)store.getProjectFilePath());
        File ideaDir = new File(baseDir, ".idea");
        if (ideaDir.exists() && ideaDir.isDirectory() || SaveAsDirectoryBasedFormatAction.createDir(ideaDir)) {
            LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ideaDir);
            store.clearStorages();
            store.setPath(baseDir);
            project2.save();
            ProjectUtil.closeAndDispose(project2);
            ProjectUtil.openProject(baseDir, null, false);
        } else {
            Messages.showErrorDialog((Project)project2, (String)String.format("Unable to create '.idea' directory (%s)", ideaDir), (String)"Error Saving Project!");
        }
    }

    private static boolean createDir(File ideaDir) {
        try {
            VfsUtil.createDirectories((String)ideaDir.getPath());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        e.getPresentation().setVisible(SaveAsDirectoryBasedFormatAction.isConvertableProject(project2));
    }

    private static boolean isConvertableProject(@Nullable Project project2) {
        return project2 != null && !project2.isDefault() && !ProjectKt.isDirectoryBased(project2);
    }
}

